/*
 * Decompiled with CFR 0.152.
 */
package com.lootbeams.extensions;

import com.lootbeams.helpers.StringHelper;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.class_1047;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_2960;

public abstract class AnimatedTexture {
    private static final String COLORED_POSTFIX = "_colored";
    private static final Map<Class<?>, Map<String, AnimatedTexture>> TEXTURE_CACHE = new HashMap();
    public class_2960 id;
    public String path;
    private boolean isSpriteSplitted = false;
    private int frameCount = 0;

    public AnimatedTexture(class_2960 id) {
        this.id = id;
        this.path = id.toString();
    }

    public abstract class_1059 getSpriteAtlasTexture();

    private boolean isMissing(class_1058 sprite) {
        return sprite.method_45851().method_45816() == class_1047.method_4539();
    }

    public int getFrameCount() {
        return this.frameCount;
    }

    public boolean isColored() {
        return this.path.endsWith(COLORED_POSTFIX);
    }

    private void processSplittedSprite() {
        List<class_1058> spriteList = this.getSpriteAtlasTexture().field_5280.values().stream().filter(sprite -> sprite.method_45851().method_45816().toString().matches(Pattern.quote(this.id.toString()) + "_\\d+")).toList();
        if (!spriteList.isEmpty()) {
            this.isSpriteSplitted = true;
            this.frameCount = spriteList.size();
        }
    }

    public class_1058 getSprite() {
        class_1058 sprite = this.getSpriteAtlasTexture().method_4608(this.id);
        if (this.isMissing(sprite)) {
            return this.getSprite(0);
        }
        return sprite;
    }

    public class_1058 getSprite(int frameIndex) {
        class_1058 sprite = this.getSpriteAtlasTexture().method_4608(new class_2960(this.id.toString() + "_" + frameIndex));
        if (!this.isMissing(sprite) && !this.isSplitted()) {
            this.processSplittedSprite();
        }
        return sprite;
    }

    public class_2960 getAtlasId() {
        return this.getSpriteAtlasTexture().method_24106();
    }

    public boolean isSplitted() {
        return this.isSpriteSplitted;
    }

    public String toString() {
        return this.path;
    }

    public String getDisplayName() {
        String displayName = this.path;
        if (displayName.endsWith(COLORED_POSTFIX)) {
            displayName = displayName.substring(0, displayName.length() - COLORED_POSTFIX.length());
        }
        return StringHelper.capitalize(String.join((CharSequence)" ", displayName.replace(this.id.method_12836() + ":", "").split("_")));
    }

    public static <T extends AnimatedTexture> Map<String, AnimatedTexture> getTextureCacheMap(Class<T> type) {
        if (!TEXTURE_CACHE.containsKey(type)) {
            TEXTURE_CACHE.put(type, new HashMap());
        }
        return TEXTURE_CACHE.get(type);
    }

    public static String toResourcePath(String displayName, String namespace) {
        return namespace + ":" + displayName.trim().toLowerCase().replace(" ", "_");
    }

    public static <T extends AnimatedTexture> T of(class_2960 id, Class<T> type) {
        String resourcePath = id.toString();
        return AnimatedTexture.of(resourcePath, "", type);
    }

    public static <T extends AnimatedTexture> T of(String path, String namespace, Class<T> type) {
        Map<String, AnimatedTexture> MAP;
        String resourcePath = path;
        if (!resourcePath.contains(namespace)) {
            resourcePath = AnimatedTexture.toResourcePath(resourcePath, namespace);
        }
        if ((MAP = AnimatedTexture.getTextureCacheMap(type)).containsKey(resourcePath)) {
            return (T)((AnimatedTexture)type.cast(MAP.get(resourcePath)));
        }
        try {
            Constructor<T> constructor = type.getConstructor(class_2960.class);
            AnimatedTexture instance = (AnimatedTexture)constructor.newInstance(new class_2960(resourcePath));
            MAP.put(resourcePath, instance);
            return (T)instance;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to instantiate texture", e);
        }
    }

    public static <T extends AnimatedTexture> List<T> getAnimatedTextures(class_1059 atlasTexture, Class<T> type) {
        ArrayList<T> animatedTextures = new ArrayList<T>();
        for (class_1058 sprite : atlasTexture.field_5280.values()) {
            if (!sprite.method_45851().method_45816().method_12836().equals("lootbeams")) continue;
            animatedTextures.add(AnimatedTexture.of(sprite.method_45851().method_45816(), type));
        }
        return animatedTextures;
    }
}

