/*
 * Decompiled with CFR 0.152.
 */
package com.lootbeams.managers;

import com.lootbeams.contexts.WorldRendererContext;
import com.lootbeams.extensions.LootbeamsParticleManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_1542;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_638;

public class RenderManager {
    public static final List<class_1542> LIGHT_CACHE = new ArrayList<class_1542>();
    private static final List<Consumer<class_4587>> RENDER_BEFORE_PARTICLES = new ArrayList<Consumer<class_4587>>();
    private static final List<Consumer<class_4587>> RENDER_AFTER_TRANSLUCENT = new ArrayList<Consumer<class_4587>>();
    private static final List<Consumer<class_4587>> RENDER_AFTER_WEATHER = new ArrayList<Consumer<class_4587>>();
    private static final List<Consumer<class_4587>> RENDER_BEFORE_END = new ArrayList<Consumer<class_4587>>();
    private static final Map<class_1542, Boolean> ITEM_RENDER_STATES = new HashMap<class_1542, Boolean>();
    private static final Map<Class<?>, Consumer<WorldRendererContext>> END_RENDERS = new HashMap();

    public static void onWorldRenderBeforeParticles(WorldRendererContext worldRendererContext) {
        RenderManager.renderBeforeParticles(worldRendererContext.getMatrixStack(), worldRendererContext.getCamera().method_19326());
    }

    public static void onWorldRenderAfterTranslucent(WorldRendererContext worldRendererContext) {
        RenderManager.renderAfterTranslucent(worldRendererContext.getMatrixStack(), worldRendererContext.getCamera().method_19326());
    }

    public static void onWorldRenderAfterWeather(WorldRendererContext worldRendererContext) {
        RenderManager.renderAfterWeather(worldRendererContext.getMatrixStack(), worldRendererContext.getCamera().method_19326());
        LootbeamsParticleManager particleManager = (LootbeamsParticleManager)class_310.method_1551().field_1713;
        if (particleManager != null) {
            particleManager.renderCustomParticles(worldRendererContext.getMatrixStack(), worldRendererContext.getConsumers(), worldRendererContext.getLightmapTextureManager(), worldRendererContext.getCamera(), worldRendererContext.getTickDelta());
        }
    }

    public static void onWorldRenderBeforeEnd(WorldRendererContext worldRendererContext) {
        RenderManager.renderBeforeEnd(worldRendererContext.getMatrixStack(), worldRendererContext.getCamera().method_19326());
    }

    public static void onWorldRenderEnd(WorldRendererContext worldRendererContext) {
        RenderManager.afterRender(worldRendererContext);
        RENDER_BEFORE_PARTICLES.clear();
        RENDER_AFTER_TRANSLUCENT.clear();
        RENDER_AFTER_WEATHER.clear();
        RENDER_BEFORE_END.clear();
        END_RENDERS.clear();
    }

    public static void onEntityLoad(class_1542 itemEntity, class_638 world) {
        if (!LIGHT_CACHE.contains(itemEntity)) {
            LIGHT_CACHE.add(itemEntity);
        }
    }

    public static void onEntityUnload(class_1542 itemEntity, class_638 world) {
        LIGHT_CACHE.remove(itemEntity);
    }

    public static void renderAfter(class_4587 stack, class_243 cameraPos, List<Consumer<class_4587>> consumers) {
        if (stack == null) {
            return;
        }
        stack.method_22903();
        stack.method_22904(-cameraPos.field_1352, -cameraPos.field_1351, -cameraPos.field_1350);
        consumers.forEach(consumer -> consumer.accept(stack));
        stack.method_22909();
    }

    public static void afterRender(WorldRendererContext context) {
        END_RENDERS.values().forEach(consumer -> consumer.accept(context));
    }

    public static void renderBeforeParticles(class_4587 stack, class_243 cameraPos) {
        RenderManager.renderAfter(stack, cameraPos, RENDER_BEFORE_PARTICLES);
    }

    public static void renderAfterTranslucent(class_4587 stack, class_243 cameraPos) {
        RenderManager.renderAfter(stack, cameraPos, RENDER_AFTER_TRANSLUCENT);
    }

    public static void renderAfterWeather(class_4587 stack, class_243 cameraPos) {
        RenderManager.renderAfter(stack, cameraPos, RENDER_AFTER_WEATHER);
    }

    public static void renderBeforeEnd(class_4587 stack, class_243 cameraPos) {
        RenderManager.renderAfter(stack, cameraPos, RENDER_BEFORE_END);
    }

    public static void addRenderBeforeParticles(Consumer<class_4587> render) {
        RENDER_BEFORE_PARTICLES.add(render);
    }

    public static void addRenderAfterTranslucent(Consumer<class_4587> render) {
        RENDER_AFTER_TRANSLUCENT.add(render);
    }

    public static void setRendering(class_1542 itemEntity, boolean isRendering) {
        ITEM_RENDER_STATES.put(itemEntity, isRendering);
    }

    public static boolean isRendering(class_1542 itemEntity) {
        return ITEM_RENDER_STATES.getOrDefault(itemEntity, false);
    }

    public static void addRenderAfterWeather(Consumer<class_4587> render) {
        RENDER_AFTER_WEATHER.add(render);
    }

    public static void addRenderBeforeEnd(Consumer<class_4587> render) {
        RENDER_BEFORE_END.add(render);
    }

    public static void addOnRenderEnd(Class<?> parentClass, Consumer<WorldRendererContext> render) {
        if (!END_RENDERS.containsKey(parentClass)) {
            END_RENDERS.put(parentClass, render);
        }
    }
}

