/*
 * Decompiled with CFR 0.152.
 */
package com.lootbeams.renderers;

import com.lootbeams.LootBeams;
import com.lootbeams.compat.prism.PrismCompat;
import com.lootbeams.config.Configuration;
import com.lootbeams.features.CustomLootBeamsConfig;
import com.lootbeams.helpers.ColorHelper;
import com.lootbeams.helpers.NumberHelper;
import com.lootbeams.render.LootBeamRenderLayers;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5251;
import net.minecraft.class_7833;
import org.joml.Matrix4f;

public class DroplightRenderer {
    private static class_2960 LIGHT_BEAM_TEXTURE = LootBeams.id("textures/misc/light_beam.png");
    private static class_2960 LIGHT_BEAM_MASK_TEXTURE = LootBeams.id("textures/misc/light_beam_mask.png");

    public static void renderBeam(class_4597 buffer, class_1542 itemEntity, class_4587 matrixStack, class_5251 color, float beamAlpha, float currentGroundTime) {
        class_310 minecraft = class_310.method_1551();
        class_4184 camera = minecraft.field_1773.method_19418();
        class_1799 stack = itemEntity.method_6983();
        Configuration itemConfig = CustomLootBeamsConfig.fromItemStack(stack);
        float beamHeight = itemConfig.beamHeight;
        float beamWidth = itemConfig.beamRadius;
        float yOffset = itemConfig.beamYOffset;
        if (itemConfig.smoothBeamSize) {
            beamHeight = NumberHelper.smoothValue(beamHeight, currentGroundTime, itemConfig.smoothDuration);
            beamWidth = NumberHelper.smoothValue(beamWidth, currentGroundTime, itemConfig.smoothDuration);
            yOffset = NumberHelper.smoothValue(yOffset, currentGroundTime, itemConfig.smoothDuration);
        }
        class_5251 color2 = DroplightRenderer.getSecondColor(color, itemConfig.beamGradientModifiers);
        RenderSystem.setShaderTexture((int)1, (int)minecraft.method_1522().method_30278());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)beamAlpha);
        matrixStack.method_22903();
        matrixStack.method_22904(0.0, 0.015, 0.0);
        matrixStack.method_22903();
        matrixStack.method_22907(class_7833.field_40716.rotationDegrees(-camera.method_19330()));
        class_1921 droplightLayer = LootBeamRenderLayers.droplight(LIGHT_BEAM_MASK_TEXTURE);
        class_4588 builder = buffer.getBuffer(droplightLayer);
        DroplightRenderer.renderQuad(builder, matrixStack, color.method_27716(), color2.method_27716(), beamAlpha, 0.0f, 1.2f + yOffset, -0.001f, 0.5f * beamWidth, 2.5f, 0.0f, 0.0f, 1.0f, 1.0f, true);
        if (beamHeight > 0.0f) {
            droplightLayer = LootBeamRenderLayers.droplight(LIGHT_BEAM_TEXTURE);
            builder = buffer.getBuffer(droplightLayer);
            DroplightRenderer.renderQuad(builder, matrixStack, color.method_27716(), color2.method_27716(), beamAlpha, 0.0f, beamHeight / 2.0f + yOffset, 0.0f, beamWidth, beamHeight, 0.0f, 0.0f, 1.0f, 1.0f, true);
        }
        matrixStack.method_22909();
        matrixStack.method_22909();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static class_5251 getSecondColor(float r, float g, float b, float a, List<String> modifiers) {
        int R = (int)(r * 255.0f);
        int G = (int)(g * 255.0f);
        int B = (int)(b * 255.0f);
        int A = (int)(a * 255.0f);
        return DroplightRenderer.getSecondColor(class_5251.method_27717((int)ColorHelper.build(A, R, G, B)), modifiers);
    }

    public static class_5251 getSecondColor(class_5251 color, List<String> modifiers) {
        if (PrismCompat.isPrismLoaded()) {
            return PrismCompat.applyModifiers(modifiers, color);
        }
        ColorHelper.Color newColor = new ColorHelper.Color(color.method_27716()).applyModifiers(modifiers);
        return class_5251.method_27717((int)(newColor.getRgb() & 0xFFFFFF));
    }

    private static void renderQuad(class_4588 builder, class_4587 matrixStack, int color, int color2, float alpha, float x, float y, float z, float w, float h, float u, float v, float u2, float v2, boolean fade) {
        Matrix4f positionMatrix = matrixStack.method_23760().method_23761();
        float alpha2 = fade ? 0.0f : alpha;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color >> 0 & 0xFF) / 255.0f;
        float red2 = (float)(color2 >> 16 & 0xFF) / 255.0f;
        float green2 = (float)(color2 >> 8 & 0xFF) / 255.0f;
        float blue2 = (float)(color2 >> 0 & 0xFF) / 255.0f;
        builder.method_22918(positionMatrix, x - w / 2.0f, y - h / 2.0f, z).method_22913(u, v2).method_22915(red, green, blue, alpha).method_22915(red2, green2, blue2, alpha).method_1344();
        builder.method_22918(positionMatrix, x + w / 2.0f, y - h / 2.0f, z).method_22913(u2, v2).method_22915(red, green, blue, alpha).method_22915(red2, green2, blue2, alpha).method_1344();
        builder.method_22918(positionMatrix, x + w / 2.0f, y + h / 2.0f, z).method_22913(u2, v).method_22915(red, green, blue, alpha2).method_22915(red2, green2, blue2, alpha2).method_1344();
        builder.method_22918(positionMatrix, x - w / 2.0f, y + h / 2.0f, z).method_22913(u, v).method_22915(red, green, blue, alpha2).method_22915(red2, green2, blue2, alpha2).method_1344();
    }
}

