/*
 * Decompiled with CFR 0.152.
 */
package com.lootbeams.renderers;

import com.lootbeams.LootBeams;
import com.lootbeams.config.Configuration;
import com.lootbeams.extensions.LootbeamsBufferBuilder;
import com.lootbeams.features.CustomLootBeamsConfig;
import com.lootbeams.helpers.ColorHelper;
import com.lootbeams.helpers.NumberHelper;
import com.lootbeams.helpers.RarityHelper;
import com.lootbeams.helpers.TargetHelper;
import com.lootbeams.helpers.TextColorHelper;
import com.lootbeams.managers.ParticleManager;
import com.lootbeams.managers.TooltipManager;
import com.lootbeams.render.LootBeamRenderLayers;
import com.lootbeams.renderers.DroplightRenderer;
import com.lootbeams.shaders.LootBeamShaders;
import com.lootbeams.vfx.VFXParticleType;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.WeakHashMap;
import net.minecraft.class_1058;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3544;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5251;
import net.minecraft.class_746;
import net.minecraft.class_7833;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public abstract class LootBeamRenderer
extends class_1921 {
    private static final Map<class_1542, Integer> ITEM_GROUND_START_TIMES = new HashMap<class_1542, Integer>();
    private static final class_1921 LOOT_BEAM_CENTER_LAYER = LootBeamRenderLayers.lootBeamCenter();
    private static class_1921 LOOT_BEAM_LAYER = LootBeamRenderLayers.lootBeam(LootBeams.config);
    private static final Random RANDOM = new Random();
    private static final float TICK_PER_SECOND = 20.0f;
    private static final WeakHashMap<class_1542, Float> nextParticleSpawnTicks = new WeakHashMap();

    public LootBeamRenderer(String string, class_293 vertexFormat, class_293.class_5596 mode, int i, boolean bl, boolean bl2, Runnable runnable, Runnable runnable2) {
        super(string, vertexFormat, mode, i, bl, bl2, runnable, runnable2);
    }

    public static void onConfigurationChange() {
        LOOT_BEAM_LAYER = LootBeamRenderLayers.lootBeam(LootBeams.config);
    }

    public static void renderLootBeam(class_4587 stack, class_4597 buffer, float pticks, long worldtime, class_1542 item) {
        if (!ITEM_GROUND_START_TIMES.containsKey(item)) {
            ITEM_GROUND_START_TIMES.put(item, item.method_6985());
        }
        Configuration itemConfig = CustomLootBeamsConfig.fromItemStack(item.method_6983());
        float beamAlpha = itemConfig.beamAlpha;
        float fadeDistance = itemConfig.fadeDistance * 4.0f;
        class_746 player = class_310.method_1551().field_1724;
        double distance = player.method_5858((class_1297)item);
        if (distance < (double)fadeDistance) {
            beamAlpha = !itemConfig.beamFadeOnApproach ? (beamAlpha *= (float)NumberHelper.remapNumber(Float.valueOf((float)distance), (double)fadeDistance * 0.2, Float.valueOf(fadeDistance), 1, 0)) : (beamAlpha *= (float)NumberHelper.remapNumber(Float.valueOf((float)distance), (double)fadeDistance * 0.2, Float.valueOf(fadeDistance), 0, 1));
        } else {
            return;
        }
        if (beamAlpha <= 0.01f) {
            return;
        }
        RenderSystem.enableDepthTest();
        float itemGroundStartTime = ITEM_GROUND_START_TIMES.getOrDefault(item, 0).intValue();
        float currentGroundTime = (float)item.method_6985() - itemGroundStartTime + pticks;
        float glowBeamAlpha = beamAlpha * 0.4f;
        float beamRadius = 0.05f * itemConfig.beamRadius;
        float glowRadius = beamRadius + beamRadius * 0.2f;
        float beamHeight = itemConfig.beamHeight;
        float yOffset = itemConfig.beamYOffset;
        if (itemConfig.commonShorterBeam && !RarityHelper.rarityCheck(item.method_6983(), false)) {
            beamHeight *= 0.65f;
        }
        if (itemConfig.smoothBeamSize) {
            beamHeight = NumberHelper.smoothValue(beamHeight, currentGroundTime, itemConfig.smoothDuration);
            yOffset = NumberHelper.smoothValue(yOffset, currentGroundTime, itemConfig.smoothDuration);
            beamRadius = NumberHelper.smoothValue(beamRadius, currentGroundTime, itemConfig.smoothDuration);
            glowRadius = NumberHelper.smoothValue(glowRadius, currentGroundTime, itemConfig.smoothDuration);
        }
        class_5251 color = TextColorHelper.getItemColor(item.method_6983());
        float R = (float)(color.method_27716() >> 16 & 0xFF) / 255.0f;
        float G = (float)(color.method_27716() >> 8 & 0xFF) / 255.0f;
        float B = (float)(color.method_27716() & 0xFF) / 255.0f;
        if (item.method_24828()) {
            float entityTime = item.method_6985();
            stack.method_22903();
            if (itemConfig.glowEffect) {
                stack.method_22903();
                stack.method_46416(0.0f, 0.001f, 0.0f);
                if (itemConfig.rotateGlow) {
                    float rotationSpeed = itemConfig.glowRotationSpeed;
                    float rotation = currentGroundTime * rotationSpeed % 360.0f;
                    float rotationDirection = itemConfig.glowRotateClockwise ? -1.0f : 1.0f;
                    stack.method_22907(class_7833.field_40716.rotationDegrees(rotation * rotationDirection));
                }
                class_1058 glowEffectSprite = itemConfig.glowEffectTexture.getSprite();
                class_1921 glowLayer = LootBeamRenderLayers.glowNoCull(glowEffectSprite.method_45852(), itemConfig.glowEffectTexture.isColored(), itemConfig.useGlowGradient);
                float radius = itemConfig.glowEffectRadius;
                float glowEffectAlpha = beamAlpha * itemConfig.glowEffectAlpha;
                if (itemConfig.pulseGlow) {
                    float pulseSpeed = itemConfig.pulseGlowSpeed / 10.0f;
                    float pulseMinAlpha = itemConfig.pulseGlowMinAlpha;
                    float pulseMaxAlpha = itemConfig.pulseGlowMaxAlpha;
                    float pulseMinRadius = itemConfig.pulseGlowMinRadius;
                    float pulseMaxRadius = itemConfig.pulseGlowMaxRadius;
                    float cosineFactor = (float)Math.cos((entityTime + pticks) * pulseSpeed);
                    float normalizedCosine = cosineFactor * 0.5f + 0.5f;
                    float pulseAlpha = (float)NumberHelper.remapNumber(Float.valueOf(normalizedCosine), 0, 1, Float.valueOf(pulseMinAlpha), Float.valueOf(pulseMaxAlpha));
                    float pulseRadius = (float)NumberHelper.remapNumber(Float.valueOf(normalizedCosine), 0, 1, Float.valueOf(pulseMinRadius), Float.valueOf(pulseMaxRadius));
                    glowEffectAlpha = pulseAlpha * beamAlpha;
                    radius = pulseRadius;
                }
                float glowR = R;
                float glowG = G;
                float glowB = B;
                if (itemConfig.glowEffectTexture.isColored()) {
                    float averageColor;
                    glowR = averageColor = LootBeamShaders.getAverageColor(LootBeamShaders.Shader.GLOW_OVERLAY);
                    glowG = averageColor;
                    glowB = averageColor;
                }
                if (itemConfig.smoothGlowEffectRadius) {
                    radius = NumberHelper.smoothValue(radius, currentGroundTime, itemConfig.smoothDuration);
                }
                if (itemConfig.smoothGlowEffectAlpha) {
                    glowEffectAlpha = NumberHelper.smoothValue(glowEffectAlpha, currentGroundTime, itemConfig.smoothDuration);
                }
                LootBeamRenderer.renderGlow(stack, buffer.getBuffer(glowLayer), glowR, glowG, glowB, glowEffectAlpha, radius, glowEffectSprite, !itemConfig.glowEffectTexture.isColored() && itemConfig.useGlowGradient, itemConfig.glowGradientModifiers, itemConfig.glowGradientStart / 100.0f, itemConfig.glowGradientEnd / 100.0f);
                stack.method_22909();
            }
            if (itemConfig.renderBeam) {
                if (itemConfig.renderDroplightBeam) {
                    DroplightRenderer.renderBeam(buffer, item, stack, color, beamAlpha, currentGroundTime);
                } else {
                    stack.method_22903();
                    float rotation = (float)Math.floorMod(worldtime, 40L) + pticks;
                    stack.method_22907(class_7833.field_40716.rotationDegrees(rotation * 2.25f - 45.0f));
                    LootBeamRenderer.renderBeamLayer(stack, buffer.getBuffer(LOOT_BEAM_LAYER), R, G, B, beamAlpha, 0.0f, beamHeight, 0.0f, beamRadius, beamRadius, 0.0f, -beamRadius, 0.0f, 0.0f, -beamRadius, itemConfig.solidBeam, yOffset);
                    stack.method_22909();
                    LootBeamRenderer.renderBeamLayer(stack, buffer.getBuffer(LOOT_BEAM_LAYER), R, G, B, glowBeamAlpha, 0.0f, beamHeight, -glowRadius, -glowRadius, glowRadius, -glowRadius, -glowRadius, glowRadius, glowRadius, glowRadius, itemConfig.solidBeam, yOffset);
                    if (itemConfig.whiteCenter) {
                        float colorShift = 0.25f;
                        float sR = Math.min(R + colorShift, 1.0f);
                        float sG = Math.min(G + colorShift, 1.0f);
                        float sB = Math.min(B + colorShift, 1.0f);
                        LootBeamRenderer.renderBeamLayer(stack, buffer.getBuffer(LOOT_BEAM_CENTER_LAYER), sR, sG, sB, beamAlpha, 0.0f, beamHeight, 0.0f, beamRadius * 0.4f, beamRadius * 0.4f, 0.0f, -beamRadius * 0.4f, 0.0f, 0.0f, -beamRadius * 0.4f, itemConfig.solidBeam, yOffset);
                    }
                }
            }
            stack.method_22909();
            if (itemConfig.renderNametags) {
                LootBeamRenderer.renderNameTag(stack, buffer, item, color);
            }
            if (itemConfig.particles && (!itemConfig.particleRareOnly || RarityHelper.rarityCheck(item.method_6983(), false))) {
                LootBeamRenderer.renderParticles(pticks, item, (int)entityTime, R, G, B, beamAlpha);
            }
        }
        RenderSystem.disableDepthTest();
        ITEM_GROUND_START_TIMES.keySet().removeIf(itemEntity -> !itemEntity.method_24828());
    }

    private static void renderBeamLayer(class_4587 stack, class_4588 builder, float red, float green, float blue, float alpha, float y, float height, float radius_1, float radius_2, float radius_3, float radius_4, float radius_5, float radius_6, float radius_7, float radius_8, boolean solidBeam, float yOffset) {
        float halfHeight = height / 2.0f;
        stack.method_22903();
        stack.method_46416(0.0f, yOffset, 0.0f);
        if (!solidBeam) {
            stack.method_46416(0.0f, halfHeight, 0.0f);
            stack.method_22907(class_7833.field_40714.rotationDegrees(180.0f));
        }
        LootBeamRenderer.renderPart(stack, builder, red, green, blue, alpha, y, height, radius_1, radius_2, radius_3, radius_4, radius_5, radius_6, radius_7, radius_8, false);
        if (!solidBeam) {
            stack.method_22907(class_7833.field_40714.rotationDegrees(-180.0f));
        }
        LootBeamRenderer.renderPart(stack, builder, red, green, blue, alpha, y, height, radius_1, radius_2, radius_3, radius_4, radius_5, radius_6, radius_7, radius_8, solidBeam);
        stack.method_22909();
    }

    private static void renderParticles(float pticks, class_1542 item, int entityTime, float r, float g, float b, float a) {
        if (class_310.method_1551().method_1493()) {
            return;
        }
        Configuration itemConfig = CustomLootBeamsConfig.fromItemStack(item.method_6983());
        if (!nextParticleSpawnTicks.containsKey(item)) {
            nextParticleSpawnTicks.put(item, Float.valueOf(20.0f / itemConfig.particleCount));
        }
        float particleCount = itemConfig.particleCount;
        float currentTick = (float)entityTime % 20.0f;
        float currentTickValue = currentTick + pticks;
        float ticksPerOneParticle = 20.0f / particleCount;
        if (currentTick == 0.0f && nextParticleSpawnTicks.get(item).floatValue() >= 20.0f) {
            nextParticleSpawnTicks.put(item, Float.valueOf(ticksPerOneParticle));
        }
        if (currentTickValue >= nextParticleSpawnTicks.get(item).floatValue()) {
            nextParticleSpawnTicks.put(item, Float.valueOf(((float)Math.floor(currentTickValue / ticksPerOneParticle) + 1.0f) * ticksPerOneParticle));
            float particleSize = itemConfig.particleRandomSize ? RANDOM.nextFloat(0.25f * itemConfig.particleSize, 1.1f * itemConfig.particleSize) : itemConfig.particleSize;
            float particleSpeed = itemConfig.particleSpeed;
            float particleRadius = itemConfig.particleRadius;
            float randomnessIntensity = itemConfig.randomnessIntensity;
            class_243 randomDir = new class_243(RANDOM.nextDouble(-particleSpeed / 2.0f, particleSpeed / 2.0f), itemConfig.particleRandomY ? RANDOM.nextDouble(particleSpeed / 2.0f, particleSpeed) : (double)particleSpeed, RANDOM.nextDouble(-particleSpeed / 2.0f, particleSpeed / 2.0f)).method_18805((double)randomnessIntensity, (double)randomnessIntensity, (double)randomnessIntensity);
            class_243 particleDir = new class_243((double)itemConfig.particleDirectionX, (double)itemConfig.particleDirectionY, (double)itemConfig.particleDirectionZ).method_18806(randomDir);
            ParticleManager.ParticleTexture texture = itemConfig.particleTexture;
            double particleY = itemConfig.particleRandomY ? RANDOM.nextDouble(item.method_23318() + (double)itemConfig.particleYOffset - (double)(particleRadius / 3.0f), item.method_23318() + (double)itemConfig.particleYOffset + (double)(particleRadius / 3.0f)) : item.method_23318() + (double)itemConfig.particleYOffset + (double)(particleSize / 10.0f);
            LootBeamRenderer.addParticle(texture, r, g, b, a, itemConfig.particleLifetime, particleSize, new class_243(RANDOM.nextDouble(item.method_23317() - (double)particleRadius, item.method_23317() + (double)particleRadius), particleY, RANDOM.nextDouble(item.method_23321() - (double)particleRadius, item.method_23321() + (double)particleRadius)), particleDir, item);
        }
    }

    private static void addParticle(ParticleManager.ParticleTexture texture, float red, float green, float blue, float alpha, int lifetime, float size, class_243 pos, class_243 motion, class_1542 itemEntity) {
        class_310 mc = class_310.method_1551();
        VFXParticleType glowParticle = ParticleManager.GLOW_PARTICLE.setTexture(texture).setColor(red, green, blue, alpha *= 1.5f).setLifetime(lifetime).setSize(size).setSourcePos(itemEntity.method_19538()).setGravity(0.0f).setCollision(false).setFullbright(true).setItemStack(itemEntity.method_6983());
        if (mc.field_1687 != null) {
            mc.field_1687.method_8406((class_2394)glowParticle, pos.field_1352, pos.field_1351, pos.field_1350, motion.field_1352, motion.field_1351, motion.field_1350);
        }
    }

    private static class_4588 addGlowVertex(class_4588 builder, class_4587.class_4665 matrixEntry, float x, float y, float z, float red, float green, float blue, float alpha, float u, float v) {
        Matrix4f poseMatrix = matrixEntry.method_23761();
        return builder.method_22918(poseMatrix, x, y, z).method_22913(u, v).method_22915(red, green, blue, alpha);
    }

    private static class_4588 modifyGlowVertex(class_4588 builder, ColorHelper.Color color1, float centerU, float centerV, float uvWidth, float uvHeight, float gradientStart, float gradientEnd, boolean useGlowGradient) {
        if (useGlowGradient) {
            builder.method_22915(color1.fR, color1.fG, color1.fB, color1.fA);
            ((LootbeamsBufferBuilder)builder).uvCenter(centerU, centerV);
            ((LootbeamsBufferBuilder)builder).uvSize(uvWidth, uvHeight);
            ((LootbeamsBufferBuilder)builder).gradientBounds(gradientStart, gradientEnd);
        }
        return builder;
    }

    private static void renderGlow(class_4587 stack, class_4588 builder, float red, float green, float blue, float alpha, float radius, class_1058 glowSprite, boolean useGlowGradient, List<String> gradientModifiers, float gradientStart, float gradientEnd) {
        class_4587.class_4665 matrixentry = stack.method_23760();
        float minX = glowSprite.method_4594();
        float maxX = glowSprite.method_4577();
        float minY = glowSprite.method_4593();
        float maxY = glowSprite.method_4575();
        float centerU = (minX + maxX) / 2.0f;
        float centerV = (minY + maxY) / 2.0f;
        float uvWidth = maxX - minX;
        float uvHeight = maxY - minY;
        ColorHelper.Color secondColor = ColorHelper.Color.of(DroplightRenderer.getSecondColor(red, green, blue, alpha, gradientModifiers));
        LootBeamRenderer.modifyGlowVertex(LootBeamRenderer.addGlowVertex(builder, matrixentry, -radius, 0.0f, -radius, red, green, blue, alpha, minX, minY), secondColor, centerU, centerV, uvWidth, uvHeight, gradientStart, gradientEnd, useGlowGradient).method_1344();
        LootBeamRenderer.modifyGlowVertex(LootBeamRenderer.addGlowVertex(builder, matrixentry, -radius, 0.0f, radius, red, green, blue, alpha, minX, maxY), secondColor, centerU, centerV, uvWidth, uvHeight, gradientStart, gradientEnd, useGlowGradient).method_1344();
        LootBeamRenderer.modifyGlowVertex(LootBeamRenderer.addGlowVertex(builder, matrixentry, radius, 0.0f, radius, red, green, blue, alpha, maxX, maxY), secondColor, centerU, centerV, uvWidth, uvHeight, gradientStart, gradientEnd, useGlowGradient).method_1344();
        LootBeamRenderer.modifyGlowVertex(LootBeamRenderer.addGlowVertex(builder, matrixentry, radius, 0.0f, -radius, red, green, blue, alpha, maxX, minY), secondColor, centerU, centerV, uvWidth, uvHeight, gradientStart, gradientEnd, useGlowGradient).method_1344();
    }

    private static void renderNameTag(class_4587 stack, class_4597 buffer, class_1542 item, class_5251 color) {
        Configuration itemConfig = CustomLootBeamsConfig.fromItemStack(item.method_6983());
        if (itemConfig.advancedTooltips) {
            return;
        }
        if (class_310.method_1551().field_1724.method_18276() || itemConfig.renderNametagsOnlook && TargetHelper.isLookingAt(class_310.method_1551().field_1724, (class_1297)item, itemConfig.nametagLookSensitivity)) {
            int count;
            float foregroundAlpha = itemConfig.nametagTextAlpha;
            float backgroundAlpha = itemConfig.nametagBackgroundAlpha;
            double yOffset = itemConfig.nametagYOffset;
            int foregroundColor = color.method_27716() & 0xFFFFFF | (int)(255.0f * foregroundAlpha) << 24;
            int backgroundColor = color.method_27716() & 0xFFFFFF | (int)(255.0f * backgroundAlpha) << 24;
            stack.method_22903();
            stack.method_22904(0.0, Math.min(1.0, class_310.method_1551().field_1724.method_5858((class_1297)item) * 0.025) + yOffset, 0.0);
            Quaternionf entityRotationQuaternion = class_310.method_1551().method_1561().method_24197();
            stack.method_22907(entityRotationQuaternion);
            float nametagScale = itemConfig.nametagScale;
            float nametagScaleCompensation = 0.5f;
            stack.method_22905(-0.02f * nametagScale * nametagScaleCompensation, -0.02f * nametagScale * nametagScaleCompensation, 0.02f * nametagScale * nametagScaleCompensation);
            class_327 fontrenderer = class_310.method_1551().field_1772;
            Object itemName = class_3544.method_15440((String)item.method_6983().method_7964().getString());
            if (itemConfig.renderStackcount && (count = item.method_6983().method_7947()) > 1) {
                itemName = (String)itemName + " x" + count;
            }
            stack.method_46416(0.0f, 0.0f, -10.0f);
            LootBeamRenderer.RenderText(item.method_6983(), fontrenderer, stack, buffer, (String)itemName, foregroundColor, backgroundColor, backgroundAlpha);
            boolean alwaysRenderRarityOnItem = RarityHelper.alwaysHasRarity(item.method_6983());
            if (itemConfig.renderItemRarity || alwaysRenderRarityOnItem) {
                LootBeamRenderer.DrawRarity(item.method_6983(), foregroundAlpha, backgroundAlpha, fontrenderer, stack, buffer, alwaysRenderRarityOnItem);
            }
            stack.method_22909();
        }
    }

    private static void DrawRarity(class_1799 itemStack, float foregroundAlpha, float backgroundAlpha, class_327 fontRenderer, class_4587 stack, class_4597 buffer, boolean alwaysRenderRarityOnItem) {
        class_2561 tooltipRarity;
        String rarityString;
        stack.method_22904(0.0, 10.0, 0.0);
        stack.method_22905(0.75f, 0.75f, 0.75f);
        List<class_2561> tooltip = TooltipManager.getTooltipFromCache(itemStack);
        if (tooltip.isEmpty()) {
            return;
        }
        if (tooltip.size() > 1 && (LootBeams.config.customRarities.contains(rarityString = (tooltipRarity = tooltip.get(1)).getString()) || alwaysRenderRarityOnItem)) {
            class_5251 rarityColor = LootBeams.config.whiteRarities ? class_5251.method_27718((class_124)class_124.field_1068) : TextColorHelper.getRawColor(tooltipRarity);
            int foregroundColor = rarityColor.method_27716() & 0xFFFFFF | (int)(255.0f * foregroundAlpha) << 24;
            int backgroundColor = rarityColor.method_27716() & 0xFFFFFF | (int)(255.0f * backgroundAlpha) << 24;
            LootBeamRenderer.RenderText(itemStack, fontRenderer, stack, buffer, rarityString, foregroundColor, backgroundColor, backgroundAlpha);
            return;
        }
        if (LootBeams.config.vanillaRarities || alwaysRenderRarityOnItem) {
            String rarity = RarityHelper.getRarity(itemStack);
            class_5251 rarityColor = LootBeams.config.whiteRarities ? class_5251.method_27718((class_124)class_124.field_1068) : TextColorHelper.getItemColor(itemStack);
            float R = (float)(rarityColor.method_27716() >> 16 & 0xFF) / 255.0f;
            float G = (float)(rarityColor.method_27716() >> 8 & 0xFF) / 255.0f;
            float B = (float)(rarityColor.method_27716() & 0xFF) / 255.0f;
            int foregroundColor = new Color(R, G, B, (float)((int)foregroundAlpha)).getRGB();
            int backgroundColor = new Color(R, G, B, (float)((int)backgroundAlpha)).getRGB();
            LootBeamRenderer.RenderText(itemStack, fontRenderer, stack, buffer, rarity, foregroundColor, backgroundColor, backgroundAlpha);
        }
    }

    private static void RenderText(class_1799 itemStack, class_327 fontRenderer, class_4587 stack, class_4597 buffer, String text, int foregroundColor, int backgroundColor, float backgroundAlpha) {
        Configuration itemConfig = CustomLootBeamsConfig.fromItemStack(itemStack);
        if (itemConfig.borders) {
            float w = (float)(-fontRenderer.method_1727(text)) / 2.0f;
            int bg = new Color(0, 0, 0, (int)(255.0f * backgroundAlpha)).getRGB();
            class_2561 orderedText = class_2561.method_30163((String)text);
            fontRenderer.method_37296(orderedText.method_30937(), w, 0.0f, foregroundColor, bg, stack.method_23760().method_23761(), buffer, 0xF000F0);
        } else {
            fontRenderer.method_27521(text, (float)((double)(-fontRenderer.method_1727(text)) / 2.0), 0.0f, foregroundColor, false, stack.method_23760().method_23761(), buffer, class_327.class_6415.field_33993, backgroundColor, 0xF000E0);
        }
    }

    private static void renderPart(class_4587 stack, class_4588 builder, float red, float green, float blue, float alpha, float y, float height, float radius_1, float radius_2, float radius_3, float radius_4, float radius_5, float radius_6, float radius_7, float radius_8, boolean gradient) {
        if (gradient) {
            LootBeamRenderer.renderGradientPart(stack, builder, red, green, blue, alpha, y, height, radius_1, radius_2, radius_3, radius_4, radius_5, radius_6, radius_7, radius_8);
        } else {
            LootBeamRenderer.renderPart(stack, builder, red, green, blue, alpha, y, height, radius_1, radius_2, radius_3, radius_4, radius_5, radius_6, radius_7, radius_8);
        }
    }

    private static void renderPart(class_4587 stack, class_4588 builder, float red, float green, float blue, float alpha, float y, float height, float radius_1, float radius_2, float radius_3, float radius_4, float radius_5, float radius_6, float radius_7, float radius_8) {
        class_4587.class_4665 matrixentry = stack.method_23760();
        Matrix3f matrixnormal = matrixentry.method_23762();
        LootBeamRenderer.renderQuad(matrixentry, matrixnormal, builder, red, green, blue, alpha, y, height, radius_1, radius_2, radius_3, radius_4);
        LootBeamRenderer.renderQuad(matrixentry, matrixnormal, builder, red, green, blue, alpha, y, height, radius_7, radius_8, radius_5, radius_6);
        LootBeamRenderer.renderQuad(matrixentry, matrixnormal, builder, red, green, blue, alpha, y, height, radius_3, radius_4, radius_7, radius_8);
        LootBeamRenderer.renderQuad(matrixentry, matrixnormal, builder, red, green, blue, alpha, y, height, radius_5, radius_6, radius_1, radius_2);
    }

    private static void renderGradientPart(class_4587 stack, class_4588 builder, float red, float green, float blue, float alpha, float y, float height, float radius_1, float radius_2, float radius_3, float radius_4, float radius_5, float radius_6, float radius_7, float radius_8) {
        class_4587.class_4665 matrixentry = stack.method_23760();
        Matrix3f matrixnormal = matrixentry.method_23762();
        LootBeamRenderer.renderUpwardsGradientQuad(matrixentry, matrixnormal, builder, red, green, blue, alpha, y, height, radius_1, radius_2, radius_3, radius_4);
        LootBeamRenderer.renderUpwardsGradientQuad(matrixentry, matrixnormal, builder, red, green, blue, alpha, y, height, radius_7, radius_8, radius_5, radius_6);
        LootBeamRenderer.renderUpwardsGradientQuad(matrixentry, matrixnormal, builder, red, green, blue, alpha, y, height, radius_3, radius_4, radius_7, radius_8);
        LootBeamRenderer.renderUpwardsGradientQuad(matrixentry, matrixnormal, builder, red, green, blue, alpha, y, height, radius_5, radius_6, radius_1, radius_2);
    }

    private static void renderQuad(class_4587.class_4665 stack, Matrix3f normal, class_4588 builder, float red, float green, float blue, float alpha, float y, float height, float x1, float z1, float x0, float z0) {
        LootBeamRenderer.addVertex(builder, stack, normal, red, green, blue, alpha, y + height / 2.0f, x1, z1, 1.0f, 0.0f);
        LootBeamRenderer.addVertex(builder, stack, normal, red, green, blue, alpha, y, x1, z1, 1.0f, 1.0f);
        LootBeamRenderer.addVertex(builder, stack, normal, red, green, blue, alpha, y, x0, z0, 0.0f, 1.0f);
        LootBeamRenderer.addVertex(builder, stack, normal, red, green, blue, alpha, y + height / 2.0f, x0, z0, 0.0f, 0.0f);
    }

    private static void renderUpwardsGradientQuad(class_4587.class_4665 stack, Matrix3f normal, class_4588 builder, float red, float green, float blue, float alpha, float y, float height, float z1, float texu1, float z, float texu) {
        LootBeamRenderer.addVertex(builder, stack, normal, red, green, blue, 0.0f, y + height, z1, texu1, 1.0f, 0.0f);
        LootBeamRenderer.addVertex(builder, stack, normal, red, green, blue, alpha, y + height / 2.0f, z1, texu1, 1.0f, 1.0f);
        LootBeamRenderer.addVertex(builder, stack, normal, red, green, blue, alpha, y + height / 2.0f, z, texu, 0.0f, 1.0f);
        LootBeamRenderer.addVertex(builder, stack, normal, red, green, blue, 0.0f, y + height, z, texu, 0.0f, 0.0f);
    }

    private static void addVertex(class_4588 builder, class_4587.class_4665 stack, Matrix3f normal, float red, float green, float blue, float alpha, float y, float x, float z, float texu, float texv) {
        builder.method_22918(stack.method_23761(), x, y, z).method_22915(red, green, blue, alpha).method_22913(texu, texv).method_22922(class_4608.field_21444).method_22916(0xF000F0).method_23763(normal, 0.0f, 1.0f, 0.0f).method_1344();
    }
}

