/*
 * Decompiled with CFR 0.152.
 */
package com.lootbeams.screens.widgets;

import com.lootbeams.LootBeams;
import com.lootbeams.helpers.RenderHelper;
import com.lootbeams.screens.widgets.PresetButtonWidget;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4265;
import net.minecraft.class_6379;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class PresetListWidget
extends class_4265<PresetEntry> {
    private PresetEntry selectedEntry;
    private boolean isScrolling = false;
    private double dragOffsetY;
    @Nullable
    private PresetEntry hoveredEntry;
    private static final class_2960 SCROLLER_TEXTURE = LootBeams.id("textures/gui/scroller/scroller.png");
    private static final class_2960 SCROLLER_BACKGROUND_TEXTURE = LootBeams.id("textures/gui/scroller/scroller_background.png");
    private int itemHeight;

    public PresetListWidget(class_310 client, int width, int height, int top, int bottom, int itemHeight) {
        super(client, width, height, top, bottom, itemHeight);
        this.itemHeight = itemHeight;
    }

    public void addEntries(Iterable<String> presetNames) {
        for (String presetName : presetNames) {
            PresetEntry entry = new PresetEntry(presetName, this.itemHeight, this, PresetButtonWidget.Type.Default);
            this.method_25321((class_350.class_351)entry);
            if (!presetName.equals(LootBeams.config.selectedPreset)) continue;
            this.selectedEntry = entry;
        }
    }

    public void method_25339() {
        super.method_25339();
    }

    public PresetEntry addEntry(String name, PresetButtonWidget.Type buttonType) {
        PresetEntry entry = new PresetEntry(name, this.itemHeight, this, buttonType);
        this.method_25321((class_350.class_351)entry);
        return entry;
    }

    private int getScrollbarWidth() {
        return 6;
    }

    protected int method_25329() {
        return this.field_19088 + this.field_22742 - this.getScrollbarWidth() + 4;
    }

    public int method_25322() {
        return this.field_22742 - this.getScrollbarWidth() - 3;
    }

    public int method_25342() {
        return this.field_19088 + 3;
    }

    protected int method_25337(int index) {
        return this.field_19085 + 2 - (int)this.method_25341() + index * this.itemHeight + this.field_22748;
    }

    public int method_25331() {
        return Math.max(0, this.method_25317() - this.field_22743 + 2);
    }

    protected void method_25311(class_332 context, int mouseX, int mouseY, float delta) {
        int i = this.method_25342();
        int j = this.method_25322();
        int k = this.itemHeight - 2;
        int l = this.method_25340();
        for (int m = 0; m < l; ++m) {
            int n = this.method_25337(m);
            int o = this.method_25319(m);
            if (o < this.field_19085 || n > this.field_19086) continue;
            this.method_44397(context, mouseX, mouseY, delta, m, i, n, j, k);
        }
    }

    protected void method_44397(class_332 context, int mouseX, int mouseY, float delta, int index, int x, int y, int entryWidth, int entryHeight) {
        PresetEntry entry = (PresetEntry)this.method_25326(index);
        entry.method_49568(context, index, y, x, entryWidth, entryHeight, mouseX, mouseY, Objects.equals((Object)this.hoveredEntry, (Object)entry), delta);
        if (this.method_25332(index)) {
            int i = this.method_25370() ? -1 : -8355712;
            this.method_44398(context, y, entryWidth, entryHeight, i, -16777216);
        }
        entry.method_25343(context, index, y, x, entryWidth, entryHeight, mouseX, mouseY, Objects.equals((Object)this.hoveredEntry, (Object)entry), delta);
    }

    private void renderScroller(class_332 context, int x, int y, int width, int height) {
        int topHeight = 6;
        int bottomHeight = 6;
        int middleHeight = 18;
        RenderHelper.blit(context, SCROLLER_TEXTURE, x, y, width, topHeight, 0, 0, width, topHeight);
        int remainingHeight = height - topHeight - bottomHeight;
        int middleRepeats = remainingHeight / middleHeight;
        int middleRemainder = remainingHeight % middleHeight;
        for (int i = 0; i < middleRepeats; ++i) {
            RenderHelper.blit(context, SCROLLER_TEXTURE, x, y + topHeight + i * middleHeight, width, middleHeight, 0, 7, width, middleHeight);
        }
        if (middleRemainder > 0) {
            RenderHelper.blit(context, SCROLLER_TEXTURE, x, y + topHeight + middleRepeats * middleHeight, width, middleRemainder, 0, 7, width, middleRemainder);
        }
        RenderHelper.blit(context, SCROLLER_TEXTURE, x, y + height - bottomHeight, width, bottomHeight, 0, 26, width, bottomHeight);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.hoveredEntry = this.method_25405(mouseX, mouseY) ? (PresetEntry)this.method_25308(mouseX, mouseY) : null;
        this.method_49603(context);
        this.method_25311(context, mouseX, mouseY, delta);
        context.method_44380();
        int m = this.method_25331();
        if (m > 0) {
            int i = this.method_25329();
            int j = (int)((float)(this.field_22743 * this.field_22743) / (float)this.method_25317());
            j = class_3532.method_15340((int)j, (int)32, (int)(this.field_22743 - 8));
            int k = (int)this.method_25341() * (this.field_22743 - j) / this.method_25331() + this.field_19085;
            if (k < this.field_19085) {
                k = this.field_19085;
            }
            RenderSystem.enableBlend();
            RenderHelper.blit(context, SCROLLER_BACKGROUND_TEXTURE, i, this.field_19085 - 1, 6, this.field_22743 + 2, 0, 0);
            this.renderScroller(context, i, k - 1, 6, j + 2);
            RenderSystem.disableBlend();
        }
        this.method_25320(context, mouseX, mouseY);
        RenderSystem.disableBlend();
    }

    public PresetEntry getSelectedEntry() {
        return this.selectedEntry;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (!this.isScrolling) {
            return false;
        }
        if (mouseY >= (double)this.field_19085 && mouseY <= (double)this.field_19086) {
            double scrollRange = this.method_25331();
            double scrollbarRange = this.field_22743;
            double scrollPercentage = (mouseY - (double)this.field_19085 - this.dragOffsetY) / (scrollbarRange - (double)this.getScrollbarHeight());
            this.method_25307(scrollRange * scrollPercentage);
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0) {
            int scrollbarY = this.getScrollbarY();
            int scrollbarHeight = this.getScrollbarHeight();
            if (mouseX >= (double)this.method_25329() && mouseX <= (double)(this.method_25329() + this.getScrollbarWidth()) && mouseY >= (double)scrollbarY && mouseY <= (double)(scrollbarY + scrollbarHeight)) {
                this.dragOffsetY = mouseY - (double)scrollbarY;
                this.isScrolling = true;
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.isScrolling = false;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    private int getScrollbarY() {
        int scrollbarHeight = this.getScrollbarHeight();
        int maxScroll = this.method_25331();
        if (maxScroll <= 0) {
            return this.field_19085;
        }
        int scrollbarPositionY = (int)this.method_25341() * (this.field_22743 - scrollbarHeight) / maxScroll + this.field_19085;
        if (scrollbarPositionY < this.field_19085) {
            scrollbarPositionY = this.field_19085;
        }
        return scrollbarPositionY;
    }

    private int getScrollbarHeight() {
        int j = (int)((float)(this.field_22743 * this.field_22743) / (float)this.method_25317());
        return class_3532.method_15340((int)j, (int)32, (int)(this.field_22743 - 8));
    }

    public static class PresetEntry
    extends class_4265.class_4266<PresetEntry> {
        private final String presetName;
        private final PresetButtonWidget button;
        private final PresetListWidget parentWidget;

        public PresetEntry(String presetName, int itemHeight, PresetListWidget parentWidget, PresetButtonWidget.Type buttonType) {
            this.presetName = presetName;
            this.parentWidget = parentWidget;
            this.button = PresetButtonWidget.customBuilder((class_2561)class_2561.method_43470((String)presetName), btn -> {}).type(buttonType).size(100, itemHeight).build();
        }

        public List<? extends class_6379> method_37025() {
            return Collections.emptyList();
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (button == 0) {
                this.parentWidget.selectedEntry = this.parentWidget.selectedEntry != this ? this : null;
                return true;
            }
            return false;
        }

        public String getPresetName() {
            return this.presetName;
        }

        public List<? extends class_364> method_25396() {
            return List.of();
        }

        public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            boolean currentEntrySelected = this.parentWidget.getSelectedEntry() == this;
            this.button.method_48229(x, y);
            this.button.method_25358(entryWidth);
            this.button.field_22763 = currentEntrySelected;
            this.button.method_25394(context, mouseX, mouseY, tickDelta);
        }
    }
}

