/*
 * Decompiled with CFR 0.152.
 */
package com.lootbeams.shaders;

import com.lootbeams.LootBeams;
import com.lootbeams.render.CustomVertexFormats;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.client.rendering.v1.CoreShaderRegistrationCallback;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_5944;

public class LootBeamShaders {
    private static final Map<Shader, class_5944> SHADERS_MAP = new HashMap<Shader, class_5944>();
    private static final Map<DroplightShader, class_5944> DROPLIGHT_SHADERS_MAP = new HashMap<DroplightShader, class_5944>();

    public static void registerShader(CoreShaderRegistrationCallback.RegistrationContext registry, Shader shader, String name, class_293 format) {
        try {
            registry.register(LootBeams.id(name), format, shaderProgram -> SHADERS_MAP.put(shader, (class_5944)shaderProgram));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void registerDroplightShader(CoreShaderRegistrationCallback.RegistrationContext registry, DroplightShader shader, String name, class_293 format) {
        try {
            registry.register(LootBeams.id(name), format, shaderProgram -> DROPLIGHT_SHADERS_MAP.put(shader, (class_5944)shaderProgram));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static class_5944 getShader(Shader shader) {
        return SHADERS_MAP.get((Object)shader);
    }

    public static class_5944 getShader(DroplightShader shader) {
        return DROPLIGHT_SHADERS_MAP.get((Object)shader);
    }

    public static float getAverageColor(Shader shader) {
        return switch (shader.ordinal()) {
            case 0 -> 1.0f;
            case 1 -> 0.5f;
            case 2 -> 0.5f;
            default -> 0.5f;
        };
    }

    public static void registerCoreShaders(CoreShaderRegistrationCallback.RegistrationContext shaderRegistry) {
        for (Shader shader : Shader.values()) {
            String registryShaderName = "lootbeams_" + shader.name().toLowerCase();
            LootBeamShaders.registerShader(shaderRegistry, shader, registryShaderName, class_290.field_1584);
        }
    }

    private static void registerDroplightCoreShader(CoreShaderRegistrationCallback.RegistrationContext shaderRegistry, DroplightShader shader, class_293 vertexFormat) {
        String registryShaderName = "lootbeams_" + shader.name().toLowerCase();
        LootBeamShaders.registerDroplightShader(shaderRegistry, shader, registryShaderName, vertexFormat);
    }

    public static void registerDroplightCoreShaders(CoreShaderRegistrationCallback.RegistrationContext shaderRegistry) {
        LootBeamShaders.registerDroplightCoreShader(shaderRegistry, DroplightShader.DROPLIGHT, CustomVertexFormats.POSITION_TEX_COLOR0_COLOR1);
        LootBeamShaders.registerDroplightCoreShader(shaderRegistry, DroplightShader.DROPLIGHT_GLOW, CustomVertexFormats.POSITION_TEX_COLOR0_COLOR1_CENTER);
    }

    public static enum Shader {
        ADD,
        GLOW_OVERLAY,
        PARTICLE_OVERLAY;

    }

    public static enum DroplightShader {
        DROPLIGHT,
        DROPLIGHT_GLOW;

    }
}

