/*
 * Decompiled with CFR 0.152.
 */
package com.metacontent.cobblenav.client.screen.pokenav;

import com.cobblemon.mod.common.CobblemonSounds;
import com.cobblemon.mod.common.api.gui.GuiUtilsKt;
import com.metacontent.cobblenav.client.CobblenavClient;
import com.metacontent.cobblenav.client.screen.AbstractPokenavItemScreen;
import com.metacontent.cobblenav.client.screen.pokenav.MainScreen;
import com.metacontent.cobblenav.client.widget.ContactInfoWidget;
import com.metacontent.cobblenav.client.widget.ContactListWidget;
import com.metacontent.cobblenav.client.widget.IconButton;
import com.metacontent.cobblenav.client.widget.ScrollableViewWidget;
import com.metacontent.cobblenav.networking.CobblenavPackets;
import com.metacontent.cobblenav.util.ContactSelector;
import com.metacontent.cobblenav.util.PokenavContact;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;

@Environment(value=EnvType.CLIENT)
public class ContactsScreen
extends AbstractPokenavItemScreen
implements ContactSelector {
    public static final class_2960 TEXTURE = new class_2960("cobblenav", "textures/gui/contact_screen_widgets.png");
    private int borderX;
    private int borderY;
    private List<PokenavContact> contacts;
    private int selectedContactIndex;
    private IconButton backButton;
    private IconButton deleteButton;
    private ScrollableViewWidget<ContactListWidget> scrollableView;
    private ContactListWidget contactListWidget;
    private ContactInfoWidget contactInfoWidget;

    protected ContactsScreen() {
        super((class_2561)class_2561.method_43470((String)"Contacts"));
    }

    private void requestContactData() {
        this.selectedContactIndex = -1;
        this.contacts = new ArrayList<PokenavContact>();
        ClientPlayNetworking.send((class_2960)CobblenavPackets.CONTACT_DATA_REQUEST_PACKET, (class_2540)PacketByteBufs.create());
    }

    public void createContactList(List<PokenavContact> contacts) {
        this.contacts = contacts;
        this.contactListWidget = new ContactListWidget(this.borderX - 15 + 240 - 124, this.borderY + 15 + 28, contacts, this);
        this.scrollableView = new ScrollableViewWidget<ContactListWidget>(this.contactListWidget, 118, 99, CobblenavClient.CONFIG.scrollSize);
        this.contactInfoWidget = new ContactInfoWidget(this.borderX + 15, this.borderY + 15 + 27);
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        this.requestContactData();
        this.borderX = (this.field_22789 - 240) / 2;
        this.borderY = (this.field_22790 - 180) / 2 - 10;
        this.backButton = new IconButton(this.borderX + 15 + 3, this.borderY + 180 - 15 - 12, 11, 11, 73, 0, (class_2561)class_2561.method_43471((String)"gui.cobblenav.pokenav_item.button_tooltip.back"), () -> {
            this.player.method_5783(CobblemonSounds.PC_CLICK, 0.1f, 1.25f);
            class_310.method_1551().method_1507((class_437)new MainScreen());
        });
        this.deleteButton = new IconButton(this.borderX + 240 - 15 - 14, this.borderY + 180 - 15 - 12, 11, 11, 109, 12, (class_2561)class_2561.method_43471((String)"gui.cobblenav.pokenav_item.button_tooltip.delete"), () -> {
            this.player.method_5783(CobblemonSounds.PC_RELEASE, 0.1f, 1.25f);
            this.selectedContactIndex = -1;
            this.contactListWidget.deleteContact(this.contactInfoWidget.getContact());
            this.contactInfoWidget.deleteContact();
            this.scrollableView.resetScrollY();
        });
    }

    @Override
    public void renderScreen(class_332 drawContext, int i, int j, float f) {
        class_4587 matrixStack = drawContext.method_51448();
        GuiUtilsKt.blitk((class_4587)matrixStack, (class_2960)BACKGROUND, (Number)(this.borderX + 15), (Number)(this.borderY + 15 + 20), (Number)118, (Number)210, (Number)0, (Number)131, (Number)256, (Number)256, (Number)0, (Number)1, (Number)1, (Number)1, (Number)1, (boolean)false, (float)1.0f);
        GuiUtilsKt.blitk((class_4587)drawContext.method_51448(), (class_2960)TEXTURE, (Number)(this.borderX - 15 + 240 - 128), (Number)(this.borderY + 15 + 24), (Number)108, (Number)128, (Number)0, (Number)0, (Number)256, (Number)256, (Number)0, (Number)1, (Number)1, (Number)1, (Number)1, (boolean)false, (float)1.0f);
        GuiUtilsKt.blitk((class_4587)matrixStack, (class_2960)BORDERS, (Number)this.borderX, (Number)(this.borderY + 180 - 15 - 14), (Number)14, (Number)240, (Number)0, (Number)181, (Number)256, (Number)256, (Number)0, (Number)1, (Number)1, (Number)1, (Number)1, (boolean)false, (float)1.0f);
        if (this.scrollableView != null) {
            this.scrollableView.method_25394(drawContext, i, j, f);
            if (this.selectedContactIndex != -1) {
                this.contactInfoWidget.method_25394(drawContext, i, j, f);
                this.deleteButton.method_25394(drawContext, i, j, f);
            }
        }
        this.backButton.method_25394(drawContext, i, j, f);
    }

    @Override
    public void onMouseClicked(double d, double e, int i) {
        this.backButton.method_25402(d, e, i);
        if (this.scrollableView != null) {
            boolean viewClicked = this.scrollableView.method_25402(d, e, i);
            if (this.selectedContactIndex != -1) {
                this.deleteButton.method_25402(d, e, i);
            }
            if (!viewClicked) {
                this.setContactIndex(-1);
            }
        }
    }

    @Override
    public void onMouseDragged(double d, double e, int i, double f, double g) {
        if (this.scrollableView != null) {
            this.scrollableView.method_25403(d, e, i, f, g);
        }
    }

    @Override
    public void onMouseScrolled(double d, double e, double f) {
        if (this.scrollableView != null) {
            this.scrollableView.method_25401(d, e, f);
        }
    }

    @Override
    public void setContactIndex(int index) {
        this.selectedContactIndex = index;
        if (index != -1) {
            this.contactInfoWidget.setContact(this.contacts.get(index));
        }
    }

    @Override
    public int getContactIndex() {
        return this.selectedContactIndex;
    }
}

