/*
 * Decompiled with CFR 0.152.
 */
package com.metacontent.cobblenav.client.screen.pokenav;

import com.cobblemon.mod.common.CobblemonSounds;
import com.cobblemon.mod.common.api.gui.GuiUtilsKt;
import com.cobblemon.mod.common.client.render.RenderHelperKt;
import com.cobblemon.mod.common.pokemon.RenderablePokemon;
import com.metacontent.cobblenav.Cobblenav;
import com.metacontent.cobblenav.client.CobblenavClient;
import com.metacontent.cobblenav.client.screen.AbstractPokenavItemScreen;
import com.metacontent.cobblenav.client.widget.IconButton;
import com.metacontent.cobblenav.client.widget.ModelWidget;
import com.metacontent.cobblenav.client.widget.TextButton;
import com.metacontent.cobblenav.config.CobblenavConfig;
import com.metacontent.cobblenav.networking.CobblenavPackets;
import com.metacontent.cobblenav.util.FoundPokemon;
import java.util.Set;
import kotlin.Pair;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class FinderScreen
extends AbstractPokenavItemScreen {
    private static final class_2960 FINDER_ASSETS = new class_2960("cobblenav", "textures/gui/pokenav_item_gui_finder_assets.png");
    private static final class_2960 COUNTER_INTEGRATION_ASSETS = new class_2960("cobblenav", "textures/gui/counter_integration_assets.png");
    private static final int HEIGHT = 80;
    private static final int WIDTH = 80;
    private static final int ANIM_DURATION = 40;
    private final AbstractPokenavItemScreen parent;
    private int borderX;
    private int borderY;
    private final RenderablePokemon pokemon;
    private int ticker = 0;
    private boolean isLoading = true;
    private FoundPokemon foundPokemon;
    private final CobblenavConfig.CounterIntegrationConfig config;
    private Pair<String, Integer> streak;
    private ModelWidget pokemonModel;
    private IconButton backButton;
    private TextButton trackButton;

    public FinderScreen(RenderablePokemon pokemon, AbstractPokenavItemScreen parent) {
        super((class_2561)class_2561.method_43470((String)"Finder"));
        this.config = Cobblenav.CONFIG.counterIntegrationConfig;
        this.pokemon = pokemon;
        this.parent = parent;
    }

    public void setFoundPokemon(@Nullable FoundPokemon foundPokemon) {
        if (foundPokemon != null && foundPokemon.isShiny()) {
            Set aspects = this.pokemon.getAspects();
            aspects.add("shiny");
            this.pokemon.setAspects(aspects);
            this.pokemonModel.setPokemon(this.pokemon);
        }
        this.foundPokemon = foundPokemon;
    }

    public void setLoading(boolean loading) {
        this.isLoading = loading;
    }

    public void setStreak(Pair<String, Integer> streak) {
        this.streak = streak;
    }

    private void requestPokemon() {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10817((Enum)CobblenavClient.CONFIG.pokenavFinderType);
        buf.method_10814(this.pokemon.getForm().showdownId());
        ClientPlayNetworking.send((class_2960)CobblenavPackets.FOUND_POKEMON_REQUEST_PACKET, (class_2540)buf);
    }

    private void saveLastFoundPokemon() {
        class_2540 buf = PacketByteBufs.create();
        this.pokemon.saveToBuffer(buf);
        ClientPlayNetworking.send((class_2960)CobblenavPackets.SAVE_FOUND_POKEMON_PACKET, (class_2540)buf);
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        this.requestPokemon();
        this.saveLastFoundPokemon();
        ClientPlayNetworking.send((class_2960)CobblenavPackets.STREAK_REQUEST_PACKET, (class_2540)PacketByteBufs.create());
        this.borderX = (this.field_22789 - 240) / 2;
        this.borderY = (this.field_22790 - 180) / 2 - 10;
        this.pokemonModel = new ModelWidget(this.borderX + 120 - 40, this.borderY + 90 + 20 - 40, 80, this.pokemon, 1.5f, 340.0f, 0);
        this.backButton = new IconButton(this.borderX + 15 + 3, this.borderY + 180 - 15 - 12, 11, 11, 73, 0, (class_2561)class_2561.method_43471((String)"gui.cobblenav.pokenav_item.button_tooltip.back"), () -> {
            this.player.method_5783(CobblemonSounds.PC_CLICK, 0.1f, 1.25f);
            class_310.method_1551().method_1507((class_437)this.parent);
        });
        this.trackButton = new TextButton(this.borderX + 120 - 34, this.borderY + 180 - 15 - 27, 70, 23, 0, 80, (class_2561)class_2561.method_43471((String)"gui.cobblenav.pokenav_item.track_button").method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true))), () -> {
            this.player.method_5783(CobblemonSounds.POKE_BALL_CAPTURE_SUCCEEDED, 0.5f, 0.75f);
            CobblenavClient.TRACK_ARROW_HUD_OVERLAY.setTrackedEntityId(this.foundPokemon.getEntityId());
            this.method_25419();
        });
    }

    @Override
    public void renderScreen(class_332 drawContext, int i, int j, float f) {
        class_4587 matrixStack = drawContext.method_51448();
        GuiUtilsKt.blitk((class_4587)matrixStack, (class_2960)BORDERS, (Number)this.borderX, (Number)(this.borderY + 180 - 15 - 14), (Number)14, (Number)240, (Number)0, (Number)181, (Number)256, (Number)256, (Number)0, (Number)1, (Number)1, (Number)1, (Number)1, (boolean)false, (float)1.0f);
        this.backButton.method_25394(drawContext, i, j, f);
        this.renderBackgroundImage(matrixStack);
        if (!this.isLoading) {
            if (this.foundPokemon != null) {
                this.trackButton.method_25394(drawContext, i, j, f);
                GuiUtilsKt.blitk((class_4587)matrixStack, (class_2960)FINDER_ASSETS, (Number)(this.borderX + 15), (Number)(this.borderY + 15 + 20), (Number)116, (Number)210, (Number)0, (Number)0, (Number)256, (Number)256, (Number)0, (Number)1, (Number)1, (Number)1, (Number)1, (boolean)false, (float)1.0f);
                this.renderCounter(drawContext, i, j);
                this.pokemonModel.method_25394(drawContext, i, j, f);
                int starsAmount = this.foundPokemon.getPotentialStarsAmount();
                for (int starIndex = 0; starIndex < starsAmount; ++starIndex) {
                    GuiUtilsKt.blitk((class_4587)matrixStack, (class_2960)FINDER_ASSETS, (Number)(this.borderX + 240 - 15 - 70 + 8 * starIndex), (Number)(this.borderY + 15 + 28), (Number)20, (Number)20, (Number)0, (Number)233, (Number)256, (Number)256, (Number)0, (Number)(0.5 + 0.25 * (double)starsAmount), (Number)(0.25 + 0.25 * (double)starsAmount), (Number)0.3, (Number)1, (boolean)false, (float)1.0f);
                }
                this.renderAbilityName(drawContext, i, j);
                this.renderLevel(drawContext, i, j);
                this.renderEggMoveName(drawContext, i, j);
                if (this.ticker < 40) {
                    ++this.ticker;
                }
            } else {
                RenderHelperKt.drawScaledText((class_332)drawContext, (class_2960)FONT, (class_5250)class_2561.method_43471((String)"gui.cobblenav.pokenav_item.not_found_message"), (Number)(this.borderX + 120 + 2), (Number)(this.borderY + 90), (float)1.0f, (Number)1, (int)100, (int)0xFFFFFF, (boolean)true, (boolean)true, (Integer)i, (Integer)j);
            }
        }
    }

    private void renderBackgroundImage(class_4587 matrixStack) {
        if (this.streak != null) {
            class_2960 texture = COUNTER_INTEGRATION_ASSETS;
            int offsetY = 0;
            int textureHeight = 512;
            int value = (Integer)this.streak.component2();
            if (((String)this.streak.component1()).equals(this.pokemon.getSpecies().getName().toLowerCase()) && value >= this.config.levelOneStreak) {
                if (value < this.config.levelTwoStreak) {
                    offsetY = 116;
                } else if (value < this.config.levelThreeStreak) {
                    offsetY = 232;
                } else if (value < this.config.levelFourStreak) {
                    offsetY = 348;
                } else {
                    texture = FINDER_ASSETS;
                    offsetY = 116;
                    textureHeight = 256;
                }
            }
            GuiUtilsKt.blitk((class_4587)matrixStack, (class_2960)texture, (Number)(this.borderX + 15), (Number)(this.borderY + 15 + 20), (Number)116, (Number)210, (Number)0, (Number)offsetY, (Number)256, (Number)textureHeight, (Number)0, (Number)1, (Number)1, (Number)1, (Number)1, (boolean)false, (float)1.0f);
        } else {
            GuiUtilsKt.blitk((class_4587)matrixStack, (class_2960)FINDER_ASSETS, (Number)(this.borderX + 15), (Number)(this.borderY + 15 + 20), (Number)116, (Number)210, (Number)0, (Number)116, (Number)256, (Number)256, (Number)0, (Number)1, (Number)1, (Number)1, (Number)1, (boolean)false, (float)1.0f);
        }
    }

    private void renderCounter(class_332 drawContext, int i, int j) {
        if (this.streak != null) {
            int value = (Integer)this.streak.component2();
            if (((String)this.streak.component1()).equals(this.pokemon.getSpecies().getName().toLowerCase())) {
                GuiUtilsKt.blitk((class_4587)drawContext.method_51448(), (class_2960)COUNTER_INTEGRATION_ASSETS, (Number)(this.borderX + 15), (Number)(this.borderY + 90), (Number)14, (Number)41, (Number)0, (Number)465, (Number)256, (Number)512, (Number)0, (Number)1, (Number)1, (Number)1, (Number)1, (boolean)false, (float)1.0f);
                RenderHelperKt.drawScaledText((class_332)drawContext, (class_2960)AbstractPokenavItemScreen.FONT, (class_5250)class_2561.method_43470((String)("CS: " + value)), (Number)(this.borderX + 15 + 8), (Number)(this.borderY + 90 + 2), (float)1.0f, (Number)1, (int)30, (int)0xFFFFFF, (boolean)false, (boolean)true, (Integer)i, (Integer)j);
            }
        }
    }

    private void renderAbilityName(class_332 drawContext, int i, int j) {
        RenderHelperKt.drawScaledText((class_332)drawContext, (class_2960)FONT, (class_5250)class_2561.method_43471((String)"cobblemon.ui.info.ability").method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true))), (Number)(this.borderX + 240 - 15 - 53), (Number)(this.borderY + 180 - 15 - 38), (float)1.0f, (Number)1, (int)40, (int)0xFFFFFF, (boolean)false, (boolean)true, (Integer)i, (Integer)j);
        if (this.foundPokemon.isAbilityHidden()) {
            GuiUtilsKt.blitk((class_4587)drawContext.method_51448(), (class_2960)FINDER_ASSETS, (Number)(this.borderX + 240 - 15 - 14), (Number)(this.borderY + 180 - 15 - 39), (Number)9, (Number)9, (Number)21, (Number)233, (Number)256, (Number)256, (Number)0, (Number)1, (Number)1, (Number)1, (Number)1, (boolean)false, (float)1.0f);
        }
        RenderHelperKt.drawScaledText((class_332)drawContext, (class_2960)FONT, (class_5250)class_2561.method_43471((String)("cobblemon.ability." + this.foundPokemon.getAbilityName())), (Number)(this.borderX + 240 - 15 - 53), (Number)(this.borderY + 180 - 15 - 29), (float)1.0f, (Number)1, (int)47, (int)0xFFFFFF, (boolean)false, (boolean)true, (Integer)i, (Integer)j);
    }

    private void renderLevel(class_332 drawContext, int i, int j) {
        RenderHelperKt.drawScaledText((class_332)drawContext, (class_2960)FONT, (class_5250)class_2561.method_43470((String)(this.pokemon.getSpecies().getTranslatedName().getString() + " " + class_2561.method_43469((String)"gui.cobblenav.pokenav_item.level_value", (Object[])new Object[]{this.foundPokemon.getLevel()}).getString())), (Number)(this.borderX + 15 + 38), (Number)(this.borderY + 15 + 27), (float)1.0f, (Number)1, (int)55, (int)0xFFFFFF, (boolean)true, (boolean)true, (Integer)i, (Integer)j);
    }

    private void renderEggMoveName(class_332 drawContext, int i, int j) {
        boolean hasEggMove = !this.foundPokemon.getEggMoveName().isEmpty();
        RenderHelperKt.drawScaledText((class_332)drawContext, (class_2960)FONT, (class_5250)class_2561.method_43471((String)"gui.cobblenav.pokenav_item.egg_move").method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true))), (Number)(this.borderX + 15 + 8), (Number)(this.borderY + 180 - 15 - 38), (float)1.0f, (Number)1, (int)40, (int)0xFFFFFF, (boolean)false, (boolean)true, (Integer)i, (Integer)j);
        if (hasEggMove) {
            GuiUtilsKt.blitk((class_4587)drawContext.method_51448(), (class_2960)FINDER_ASSETS, (Number)(this.borderX + 15 + 50), (Number)(this.borderY + 180 - 15 - 39), (Number)9, (Number)9, (Number)21, (Number)233, (Number)256, (Number)256, (Number)0, (Number)1, (Number)1, (Number)1, (Number)1, (boolean)false, (float)1.0f);
        }
        RenderHelperKt.drawScaledText((class_332)drawContext, (class_2960)FONT, (class_5250)class_2561.method_43471((String)(hasEggMove ? "cobblemon.move." + this.foundPokemon.getEggMoveName() : "gui.cobblenav.pokenav_item.egg_move_none")), (Number)(this.borderX + 15 + 8), (Number)(this.borderY + 180 - 15 - 29), (float)1.0f, (Number)1, (int)47, (int)0xFFFFFF, (boolean)false, (boolean)true, (Integer)i, (Integer)j);
    }

    @Override
    public void onMouseClicked(double d, double e, int i) {
        this.backButton.method_25402(d, e, i);
        if (!this.isLoading) {
            this.trackButton.method_25402(d, e, i);
        }
    }

    @Override
    public void onMouseDragged(double d, double e, int i, double f, double g) {
    }

    @Override
    public void onMouseScrolled(double d, double e, double f) {
    }
}

