/*
 * Decompiled with CFR 0.152.
 */
package com.metacontent.cobblenav.client.screen.pokenav;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.CobblemonSounds;
import com.cobblemon.mod.common.api.gui.GuiUtilsKt;
import com.cobblemon.mod.common.api.spawning.SpawnBucket;
import com.cobblemon.mod.common.client.render.RenderHelperKt;
import com.cobblemon.mod.common.pokemon.RenderablePokemon;
import com.metacontent.cobblenav.client.CobblenavClient;
import com.metacontent.cobblenav.client.screen.AbstractPokenavItemScreen;
import com.metacontent.cobblenav.client.screen.pokenav.MainScreen;
import com.metacontent.cobblenav.client.widget.IconButton;
import com.metacontent.cobblenav.client.widget.PokemonSpawnInfoWidget;
import com.metacontent.cobblenav.client.widget.ScrollableViewWidget;
import com.metacontent.cobblenav.client.widget.TableWidget;
import com.metacontent.cobblenav.networking.CobblenavPackets;
import com.metacontent.cobblenav.util.BorderBox;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;

@Environment(value=EnvType.CLIENT)
public class LocationScreen
extends AbstractPokenavItemScreen {
    public final List<SpawnBucket> buckets;
    private static final class_2960 LOADING_ANIMATION = new class_2960("cobblenav", "textures/gui/loading_animation.png");
    private final class_1657 player;
    private Map<RenderablePokemon, Float> spawnMap = new HashMap<RenderablePokemon, Float>();
    private List<PokemonSpawnInfoWidget> spawnInfoWidgets = new ArrayList<PokemonSpawnInfoWidget>();
    private TableWidget<PokemonSpawnInfoWidget> spawnTable;
    private ScrollableViewWidget<TableWidget<PokemonSpawnInfoWidget>> scrollableSpawnTable;
    private int bucketIndex = -1;
    private boolean isLoading = false;
    private int ticker = 0;
    private int animProgress = 0;
    private int sortingMark = 0;
    private int borderX;
    private int borderY;
    private IconButton backButton;
    private IconButton refreshButton;
    private IconButton decreaseBucketIndexButton;
    private IconButton increaseBucketIndexButton;
    private IconButton reverseSortingButton;

    public LocationScreen() {
        super((class_2561)class_2561.method_43470((String)"Location"));
        this.player = class_310.method_1551().field_1724;
        this.buckets = Cobblemon.INSTANCE.getBestSpawner().getConfig().getBuckets();
    }

    private void requestSavedPreferences() {
        this.spawnMap.clear();
        this.isLoading = true;
        ClientPlayNetworking.send((class_2960)CobblenavPackets.SAVED_PREFERENCES_REQUEST_PACKET, (class_2540)PacketByteBufs.create());
    }

    public void setPreferences(int bucketIndex, int sortingMark) {
        this.bucketIndex = Math.max(bucketIndex, 0);
        this.sortingMark = sortingMark == 0 ? 1 : sortingMark;
    }

    public void checkSpawns() {
        this.spawnMap.clear();
        this.isLoading = true;
        class_2540 buf = PacketByteBufs.create();
        buf.method_10814(this.buckets.get(this.bucketIndex).getName());
        ClientPlayNetworking.send((class_2960)CobblenavPackets.SPAWN_MAP_REQUEST_PACKET, (class_2540)buf);
    }

    public void setLoading(boolean loading) {
        this.isLoading = loading;
    }

    public void resetAnimationProgress() {
        this.ticker = 0;
        this.animProgress = 0;
    }

    public void createSpawnInfoWidgets() {
        int y = this.borderY + 15 + 30;
        this.spawnTable = new TableWidget(this.borderX + 15 + 3, y, 7, 3, new BorderBox(4, 2));
        this.scrollableSpawnTable = new ScrollableViewWidget<TableWidget<PokemonSpawnInfoWidget>>(this.spawnTable, 200, 106, CobblenavClient.CONFIG.scrollSize);
        this.spawnInfoWidgets = new ArrayList<PokemonSpawnInfoWidget>();
        RenderablePokemon[] renderablePokemonArray = this.spawnMap.keySet().toArray(new RenderablePokemon[0]);
        Float[] probabilityArray = this.spawnMap.values().toArray(new Float[0]);
        for (int i = 0; i < this.spawnMap.size(); ++i) {
            PokemonSpawnInfoWidget widget = new PokemonSpawnInfoWidget(0, 0, renderablePokemonArray[i], probabilityArray[i].floatValue(), this, y - 30, y + 106);
            this.spawnInfoWidgets.add(widget);
        }
        this.spawnTable.calcRows(this.spawnInfoWidgets.size());
        this.spawnTable.setWidgets(this.spawnInfoWidgets);
    }

    public void setSpawnMap(Map<RenderablePokemon, Float> spawnMap) {
        this.spawnMap = spawnMap;
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        this.borderX = (this.field_22789 - 240) / 2;
        this.borderY = (this.field_22790 - 180) / 2 - 10;
        if (this.sortingMark == 0 || this.bucketIndex == -1) {
            this.requestSavedPreferences();
        } else {
            this.checkSpawns();
        }
        this.backButton = new IconButton(this.borderX + 15 + 3, this.borderY + 180 - 15 - 12, 11, 11, 73, 0, (class_2561)class_2561.method_43471((String)"gui.cobblenav.pokenav_item.button_tooltip.back"), () -> {
            this.player.method_5783(CobblemonSounds.PC_CLICK, 0.1f, 1.25f);
            this.savePreferences();
            class_310.method_1551().method_1507((class_437)new MainScreen());
        });
        this.refreshButton = new IconButton(this.borderX + 15 + 18, this.borderY + 180 - 15 - 12, 11, 11, 85, 0, 400, (class_2561)class_2561.method_43471((String)"gui.cobblenav.pokenav_item.button_tooltip.refresh"), () -> {
            this.player.method_5783(CobblemonSounds.PC_CLICK, 0.1f, 1.25f);
            this.checkSpawns();
        });
        this.decreaseBucketIndexButton = new IconButton(this.field_22789 / 2 - 25, this.borderY + 15 + 22, 5, 7, 97, 0, null, this::decreaseBucket);
        this.increaseBucketIndexButton = new IconButton(this.field_22789 / 2 + 25, this.borderY + 15 + 22, 5, 7, 102, 0, null, this::increaseBucket);
        this.reverseSortingButton = new IconButton(this.borderX + 240 - 15 - 14, this.borderY + 180 - 15 - 12, 11, 11, 97, 12, CobblenavClient.CONFIG.reverseSortingButtonCooldown, (class_2561)class_2561.method_43471((String)"gui.cobblenav.pokenav_item.button_tooltip.reverse"), () -> {
            this.player.method_5783(CobblemonSounds.PC_CLICK, 0.05f, 1.25f);
            if (!this.spawnMap.isEmpty()) {
                this.sortingMark = -this.sortingMark;
                ArrayList<Map.Entry<RenderablePokemon, Float>> sortingList = new ArrayList<Map.Entry<RenderablePokemon, Float>>(this.spawnMap.entrySet());
                Comparator comparator = Map.Entry.comparingByValue((c1, c2) -> this.sortingMark * Float.compare(c1.floatValue(), c2.floatValue()));
                sortingList.sort(comparator);
                this.spawnMap.clear();
                sortingList.forEach(entry -> this.spawnMap.put((RenderablePokemon)entry.getKey(), (Float)entry.getValue()));
                this.createSpawnInfoWidgets();
            }
        });
    }

    @Override
    public void renderScreen(class_332 drawContext, int i, int j, float f) {
        class_4587 matrixStack = drawContext.method_51448();
        GuiUtilsKt.blitk((class_4587)matrixStack, (class_2960)BACKGROUND, (Number)(this.borderX + 15), (Number)(this.borderY + 15 + 20), (Number)118, (Number)210, (Number)0, (Number)131, (Number)256, (Number)256, (Number)0, (Number)1, (Number)1, (Number)1, (Number)1, (boolean)false, (float)1.0f);
        GuiUtilsKt.blitk((class_4587)matrixStack, (class_2960)BORDERS, (Number)this.borderX, (Number)(this.borderY + 180 - 15 - 14), (Number)14, (Number)240, (Number)0, (Number)181, (Number)256, (Number)256, (Number)0, (Number)1, (Number)1, (Number)1, (Number)1, (boolean)false, (float)1.0f);
        this.backButton.method_25394(drawContext, i, j, f);
        this.refreshButton.method_25394(drawContext, i, j, f);
        this.reverseSortingButton.method_25394(drawContext, i, j, f);
        if (this.isLoading) {
            this.renderLoadingAnimation(drawContext, i, j, f);
        } else {
            this.renderBucketSelector(drawContext, i, j, f);
            if (!this.spawnInfoWidgets.isEmpty()) {
                this.scrollableSpawnTable.method_25394(drawContext, i, j, f);
                for (PokemonSpawnInfoWidget widget : this.spawnInfoWidgets) {
                    if (!widget.isVisible() || !widget.method_49606() || !this.scrollableSpawnTable.method_49606()) continue;
                    drawContext.method_51434(this.field_22793, List.of(widget.getPokemonModel().getPokemon().getSpecies().getTranslatedName(), class_2561.method_43470((String)widget.getProbabilityString()).method_10862(class_2583.field_24360.method_36139(0x4D4D4D))), i, j);
                }
            } else {
                RenderHelperKt.drawScaledText((class_332)drawContext, (class_2960)FONT, (class_5250)class_2561.method_43471((String)"gui.cobblenav.pokenav_item.empty_spawns_message.part_1"), (Number)(this.borderX + 120), (Number)(this.borderY + 90), (float)1.0f, (Number)1, (int)240, (int)0xFFFFFF, (boolean)true, (boolean)false, (Integer)i, (Integer)j);
                RenderHelperKt.drawScaledText((class_332)drawContext, (class_2960)FONT, (class_5250)class_2561.method_43471((String)"gui.cobblenav.pokenav_item.empty_spawns_message.part_2"), (Number)(this.borderX + 120), (Number)(this.borderY + 90 + 8), (float)1.0f, (Number)1, (int)120, (int)0xFFFFFF, (boolean)true, (boolean)false, (Integer)i, (Integer)j);
            }
        }
    }

    @Override
    public void onMouseClicked(double d, double e, int i) {
        this.backButton.method_25402(d, e, i);
        if (!this.isLoading) {
            this.refreshButton.method_25402(d, e, i);
            this.decreaseBucketIndexButton.method_25402(d, e, i);
            this.increaseBucketIndexButton.method_25402(d, e, i);
            this.scrollableSpawnTable.method_25402(d, e, i);
            this.reverseSortingButton.method_25402(d, e, i);
        }
    }

    @Override
    public void onMouseDragged(double d, double e, int i, double f, double g) {
        if (!this.isLoading) {
            this.scrollableSpawnTable.method_25403(d, e, i, f, g);
        }
    }

    @Override
    public void onMouseScrolled(double d, double e, double f) {
        if (!this.isLoading) {
            this.scrollableSpawnTable.method_25401(d, e, f);
        }
    }

    private void renderBucketSelector(class_332 drawContext, int i, int j, float f) {
        this.decreaseBucketIndexButton.method_25394(drawContext, i, j, f);
        RenderHelperKt.drawScaledText((class_332)drawContext, (class_2960)FONT, (class_5250)class_2561.method_43471((String)("gui.cobblenav.pokenav_item.bucket." + this.buckets.get(this.bucketIndex).getName())).method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true))), (Number)(this.field_22789 / 2 + 3), (Number)(this.borderY + 15 + 20), (float)1.0f, (Number)1, (int)40, (int)0xFFFFFF, (boolean)true, (boolean)false, (Integer)i, (Integer)j);
        this.increaseBucketIndexButton.method_25394(drawContext, i, j, f);
    }

    private void renderLoadingAnimation(class_332 drawContext, int i, int j, float f) {
        class_4587 matrixStack = drawContext.method_51448();
        if (this.ticker % 10 == 0) {
            ++this.animProgress;
        }
        GuiUtilsKt.blitk((class_4587)matrixStack, (class_2960)LOADING_ANIMATION, (Number)(this.borderX + 120 - 9), (Number)(this.borderY + 90), (Number)22, (Number)18, (Number)(18 * this.animProgress), (Number)0, (Number)256, (Number)256, (Number)0, (Number)1, (Number)1, (Number)1, (Number)1, (boolean)false, (float)1.0f);
        if (this.animProgress == 8) {
            this.resetAnimationProgress();
        }
        ++this.ticker;
    }

    public SpawnBucket getCurrentBucket() {
        return this.buckets.get(this.bucketIndex);
    }

    public int getSortingMark() {
        return this.sortingMark;
    }

    @Override
    public void method_25419() {
        this.savePreferences();
        super.method_25419();
    }

    public void savePreferences() {
        class_2540 buf = PacketByteBufs.create();
        buf.writeInt(this.bucketIndex);
        buf.writeInt(this.sortingMark);
        ClientPlayNetworking.send((class_2960)CobblenavPackets.SAVE_PREFERENCES_PACKET, (class_2540)buf);
    }

    public void decreaseBucket() {
        if (this.bucketIndex - 1 >= 0) {
            this.player.method_5783(CobblemonSounds.PC_CLICK, 0.05f, 1.25f);
            --this.bucketIndex;
            this.checkSpawns();
        }
    }

    public void increaseBucket() {
        if (this.bucketIndex + 1 < this.buckets.size()) {
            this.player.method_5783(CobblemonSounds.PC_CLICK, 0.05f, 1.25f);
            ++this.bucketIndex;
            this.checkSpawns();
        }
    }

    public boolean method_25404(int i, int j, int k) {
        if (CobblenavClient.increaseBucketKey.method_1417(i, j)) {
            this.increaseBucket();
        } else if (CobblenavClient.decreaseBucketKey.method_1417(i, j)) {
            this.decreaseBucket();
        }
        return super.method_25404(i, j, k);
    }
}

