/*
 * Decompiled with CFR 0.152.
 */
package com.metacontent.cobblenav.client.widget;

import com.cobblemon.mod.common.api.gui.GuiUtilsKt;
import com.cobblemon.mod.common.api.types.ElementalType;
import com.cobblemon.mod.common.api.types.ElementalTypes;
import com.cobblemon.mod.common.client.gui.summary.widgets.type.TypeWidget;
import com.metacontent.cobblenav.client.widget.TableWidget;
import com.metacontent.cobblenav.util.BorderBox;
import com.metacontent.cobblenav.util.GrantedBadge;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4068;
import net.minecraft.class_4587;

public class BadgeDisplayWidget
implements class_4068 {
    private final TableWidget<TypeWidget> badgeTable;

    public BadgeDisplayWidget(int x, int y) {
        this.badgeTable = new TableWidget(x, y, 9, 0, new BorderBox(1));
    }

    public void method_25394(class_332 drawContext, int i, int j, float f) {
        this.badgeTable.method_25394(drawContext, i, j, f);
    }

    public void setBadges(Set<String> allBadges, Set<GrantedBadge> playerBadges) {
        ArrayList<BadgeWidget> typeWidgets = new ArrayList<BadgeWidget>();
        for (String badge : allBadges) {
            ElementalType type = ElementalTypes.INSTANCE.get(badge.toLowerCase());
            if (type == null) continue;
            GrantedBadge grantedBadge = playerBadges.stream().filter(b -> b.type().equals(badge)).findFirst().orElse(null);
            BadgeWidget typeWidget = new BadgeWidget(0, 0, 9, 9, type, grantedBadge);
            typeWidgets.add(typeWidget);
        }
        this.badgeTable.calcRows(typeWidgets.size());
        this.badgeTable.setWidgets(typeWidgets);
    }

    private static class BadgeWidget
    extends TypeWidget {
        private static final class_2960 COVERAGE = new class_2960("cobblenav", "textures/gui/type_widget_coverage.png");
        private final ElementalType type;
        private final GrantedBadge grantedBadge;
        private final class_327 textRenderer;
        private final List<class_2561> tooltip;

        public BadgeWidget(int pX, int pY, int pWidth, int pHeight, ElementalType type, GrantedBadge grantedBadge) {
            super(pX, pY, pWidth, pHeight, (class_2561)class_2561.method_43470((String)"BadgeWidget"));
            this.type = type;
            this.grantedBadge = grantedBadge;
            this.textRenderer = class_310.method_1551().field_1772;
            class_2583 typeStyle = class_2583.field_24360.method_36139(type.getHue());
            this.tooltip = this.granted() ? List.of(type.getDisplayName().method_10862(typeStyle), class_2561.method_43470((String)grantedBadge.grantedBy()), class_2561.method_43470((String)grantedBadge.grantDate().toInstant().atZone(ZoneId.systemDefault()).format(DateTimeFormatter.ISO_LOCAL_DATE))) : List.of(type.getDisplayName().method_10862(typeStyle));
        }

        protected void method_48579(class_332 drawContext, int i, int j, float f) {
            class_4587 matrixStack = drawContext.method_51448();
            matrixStack.method_22903();
            this.renderType(this.type, matrixStack, this.method_46426(), this.method_46427());
            if (!this.granted()) {
                float scale = 0.25f;
                GuiUtilsKt.blitk((class_4587)matrixStack, (class_2960)COVERAGE, (Number)(((double)this.method_46426() + 0.5) / (double)scale), (Number)Float.valueOf((float)this.method_46427() / scale), (Number)36, (Number)36, (Number)0, (Number)0, (Number)36, (Number)36, (Number)0, (Number)1, (Number)1, (Number)1, (Number)0.7, (boolean)true, (float)scale);
            }
            if (this.field_22762) {
                matrixStack.method_22903();
                matrixStack.method_46416(0.0f, 0.0f, 1.0f);
                drawContext.method_51434(this.textRenderer, this.tooltip, i, j);
                matrixStack.method_22909();
            }
            matrixStack.method_22909();
        }

        private boolean granted() {
            return this.grantedBadge != null;
        }
    }
}

