/*
 * Decompiled with CFR 0.152.
 */
package com.metacontent.cobblenav.client.widget;

import com.cobblemon.mod.common.CobblemonSounds;
import com.cobblemon.mod.common.client.render.RenderHelperKt;
import com.cobblemon.mod.common.pokemon.RenderablePokemon;
import com.metacontent.cobblenav.client.CobblenavClient;
import com.metacontent.cobblenav.client.screen.pokenav.FinderScreen;
import com.metacontent.cobblenav.client.screen.pokenav.LocationScreen;
import com.metacontent.cobblenav.client.widget.Clickable;
import com.metacontent.cobblenav.client.widget.IconButton;
import com.metacontent.cobblenav.client.widget.ModelWidget;
import com.metacontent.cobblenav.config.util.PercentageDisplayType;
import java.text.DecimalFormat;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_6382;

public class PokemonSpawnInfoWidget
extends class_339
implements Clickable {
    private static final class_2960 FONT = new class_2960("uniform");
    private final ModelWidget pokemonModel;
    private final class_1657 player;
    private final int areaExpansion;
    private float probability;
    private static final DecimalFormat df = new DecimalFormat("#.##");
    private String sign = "%";
    private int color = 0xFFFFFF;
    private boolean showActionButtons = false;
    private final int minRenderY;
    private final int maxRenderY;
    private final IconButton shareButton;
    private final IconButton findButton;

    public PokemonSpawnInfoWidget(int i, int j, RenderablePokemon pokemon, float probability, LocationScreen parent, int minRenderY, int maxRenderY) {
        super(i, j, 20, 30, (class_2561)pokemon.getSpecies().getTranslatedName());
        this.pokemonModel = new ModelWidget(this.method_46426(), this.method_46427(), this.method_25368(), pokemon, 0.5f, 340.0f, 0);
        this.probability = probability;
        boolean bucketWise = CobblenavClient.CONFIG.bucketWisePercentageCalculation;
        PercentageDisplayType percentageDisplayType = CobblenavClient.CONFIG.percentageDisplayType;
        if (bucketWise) {
            this.probability *= parent.getCurrentBucket().getWeight() / 100.0f;
        }
        if (percentageDisplayType == PercentageDisplayType.PERMILLE_ALLOWED && this.probability < 0.01f) {
            this.color = 0xD3D3D3;
            this.sign = "\u2030";
            this.probability *= 10.0f;
        } else if (percentageDisplayType == PercentageDisplayType.PERMILLE_ONLY) {
            this.sign = "\u2030";
            this.probability *= 10.0f;
        }
        this.player = class_310.method_1551().field_1724;
        this.minRenderY = minRenderY;
        this.maxRenderY = maxRenderY;
        this.areaExpansion = CobblenavClient.CONFIG.actionButtonAreaExpansion;
        this.shareButton = new IconButton(this.method_46426() + this.method_25368() / 2 + 1, this.method_46427() + this.method_25364() - 12, 11, 11, 73, 12, null, () -> {
            this.player.method_5783(CobblemonSounds.PC_CLICK, 0.1f, 1.25f);
            String form = this.pokemonModel.getPokemon().getForm().getName();
            String name = this.pokemonModel.getPokemon().getSpecies().getTranslatedName().getString() + (String)(form.equals("Normal") ? "" : " (" + form + ")");
            class_243 vec3d = this.player.method_19538();
            String coordinates = "x: " + (int)vec3d.field_1352 + " y: " + (int)vec3d.field_1351 + " z: " + (int)vec3d.field_1350 + " (" + this.player.method_37908().method_44013().method_29177() + ")";
            String chance = parent.getCurrentBucket().getName() + " - " + df.format(probability) + this.sign;
            class_5250 text = class_2561.method_43469((String)"gui.cobblenav.pokenav_item.spawn_info_message", (Object[])new Object[]{name, coordinates, chance});
            this.player.method_43496((class_2561)text);
            this.player.method_43496((class_2561)class_2561.method_43471((String)"gui.cobblenav.pokenav_item.share_spawn_info_message").method_10862(class_2583.field_24360.method_36139(16751160).method_10982(Boolean.valueOf(true)).method_10958(new class_2558(class_2558.class_2559.field_11745, text.getString()))));
        });
        this.findButton = new IconButton(this.method_46426() + this.method_25368() / 2 - 12, this.method_46427() + this.method_25364() - 12, 11, 11, 85, 12, null, () -> {
            parent.savePreferences();
            this.player.method_5783(CobblemonSounds.PC_CLICK, 0.1f, 1.25f);
            class_310.method_1551().method_1507((class_437)new FinderScreen(this.pokemonModel.getPokemon(), parent));
        });
    }

    public boolean isVisible() {
        return this.method_46427() >= this.minRenderY && this.method_46427() <= this.maxRenderY;
    }

    protected void method_48579(class_332 drawContext, int i, int j, float f) {
        if (this.isVisible()) {
            this.pokemonModel.method_25394(drawContext, i, j, f);
            RenderHelperKt.drawScaledText((class_332)drawContext, (class_2960)FONT, (class_5250)class_2561.method_43470((String)(df.format(this.probability) + this.sign)).method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true))), (Number)(this.method_46426() + this.method_25368() / 2), (Number)(this.method_46427() + this.method_25364() - 10), (float)1.0f, (Number)1, (int)(2 * this.method_25368()), (int)this.color, (boolean)true, (boolean)false, (Integer)i, (Integer)j);
            if (this.showActionButtons) {
                this.showActionButtons = this.isHovered(i, j);
                this.shareButton.method_25394(drawContext, i, j, f);
                this.findButton.method_25394(drawContext, i, j, f);
            }
        }
    }

    public boolean isHovered(int i, int j) {
        return i >= this.method_46426() - this.areaExpansion && j >= this.method_46427() - this.areaExpansion && i < this.method_46426() + this.field_22758 + this.areaExpansion && j < this.method_46427() + this.field_22759 + this.areaExpansion;
    }

    public boolean method_25402(double d, double e, int i) {
        boolean bl;
        if (this.field_22763 && this.field_22764 && this.isMainClickButton(i) && (bl = this.method_25361(d, e))) {
            if (this.showActionButtons) {
                this.shareButton.method_25402(d, e, i);
                this.findButton.method_25402(d, e, i);
            }
            this.method_25348(d, e);
            return true;
        }
        return false;
    }

    public void method_25348(double d, double e) {
        this.showActionButtons = !this.showActionButtons;
    }

    protected void method_47399(class_6382 narrationMessageBuilder) {
    }

    public void method_46421(int i) {
        super.method_46421(i);
        this.pokemonModel.setX(i);
        this.shareButton.method_46421(this.method_46426() + this.method_25368() / 2 + 1);
        this.findButton.method_46421(this.method_46426() + this.method_25368() / 2 - 12);
    }

    public void method_46419(int i) {
        super.method_46419(i);
        this.pokemonModel.setY(i);
        this.shareButton.method_46419(this.method_46427() + this.method_25364() - 12);
        this.findButton.method_46419(this.method_46427() + this.method_25364() - 12);
    }

    public ModelWidget getPokemonModel() {
        return this.pokemonModel;
    }

    public String getProbabilityString() {
        return this.probability + this.sign;
    }
}

