/*
 * Decompiled with CFR 0.152.
 */
package com.metacontent.cobblenav.client.widget.main_screen;

import com.cobblemon.mod.common.client.CobblemonClient;
import com.cobblemon.mod.common.client.render.models.blockbench.pokemon.PokemonPoseableModel;
import com.cobblemon.mod.common.client.render.models.blockbench.repository.PokemonModelRepository;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.activestate.ShoulderedState;
import com.metacontent.cobblenav.client.CobblenavClient;
import com.metacontent.cobblenav.client.RenderUtility;
import com.metacontent.cobblenav.client.widget.ModelWidget;
import com.metacontent.cobblenav.client.widget.main_screen.MainScreenWidget;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;

public class PartyWidget
extends MainScreenWidget {
    private final class_1657 player;
    private final List<ModelWidget> partyModels = new ArrayList<ModelWidget>();
    private final int playerX;
    private final int playerY;
    private final int borderX;
    private final int borderY;
    private final float scale;
    private final float baseScale;

    public PartyWidget(int playerX, int playerY, int borderX, int borderY, float scale) {
        this.player = class_310.method_1551().field_1724;
        this.playerX = playerX;
        this.playerY = playerY;
        this.borderX = borderX;
        this.borderY = borderY;
        this.scale = scale;
        this.baseScale = CobblenavClient.CONFIG.screenScale;
        List party = CobblemonClient.INSTANCE.getStorage().getMyParty().getSlots();
        this.createPartyModels(party);
    }

    public PartyWidget(int playerX, int playerY, int borderX, int borderY, float scale, List<Pokemon> party) {
        this.player = class_310.method_1551().field_1724;
        this.playerX = playerX;
        this.playerY = playerY;
        this.borderX = borderX;
        this.borderY = borderY;
        this.scale = scale;
        this.baseScale = CobblenavClient.CONFIG.screenScale;
        this.createPartyModels(party);
    }

    public void createPartyModels(List<Pokemon> party) {
        this.partyModels.clear();
        int index = 0;
        int pX = this.playerX;
        for (Pokemon pokemon : party) {
            if (pokemon == null || pokemon.getState() instanceof ShoulderedState) continue;
            PokemonPoseableModel model = (PokemonPoseableModel)PokemonModelRepository.INSTANCE.getPoser(pokemon.getSpecies().getResourceIdentifier(), pokemon.getAspects());
            double adjustment = CobblenavClient.CONFIG.partyWidgetAdjustments.getOrDefault(pokemon.showdownId(), 0.0);
            float pokemonScale = pokemon.getForm().getBaseScale() / model.getProfileScale() * this.scale;
            double scaledOffsetY = -34.0f * pokemonScale;
            ModelWidget modelWidget = new ModelWidget((pX += (int)((float)(index * 20 * (index % 2 == 1 ? -1 : 1)) + (float)((index % 2 == 1 ? -1 : 1) * 20) * this.scale)) - 101, this.playerY + 88, 200, pokemon.asRenderablePokemon(), pokemonScale, 350.0f + (float)(20 * (index % 2 == 1 ? 1 : 0)), (int)(scaledOffsetY - model.getProfileTranslation().field_1351 - adjustment));
            this.partyModels.add(modelWidget);
            ++index;
        }
    }

    @Override
    protected void renderWidget(class_332 drawContext, int i, int j, float f) {
        class_4587 matrixStack = drawContext.method_51448();
        drawContext.method_44379((int)((float)(this.borderX + 15) * this.baseScale), (int)((float)(this.borderY + 15 + 20) * this.baseScale), (int)((float)(this.borderX + 240 - 15) * this.baseScale), (int)((float)(this.borderY + 180 - 15) * this.baseScale));
        matrixStack.method_22903();
        matrixStack.method_46416(0.0f, 0.0f, 2000.0f);
        RenderUtility.renderPlayer(drawContext, this.playerX, this.playerY, this.player, (int)(20.0f * this.scale));
        for (int index = 0; index < this.partyModels.size(); ++index) {
            this.partyModels.get(index).method_25394(drawContext, i, j, f);
            if (index % 2 == 0) continue;
            matrixStack.method_46416(0.0f, 0.0f, -500.0f);
        }
        matrixStack.method_22909();
        drawContext.method_44380();
    }
}

