/*
 * Decompiled with CFR 0.152.
 */
package com.metacontent.cobblenav.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.metacontent.cobblenav.Cobblenav;
import com.metacontent.cobblenav.config.util.Badges;
import com.metacontent.cobblenav.config.util.TrainerContactInfo;
import com.metacontent.cobblenav.util.PokemonFeatureWeights;
import java.io.File;
import java.io.FileReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;

public class CobblenavConfig {
    public final boolean useCobbledexIntegration;
    public final boolean useCounterIntegration;
    public final boolean onlySeenPokemonMode;
    public final boolean useCobblemonTrainersIntegration;
    public final Badges badges;
    public final int checkSpawnWidth;
    public final int checkSpawnHeight;
    public final int findingAreaWidth;
    public final int findingAreaHeight;
    public final PokemonFeatureWeights pokemonFeatureWeights;
    public final List<String> ignoredLabels;
    public final List<String> hiddenPokemon;
    public final int titleCommandsPermissionLevel;
    public final Map<String, TrainerContactInfo> trainerContactInfo;
    public final List<Integer> customPokenavPredicates;
    public final CounterIntegrationConfig counterIntegrationConfig;
    public final boolean enableDebugMode;

    private CobblenavConfig(boolean useCobbledexIntegration, boolean useCounterIntegration, boolean onlySeenPokemonMode, boolean useCobblemonTrainersIntegration, Badges badges, int checkSpawnWidth, int checkSpawnHeight, int findingAreaWidth, int findingAreaHeight, PokemonFeatureWeights pokemonFeatureWeights, List<String> ignoredLabels, List<String> hiddenPokemon, int titleCommandsPermissionLevel, Map<String, TrainerContactInfo> trainerContactInfo, List<Integer> customPokenavPredicates, CounterIntegrationConfig counterIntegrationConfig, boolean enableDebugMode) {
        this.useCobbledexIntegration = useCobbledexIntegration;
        this.useCounterIntegration = useCounterIntegration;
        this.onlySeenPokemonMode = onlySeenPokemonMode;
        this.useCobblemonTrainersIntegration = useCobblemonTrainersIntegration;
        this.badges = badges;
        this.checkSpawnWidth = checkSpawnWidth;
        this.checkSpawnHeight = checkSpawnHeight;
        this.findingAreaWidth = findingAreaWidth;
        this.findingAreaHeight = findingAreaHeight;
        this.pokemonFeatureWeights = pokemonFeatureWeights;
        this.ignoredLabels = ignoredLabels;
        this.hiddenPokemon = hiddenPokemon;
        this.titleCommandsPermissionLevel = titleCommandsPermissionLevel;
        this.trainerContactInfo = trainerContactInfo;
        this.customPokenavPredicates = customPokenavPredicates;
        this.counterIntegrationConfig = counterIntegrationConfig;
        this.enableDebugMode = enableDebugMode;
    }

    private CobblenavConfig() {
        this(false, false, false, false, new Badges(), -1, -1, 100, 100, PokemonFeatureWeights.BASE_WEIGHTS, List.of("not_modeled"), List.of(), 2, Map.of(), List.of(Integer.valueOf(0)), new CounterIntegrationConfig(), false);
    }

    public static CobblenavConfig init() {
        CobblenavConfig config;
        Cobblenav.LOGGER.info("Initializing cobblenav config");
        Gson gson = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();
        File file = new File(FabricLoader.getInstance().getConfigDir() + "/cobblenav/cobblenav-config.json");
        file.getParentFile().mkdirs();
        if (file.exists()) {
            try (FileReader fileReader = new FileReader(file);){
                config = (CobblenavConfig)gson.fromJson((Reader)fileReader, CobblenavConfig.class);
            }
            catch (Throwable throwable) {
                Cobblenav.LOGGER.error(throwable.getMessage(), throwable);
                config = new CobblenavConfig();
            }
        } else {
            config = new CobblenavConfig();
        }
        try (PrintWriter printWriter = new PrintWriter(file);){
            gson.toJson((Object)config, (Appendable)printWriter);
        }
        catch (Throwable throwable) {
            Cobblenav.LOGGER.error(throwable.getMessage(), throwable);
        }
        return config;
    }

    public String toString() {
        return "CobblenavConfig{useCounterIntegration=" + this.useCounterIntegration + ", useCobblemonTrainersIntegration=" + this.useCobblemonTrainersIntegration + ", badges=" + this.badges + ", checkSpawnWidth=" + this.checkSpawnWidth + ", checkSpawnHeight=" + this.checkSpawnHeight + ", findingAreaWidth=" + this.findingAreaWidth + ", findingAreaHeight=" + this.findingAreaHeight + ", pokemonFeatureWeights=" + this.pokemonFeatureWeights + ", ignoredLabels=" + this.ignoredLabels + ", hiddenPokemon=" + this.hiddenPokemon + ", titleCommandsPermissionLevel=" + this.titleCommandsPermissionLevel + ", customPokenavPredicates=" + this.customPokenavPredicates + ", counterIntegrationConfig=" + this.counterIntegrationConfig + ", enableDebugMode=" + this.enableDebugMode + "}";
    }

    public static class CounterIntegrationConfig {
        public final int levelOneStreak;
        public final int levelTwoStreak;
        public final int levelThreeStreak;
        public final int levelFourStreak;
        public final int levelZeroEggMoveChance;
        public final int levelOneEggMoveChance;
        public final int levelTwoEggMoveChance;
        public final int levelThreeEggMoveChance;
        public final int levelFourEggMoveChance;

        private CounterIntegrationConfig(int levelOneStreak, int levelTwoStreak, int levelThreeStreak, int levelFourStreak, int levelZeroEggMoveChance, int levelOneEggMoveChance, int levelTwoEggMoveChance, int levelThreeEggMoveChance, int levelFourEggMoveChance) {
            this.levelOneStreak = levelOneStreak;
            this.levelTwoStreak = levelTwoStreak;
            this.levelThreeStreak = levelThreeStreak;
            this.levelFourStreak = levelFourStreak;
            this.levelZeroEggMoveChance = levelZeroEggMoveChance;
            this.levelOneEggMoveChance = levelOneEggMoveChance;
            this.levelTwoEggMoveChance = levelTwoEggMoveChance;
            this.levelThreeEggMoveChance = levelThreeEggMoveChance;
            this.levelFourEggMoveChance = levelFourEggMoveChance;
        }

        private CounterIntegrationConfig() {
            this(5, 10, 20, 30, 0, 21, 46, 58, 65);
        }
    }
}

