/*
 * Decompiled with CFR 0.152.
 */
package com.metacontent.cobblenav.config.util;

import com.metacontent.cobblenav.config.util.Badge;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class Badges {
    private final Set<Badge> badges;

    public Badges(Set<Badge> badges) {
        this.badges = badges;
    }

    public Badges() {
        this.badges = new HashSet<Badge>();
    }

    @Nullable
    public Badge getByType(String type) {
        return this.badges.stream().filter(badge -> badge.type().equals(type)).findFirst().orElse(null);
    }

    public List<Badge> getByPermission(String permission) {
        return this.badges.stream().filter(badge -> badge.permissionToGrant().equals(permission)).toList();
    }

    public List<Badge> getByTrainer(String trainer) {
        return this.badges.stream().filter(badge -> badge.trainer().equalsIgnoreCase(trainer)).toList();
    }

    public List<Badge> getPermitted(class_3222 player) {
        return this.badges.stream().filter(badge -> badge.hasPermissionToGrant(player)).toList();
    }

    public Set<String> getTypes() {
        return this.badges.stream().map(Badge::type).collect(Collectors.toSet());
    }

    public Set<String> getPermissions() {
        return this.badges.stream().map(Badge::permissionToGrant).collect(Collectors.toSet());
    }
}

