/*
 * Decompiled with CFR 0.152.
 */
package com.metacontent.cobblenav.integration;

import com.metacontent.cobblenav.Cobblenav;
import com.metacontent.cobblenav.integration.CobbledexChecker;
import com.metacontent.cobblenav.integration.CounterChecker;
import com.metacontent.cobblenav.integration.SeenPokemonChecker;
import net.fabricmc.loader.api.FabricLoader;
import org.jetbrains.annotations.Nullable;

public class IntegrationManager {
    private final boolean trainers;
    private final boolean counter;
    private final boolean cobbledex;
    @Nullable
    private final SeenPokemonChecker checker;

    public IntegrationManager() {
        this.trainers = FabricLoader.getInstance().isModLoaded("cobblemontrainers") && Cobblenav.CONFIG.useCobblemonTrainersIntegration;
        this.log(this.trainers, Cobblenav.CONFIG.useCobblemonTrainersIntegration, "CobblemonTrainers");
        this.counter = FabricLoader.getInstance().isModLoaded("cobblemon_counter") && Cobblenav.CONFIG.useCounterIntegration;
        this.log(this.counter, Cobblenav.CONFIG.useCounterIntegration, "Cobblemon Counter");
        this.cobbledex = FabricLoader.getInstance().isModLoaded("cobbledex") && Cobblenav.CONFIG.useCobbledexIntegration;
        this.log(this.cobbledex, Cobblenav.CONFIG.useCobbledexIntegration, "Cobbledex");
        this.checker = this.chooseChecker();
    }

    private void log(boolean integration, boolean configSetting, String modName) {
        if (integration) {
            Cobblenav.LOGGER.info(modName + " Integration is enabled");
        } else if (configSetting) {
            Cobblenav.LOGGER.warn(modName + " is not installed, integration will not be used");
        }
    }

    @Nullable
    private SeenPokemonChecker chooseChecker() {
        if (!Cobblenav.CONFIG.onlySeenPokemonMode) {
            return null;
        }
        if (FabricLoader.getInstance().isModLoaded("cobblemon_counter")) {
            Cobblenav.LOGGER.info("Cobblemon Counter is installed, it will be used to implement the only seen pokemon mode");
            return new CounterChecker();
        }
        if (FabricLoader.getInstance().isModLoaded("cobbledex")) {
            Cobblenav.LOGGER.info("Cobbledex is installed, it will be used to implement the only seen pokemon mode");
            return new CobbledexChecker();
        }
        Cobblenav.LOGGER.warn("Neither Cobblemon Counter nor Cobbledex are installed, only seen pokemon mode is disabled");
        return null;
    }

    public boolean trainers() {
        return this.trainers;
    }

    public boolean counter() {
        return this.counter;
    }

    public boolean cobbledex() {
        return this.cobbledex;
    }

    @Nullable
    public SeenPokemonChecker getChecker() {
        return this.checker;
    }
}

