/*
 * Decompiled with CFR 0.152.
 */
package com.metacontent.cobblenav.networking.server;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.spawning.CobblemonWorldSpawnerManager;
import com.cobblemon.mod.common.api.spawning.SpawnBucket;
import com.cobblemon.mod.common.api.spawning.SpawnCause;
import com.cobblemon.mod.common.api.spawning.WorldSlice;
import com.cobblemon.mod.common.api.spawning.context.AreaSpawningContext;
import com.cobblemon.mod.common.api.spawning.detail.PokemonSpawnDetail;
import com.cobblemon.mod.common.api.spawning.spawner.PlayerSpawner;
import com.cobblemon.mod.common.api.spawning.spawner.Spawner;
import com.cobblemon.mod.common.api.spawning.spawner.SpawningArea;
import com.cobblemon.mod.common.config.CobblemonConfig;
import com.cobblemon.mod.common.pokemon.RenderablePokemon;
import com.metacontent.cobblenav.Cobblenav;
import com.metacontent.cobblenav.integration.SeenPokemonChecker;
import com.metacontent.cobblenav.networking.CobblenavPackets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;

public class SpawnMapRequestReceiver {
    public static void receive(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
        CobblemonConfig config = Cobblemon.config;
        String bucketName = buf.method_19772();
        HashMap spawnMap = new HashMap();
        server.method_40000(() -> {
            try {
                if (config.getEnableSpawning()) {
                    PlayerSpawner spawner = (PlayerSpawner)CobblemonWorldSpawnerManager.INSTANCE.getSpawnersForPlayers().get(player.method_5667());
                    SpawnBucket bucket = Cobblemon.INSTANCE.getBestSpawner().getConfig().getBuckets().stream().filter(b -> bucketName.equalsIgnoreCase(b.name)).findFirst().orElse(null);
                    if (spawner == null || bucket == null) {
                        throw new NullPointerException("For some reason player spawner and/or bucket are null");
                    }
                    SpawnCause cause = new SpawnCause((Spawner)spawner, bucket, (class_1297)spawner.getCauseEntity());
                    WorldSlice slice = spawner.getProspector().prospect((Spawner)spawner, new SpawningArea(cause, (class_3218)player.method_37908(), (int)Math.ceil(player.method_23317() - (double)((float)config.getWorldSliceDiameter() / 2.0f)), (int)Math.ceil(player.method_23318() - (double)((float)config.getWorldSliceHeight() / 2.0f)), (int)Math.ceil(player.method_23321() - (double)((float)config.getWorldSliceDiameter() / 2.0f)), Cobblenav.CONFIG.checkSpawnWidth == -1 ? config.getWorldSliceDiameter() : Cobblenav.CONFIG.checkSpawnWidth, Cobblenav.CONFIG.checkSpawnHeight == -1 ? config.getWorldSliceHeight() : Cobblenav.CONFIG.checkSpawnHeight, Cobblenav.CONFIG.checkSpawnWidth == -1 ? config.getWorldSliceDiameter() : Cobblenav.CONFIG.checkSpawnWidth));
                    List<AreaSpawningContext> contexts = Cobblenav.RESOLVER.resolve((Spawner)spawner, spawner.getContextCalculators(), slice);
                    Map spawnProbabilities = spawner.getSpawningSelector().getProbabilities((Spawner)spawner, contexts);
                    spawnProbabilities.forEach((key, value) -> {
                        try {
                            PokemonSpawnDetail pokemonSpawnDetail;
                            if (key instanceof PokemonSpawnDetail && (pokemonSpawnDetail = (PokemonSpawnDetail)key).isValid()) {
                                RenderablePokemon renderablePokemon = pokemonSpawnDetail.getPokemon().asRenderablePokemon();
                                boolean isIgnored = Cobblenav.CONFIG.ignoredLabels.stream().anyMatch(string -> renderablePokemon.getSpecies().getLabels().contains(string));
                                boolean isHidden = Cobblenav.CONFIG.hiddenPokemon.stream().anyMatch(string -> renderablePokemon.getForm().showdownId().equals(string));
                                boolean isSeen = true;
                                SeenPokemonChecker checker = Cobblenav.INTEGRATIONS.getChecker();
                                if (checker != null) {
                                    isSeen = checker.check(renderablePokemon.getSpecies(), (class_1657)player);
                                }
                                if (isIgnored || isHidden) {
                                    return;
                                }
                                if (isSeen) {
                                    spawnMap.put(renderablePokemon, value);
                                }
                            }
                        }
                        catch (Throwable e) {
                            Cobblenav.LOGGER.error(e.getMessage(), e);
                        }
                    });
                }
            }
            catch (Throwable e) {
                Cobblenav.LOGGER.error(e.getMessage(), e);
            }
            finally {
                class_2540 responseBuf = PacketByteBufs.create();
                responseBuf.method_10814(bucketName);
                class_2540.class_7462 renderablePokemonPacketWriter = (packetByteBuf, pokemon) -> pokemon.saveToBuffer(packetByteBuf);
                class_2540.class_7462 floatPacketWriter = class_2540::writeFloat;
                responseBuf.method_34063(spawnMap, renderablePokemonPacketWriter, floatPacketWriter);
                responseSender.sendPacket(CobblenavPackets.SPAWN_MAP_PACKET, responseBuf);
            }
        });
    }
}

