/*
 * Decompiled with CFR 0.152.
 */
package com.metacontent.cobblenav.store;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.storage.player.PlayerData;
import com.cobblemon.mod.common.api.storage.player.PlayerDataExtension;
import com.cobblemon.mod.common.api.storage.player.PlayerDataExtensionRegistry;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.metacontent.cobblenav.util.GrantedBadge;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_1657;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public class AdditionalStatsData
implements PlayerDataExtension {
    public static final String NAME = "cobblenavPlayerStatsData";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private int totalPvpCount = 0;
    private Date startDate = new Date();
    private final Set<GrantedBadge> grantedBadges = new HashSet<GrantedBadge>();
    private final Map<UUID, Integer> pokemonUsage = new HashMap<UUID, Integer>();

    public int getTotalPvpCount() {
        return this.totalPvpCount;
    }

    public void updateTotalPvpCount() {
        ++this.totalPvpCount;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Set<GrantedBadge> getGrantedBadges() {
        return this.grantedBadges;
    }

    public void addBadge(GrantedBadge badge) {
        this.grantedBadges.add(badge);
    }

    public Map<UUID, Integer> getPokemonUsage() {
        return this.pokemonUsage;
    }

    public void updatePokemonUsage(UUID pokemonUuid) {
        Integer usage = this.pokemonUsage.get(pokemonUuid);
        if (usage == null) {
            usage = 0;
        }
        Integer n = usage;
        usage = usage + 1;
        this.pokemonUsage.put(pokemonUuid, usage);
    }

    public void removePokemonUsage(UUID pokemonUuid) {
        this.pokemonUsage.remove(pokemonUuid);
    }

    public static AdditionalStatsData getFromData(PlayerData data) {
        AdditionalStatsData statsData = (AdditionalStatsData)data.getExtraData().get(NAME);
        if (statsData == null) {
            statsData = new AdditionalStatsData();
            data.getExtraData().put(NAME, statsData);
            Cobblemon.playerData.saveSingle(data);
        }
        return statsData;
    }

    public static void executeForDataOf(class_3222 player, Consumer<AdditionalStatsData> action) {
        PlayerData data = Cobblemon.playerData.get((class_1657)player);
        AdditionalStatsData statsData = AdditionalStatsData.getFromData(data);
        action.accept(statsData);
        Cobblemon.playerData.saveSingle(data);
    }

    public static void executeForDataOf(UUID playerUuid, Consumer<AdditionalStatsData> action) {
        class_3222 player;
        MinecraftServer server = Cobblemon.implementation.server();
        if (server != null && (player = server.method_3760().method_14602(playerUuid)) != null) {
            AdditionalStatsData.executeForDataOf(player, action);
        }
    }

    @NotNull
    public AdditionalStatsData deserialize(@NotNull JsonObject jsonObject) {
        JsonObject pokemonUsageObject;
        JsonArray grantedBadgesArray;
        JsonPrimitive startDatePrimitive;
        JsonPrimitive totalPvpPrimitive = jsonObject.getAsJsonPrimitive("totalPvpCount");
        if (totalPvpPrimitive != null) {
            this.totalPvpCount = totalPvpPrimitive.getAsInt();
        }
        if ((startDatePrimitive = jsonObject.getAsJsonPrimitive("startDate")) != null) {
            this.startDate = new Date(startDatePrimitive.getAsLong());
        }
        if ((grantedBadgesArray = jsonObject.getAsJsonArray("grantedBadges")) != null) {
            this.grantedBadges.clear();
            grantedBadgesArray.forEach(jsonElement -> this.grantedBadges.add((GrantedBadge)GSON.fromJson(jsonElement, GrantedBadge.class)));
        }
        if ((pokemonUsageObject = jsonObject.getAsJsonObject("pokemonUsage")) != null) {
            this.pokemonUsage.clear();
            pokemonUsageObject.entrySet().forEach(entry -> this.pokemonUsage.put(UUID.fromString((String)entry.getKey()), ((JsonElement)entry.getValue()).getAsInt()));
        }
        return this;
    }

    @NotNull
    public String name() {
        return NAME;
    }

    @NotNull
    public JsonObject serialize() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty(PlayerDataExtension.Companion.getNAME_KEY(), NAME);
        jsonObject.addProperty("totalPvpCount", (Number)this.totalPvpCount);
        jsonObject.addProperty("startDate", (Number)this.startDate.getTime());
        JsonArray grantedBadgesArray = new JsonArray();
        this.grantedBadges.forEach(badge -> grantedBadgesArray.add(GSON.toJsonTree(badge)));
        jsonObject.add("grantedBadges", (JsonElement)grantedBadgesArray);
        JsonObject pokemonUsageObject = new JsonObject();
        this.pokemonUsage.forEach((uuid, integer) -> pokemonUsageObject.addProperty(uuid.toString(), (Number)integer));
        jsonObject.add("pokemonUsage", (JsonElement)pokemonUsageObject);
        return jsonObject;
    }

    public static void register() {
        PlayerDataExtensionRegistry.INSTANCE.register(NAME, AdditionalStatsData.class, false);
    }
}

