/*
 * Decompiled with CFR 0.152.
 */
package com.metacontent.cobblenav.store;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.storage.player.PlayerData;
import com.cobblemon.mod.common.api.storage.player.PlayerDataExtension;
import com.cobblemon.mod.common.api.storage.player.PlayerDataExtensionRegistry;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.metacontent.cobblenav.Cobblenav;
import com.metacontent.cobblenav.config.util.TrainerContactInfo;
import com.metacontent.cobblenav.util.ContactTeamMember;
import com.metacontent.cobblenav.util.PokenavContact;
import com.mojang.authlib.GameProfile;
import com.selfdot.cobblemontrainers.trainer.Trainer;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_1657;
import net.minecraft.class_2631;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContactData
implements PlayerDataExtension {
    public static final String NAME = "cobblenavContactData";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private String title = "";
    private final Map<String, PokenavContact> contacts = new HashMap<String, PokenavContact>();

    public static ContactData getFromData(PlayerData data) {
        ContactData contactData = (ContactData)data.getExtraData().get(NAME);
        if (contactData == null) {
            contactData = new ContactData();
            data.getExtraData().put(NAME, contactData);
            Cobblemon.playerData.saveSingle(data);
        }
        return contactData;
    }

    public static void executeForDataOf(class_3222 player, Consumer<ContactData> action) {
        PlayerData data = Cobblemon.playerData.get((class_1657)player);
        ContactData contactData = ContactData.getFromData(data);
        action.accept(contactData);
        Cobblemon.playerData.saveSingle(data);
    }

    public void updateContact(GameProfile gameProfile, PlayerData data) {
        if (gameProfile.getId() == null) {
            class_2631.method_11335((GameProfile)gameProfile, gameProfilex -> {
                String id = gameProfilex.getId().toString();
                PokenavContact pokenavContact = this.contacts.getOrDefault(id, new PokenavContact(id, (GameProfile)gameProfilex, false));
                pokenavContact.setProfile((GameProfile)gameProfilex);
                this.contacts.put(id, pokenavContact);
                Cobblemon.playerData.saveSingle(data);
            });
        }
    }

    public void updateContact(class_3222 contact, @Nullable PokemonBattle battle, boolean isWinner, boolean isAlly) {
        BattleActor actor;
        PokenavContact pokenavContact = this.contacts.getOrDefault(contact.method_5845(), new PokenavContact(contact.method_5845(), contact.method_7334(), false));
        pokenavContact.setProfile(contact.method_7334());
        ContactData contactData = Cobblemon.playerData.get((class_1657)contact).getExtraData().getOrDefault(NAME, null);
        if (contactData != null) {
            pokenavContact.setTitle(contactData.getTitle());
        }
        if (battle != null && (actor = battle.getActor(contact)) != null) {
            pokenavContact.getTeam().clear();
            for (BattlePokemon pokemon : actor.getPokemonList()) {
                ContactTeamMember teamMember = new ContactTeamMember(pokemon.getOriginalPokemon().getSpecies().showdownId(), pokemon.getOriginalPokemon().getLevel());
                pokenavContact.getTeam().add(teamMember);
            }
        }
        if (!isAlly) {
            if (isWinner) {
                pokenavContact.updateWinnings();
            } else {
                pokenavContact.updateLosses();
            }
        }
        this.contacts.put(contact.method_5845(), pokenavContact);
    }

    public void updateContact(Trainer contact, boolean isWinner) {
        String title;
        String name;
        String contactKey = contact.getGroup().toLowerCase() + "-" + contact.getName().toLowerCase();
        PokenavContact pokenavContact = this.contacts.getOrDefault(contactKey, new PokenavContact(contactKey, contact.getName(), true));
        TrainerContactInfo contactInfo = Cobblenav.CONFIG.trainerContactInfo.get(contactKey);
        if (contactInfo != null) {
            name = contactInfo.name() != null ? contactInfo.name() : contact.getName();
            title = contactInfo.title() != null ? contactInfo.title() : "Trainer";
        } else {
            name = contact.getName();
            title = "Trainer";
        }
        pokenavContact.setName(name);
        pokenavContact.setTitle(title);
        pokenavContact.getTeam().clear();
        for (BattlePokemon pokemon : contact.getBattleTeam()) {
            ContactTeamMember teamMember = new ContactTeamMember(pokemon.getOriginalPokemon().getSpecies().showdownId(), pokemon.getOriginalPokemon().getLevel());
            pokenavContact.getTeam().add(teamMember);
        }
        if (isWinner) {
            pokenavContact.updateWinnings();
        } else {
            pokenavContact.updateLosses();
        }
        this.contacts.put(contactKey, pokenavContact);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @NotNull
    public ContactData deserialize(@NotNull JsonObject jsonObject) {
        JsonPrimitive jsonPrimitive;
        JsonArray jsonArray = jsonObject.getAsJsonArray("contacts");
        this.contacts.clear();
        if (jsonArray != null) {
            for (JsonElement jsonElement : jsonArray) {
                PokenavContact contact = (PokenavContact)GSON.fromJson(jsonElement, PokenavContact.class);
                if (contact.getName() != null) {
                    this.contacts.put(contact.getKey(), contact);
                    continue;
                }
                Cobblenav.LOGGER.warn("Outdated contact '" + contact.getKey() + "' is ignored");
            }
        }
        if ((jsonPrimitive = jsonObject.getAsJsonPrimitive("title")) != null) {
            this.title = jsonPrimitive.getAsString();
        }
        return this;
    }

    @NotNull
    public String name() {
        return NAME;
    }

    @NotNull
    public JsonObject serialize() {
        JsonObject json = new JsonObject();
        json.addProperty(PlayerDataExtension.Companion.getNAME_KEY(), NAME);
        JsonArray jsonArray = new JsonArray();
        for (PokenavContact contact : this.contacts.values()) {
            jsonArray.add(GSON.toJsonTree((Object)contact));
        }
        json.add("contacts", (JsonElement)jsonArray);
        json.addProperty("title", this.title);
        return json;
    }

    public static void register() {
        PlayerDataExtensionRegistry.INSTANCE.register(NAME, ContactData.class, false);
    }

    public String getTitle() {
        return this.title;
    }

    public Map<String, PokenavContact> getContacts() {
        return this.contacts;
    }

    public String toString() {
        return "ContactData{title='" + this.title + "', contacts=" + this.contacts + "}";
    }
}

