/*
 * Decompiled with CFR 0.152.
 */
package com.metacontent.cobblenav.util;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.metacontent.cobblenav.util.finder.PokemonFeatureHelper;
import net.minecraft.class_2338;
import net.minecraft.class_2540;

public class FoundPokemon {
    private final int entityId;
    private final class_2338 pos;
    private final boolean shiny;
    private final int level;
    private final int potentialStarsAmount;
    private final String abilityName;
    private final String eggMoveName;
    private final boolean isAbilityHidden;

    public FoundPokemon(int entityId, class_2338 pos, boolean shiny, int level, int potentialStarsAmount, String abilityName, String eggMoveName, boolean isAbilityHidden) {
        this.entityId = entityId;
        this.pos = pos;
        this.shiny = shiny;
        this.level = level;
        this.potentialStarsAmount = potentialStarsAmount;
        this.abilityName = abilityName;
        this.eggMoveName = eggMoveName;
        this.isAbilityHidden = isAbilityHidden;
    }

    public static FoundPokemon createOf(PokemonEntity pokemonEntity) {
        Pokemon pokemon = pokemonEntity.getPokemon();
        int potentialStarsAmount = PokemonFeatureHelper.getPerfectIvsAmount(pokemon);
        String abilityName = pokemon.getAbility().getName();
        String eggMoveName = PokemonFeatureHelper.getEggMoveName(pokemon);
        boolean hasHiddenAbility = PokemonFeatureHelper.hasHiddenAbility(pokemon);
        return new FoundPokemon(pokemonEntity.method_5628(), pokemonEntity.method_24515(), pokemon.getShiny(), pokemon.getLevel(), potentialStarsAmount, abilityName, eggMoveName, hasHiddenAbility);
    }

    public int getEntityId() {
        return this.entityId;
    }

    public class_2338 getPos() {
        return this.pos;
    }

    public boolean isShiny() {
        return this.shiny;
    }

    public int getLevel() {
        return this.level;
    }

    public int getPotentialStarsAmount() {
        return this.potentialStarsAmount;
    }

    public String getAbilityName() {
        return this.abilityName;
    }

    public String getEggMoveName() {
        return this.eggMoveName;
    }

    public boolean isAbilityHidden() {
        return this.isAbilityHidden;
    }

    public void saveToBuf(class_2540 buf) {
        buf.writeInt(this.entityId);
        buf.method_10807(this.pos);
        buf.writeBoolean(this.shiny);
        buf.writeInt(this.level);
        buf.writeInt(this.potentialStarsAmount);
        buf.method_10814(this.abilityName);
        buf.method_10814(this.eggMoveName);
        buf.writeBoolean(this.isAbilityHidden);
    }

    public static FoundPokemon getFromBuf(class_2540 buf) {
        int entityId = buf.readInt();
        class_2338 pos = buf.method_10811();
        boolean shiny = buf.readBoolean();
        int level = buf.readInt();
        int potentialStarsAmount = buf.readInt();
        String abilityName = buf.method_19772();
        String eggMoveName = buf.method_19772();
        boolean isAbilityHidden = buf.readBoolean();
        return new FoundPokemon(entityId, pos, shiny, level, potentialStarsAmount, abilityName, eggMoveName, isAbilityHidden);
    }
}

