/*
 * Decompiled with CFR 0.152.
 */
package com.metacontent.cobblenav.util;

import com.cobblemon.mod.common.api.storage.player.PlayerAdvancementData;
import com.cobblemon.mod.common.api.storage.player.PlayerData;
import com.metacontent.cobblenav.store.AdditionalStatsData;
import com.metacontent.cobblenav.util.GrantedBadge;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_2540;

public record PlayerStats(int totalPvp, int pvpWinnings, int captures, int shinyCaptures, int evolutions, Map<UUID, Integer> pokemonUsage, Date startDate, Set<GrantedBadge> grantedBadges) {
    public static PlayerStats fromPlayerData(PlayerData data) {
        PlayerAdvancementData advancementData = data.getAdvancementData();
        int captures = advancementData.getTotalCaptureCount();
        int evolutions = advancementData.getTotalEvolvedCount();
        int pvpWinnings = advancementData.getTotalPvPBattleVictoryCount();
        int shinyCaptures = advancementData.getTotalShinyCaptureCount();
        AdditionalStatsData statsData = AdditionalStatsData.getFromData(data);
        int totalPvp = statsData.getTotalPvpCount();
        Map<UUID, Integer> pokemonUsage = statsData.getPokemonUsage();
        Date startDate = statsData.getStartDate();
        Set<GrantedBadge> grantedBadges = statsData.getGrantedBadges();
        return new PlayerStats(totalPvp, pvpWinnings, captures, shinyCaptures, evolutions, pokemonUsage, startDate, grantedBadges);
    }

    public void saveToBuf(class_2540 buf) {
        buf.writeInt(this.totalPvp);
        buf.writeInt(this.pvpWinnings);
        buf.writeInt(this.captures);
        buf.writeInt(this.shinyCaptures);
        buf.writeInt(this.evolutions);
        buf.method_34063(this.pokemonUsage, class_2540::method_10797, class_2540::writeInt);
        buf.method_10796(this.startDate);
        buf.method_34062(this.grantedBadges, (buf1, grantedBadge) -> grantedBadge.saveToBuf((class_2540)buf1));
    }

    public static PlayerStats fromBuf(class_2540 buf) {
        int totalPvp = buf.readInt();
        int pvpWinnings = buf.readInt();
        int captures = buf.readInt();
        int shinyCaptures = buf.readInt();
        int evolutions = buf.readInt();
        Map pokemonUsage = buf.method_34067(class_2540::method_10790, class_2540::readInt);
        Date startDate = buf.method_10802();
        HashSet<GrantedBadge> grantedBadges = new HashSet<GrantedBadge>(buf.method_34066(GrantedBadge::fromBuf));
        return new PlayerStats(totalPvp, pvpWinnings, captures, shinyCaptures, evolutions, pokemonUsage, startDate, grantedBadges);
    }
}

