/*
 * Decompiled with CFR 0.152.
 */
package com.metacontent.cobblenav.util;

import com.google.gson.annotations.JsonAdapter;
import com.metacontent.cobblenav.util.ContactTeamMember;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2540;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PokenavContact {
    private final String key;
    @JsonAdapter(value=GameProfile.Serializer.class)
    @Nullable
    private GameProfile profile;
    private String name;
    private String title;
    private int winnings;
    private int losses;
    private final List<ContactTeamMember> team;
    private final boolean trainer;

    public PokenavContact(String key, @Nullable GameProfile profile, @NotNull String name, String title, int winnings, int losses, List<ContactTeamMember> team, boolean trainer) {
        this.key = key;
        this.profile = profile;
        this.name = name;
        this.title = title;
        this.winnings = winnings;
        this.losses = losses;
        this.team = team;
        this.trainer = trainer;
    }

    public PokenavContact(String key, GameProfile profile, boolean trainer) {
        this(key, profile, profile.getName(), "", 0, 0, new ArrayList<ContactTeamMember>(), trainer);
    }

    public PokenavContact(String key, String name, boolean trainer) {
        this(key, null, name, "", 0, 0, new ArrayList<ContactTeamMember>(), trainer);
    }

    public String getTitleOrName() {
        return this.title.isEmpty() ? this.getNameOrProfileName() : this.title;
    }

    public String getNameOrProfileName() {
        return this.isTrainer() || this.profile == null ? this.name : this.profile.getName();
    }

    public String getName() {
        return this.name;
    }

    public void setName(@NotNull String name) {
        this.name = name;
    }

    public String getKey() {
        return this.key;
    }

    @Nullable
    public GameProfile getProfile() {
        return this.profile;
    }

    public void setProfile(@Nullable GameProfile profile) {
        this.profile = profile;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public int getWinnings() {
        return this.winnings;
    }

    public void updateWinnings() {
        ++this.winnings;
    }

    public int getLosses() {
        return this.losses;
    }

    public void updateLosses() {
        ++this.losses;
    }

    public List<ContactTeamMember> getTeam() {
        return this.team;
    }

    public boolean isTrainer() {
        return this.trainer;
    }

    public void saveToBuf(class_2540 buf) {
        buf.method_10814(this.key);
        buf.writeBoolean(this.trainer);
        if (!this.trainer) {
            buf.method_43616(this.profile);
        }
        buf.method_10814(this.name);
        buf.method_10814(this.title);
        buf.writeInt(this.winnings);
        buf.writeInt(this.losses);
        buf.method_34062(this.team, (buf1, member) -> member.saveToBuf((class_2540)buf1));
    }

    public static PokenavContact fromBuf(class_2540 buf) {
        String key = buf.method_19772();
        boolean trainer = buf.readBoolean();
        GameProfile profile = trainer ? null : buf.method_43623();
        String name = buf.method_19772();
        String title = buf.method_19772();
        int winnings = buf.readInt();
        int losses = buf.readInt();
        List team = buf.method_34066(ContactTeamMember::fromBuf);
        return new PokenavContact(key, profile, name, title, winnings, losses, team, trainer);
    }

    public String toString() {
        return "PokenavContact{key='" + this.key + "', profile=" + this.profile + ", name='" + this.name + "', title='" + this.title + "', winnings=" + this.winnings + ", losses=" + this.losses + ", team=" + this.team + ", trainer=" + this.trainer + "}";
    }
}

