/*
 * Decompiled with CFR 0.152.
 */
package com.metacontent.cobblenav.util.finder;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.google.common.util.concurrent.AtomicDouble;
import com.metacontent.cobblenav.Cobblenav;
import com.metacontent.cobblenav.util.FoundPokemon;
import com.metacontent.cobblenav.util.PokemonFeatureWeights;
import com.metacontent.cobblenav.util.finder.PokemonFeatureHelper;
import com.metacontent.cobblenav.util.finder.PokemonFinder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1657;
import net.minecraft.class_3218;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BestPokemonFinder
extends PokemonFinder {
    public BestPokemonFinder(class_1657 player, class_3218 world) {
        super(player, world);
    }

    @Override
    @Nullable
    public FoundPokemon select(@NotNull List<PokemonEntity> entities) {
        Map.Entry bestEntry;
        HashMap<FoundPokemon, Float> ratedFoundPokemonMap = new HashMap<FoundPokemon, Float>();
        PokemonFeatureWeights weights = Cobblenav.CONFIG.pokemonFeatureWeights;
        FoundPokemon highestLevelPokemon = null;
        for (PokemonEntity pokemonEntity : entities) {
            Pokemon pokemon = pokemonEntity.getPokemon();
            AtomicDouble rating = new AtomicDouble(0.0);
            boolean hasHiddenAbility = PokemonFeatureHelper.hasHiddenAbility(pokemon);
            if (hasHiddenAbility) {
                rating.addAndGet((double)weights.hiddenAbility());
            }
            int potentialStarsAmount = PokemonFeatureHelper.getPerfectIvsAmount(pokemon);
            rating.addAndGet((double)weights.getIvsWeight(potentialStarsAmount));
            String eggMoveName = PokemonFeatureHelper.getEggMoveName(pokemon);
            if (!eggMoveName.isEmpty()) {
                rating.addAndGet((double)weights.eggMove());
            }
            if (pokemon.getShiny()) {
                rating.addAndGet((double)weights.shiny());
            }
            FoundPokemon foundPokemon = new FoundPokemon(pokemonEntity.method_5628(), pokemonEntity.method_24515(), pokemon.getShiny(), pokemon.getLevel(), potentialStarsAmount, pokemon.getAbility().getName(), eggMoveName, hasHiddenAbility);
            if (highestLevelPokemon == null) {
                highestLevelPokemon = foundPokemon;
            } else if (foundPokemon.getLevel() > highestLevelPokemon.getLevel()) {
                highestLevelPokemon = foundPokemon;
            }
            ratedFoundPokemonMap.put(foundPokemon, Float.valueOf(rating.floatValue()));
        }
        if (highestLevelPokemon != null && ratedFoundPokemonMap.containsKey(highestLevelPokemon)) {
            float f = ((Float)ratedFoundPokemonMap.get(highestLevelPokemon)).floatValue();
            ratedFoundPokemonMap.put(highestLevelPokemon, Float.valueOf(f + weights.highestLevel()));
        }
        if ((bestEntry = (Map.Entry)ratedFoundPokemonMap.entrySet().stream().max(Map.Entry.comparingByValue()).orElse(null)) != null) {
            return (FoundPokemon)bestEntry.getKey();
        }
        return null;
    }
}

