/*
 * Decompiled with CFR 0.152.
 */
package com.metacontent.cobblenav.util.finder;

import com.cobblemon.mod.common.api.abilities.PotentialAbility;
import com.cobblemon.mod.common.api.moves.BenchedMove;
import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.api.moves.MoveTemplate;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.abilities.HiddenAbility;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public interface PokemonFeatureHelper {
    public static String getEggMoveName(Pokemon pokemon) {
        MoveTemplate moveTemplate;
        String name = "";
        List eggMoves = pokemon.getForm().getMoves().getEggMoves();
        ArrayList levelupMoves = new ArrayList();
        pokemon.getForm().getMoves().getLevelUpMoves().values().forEach(levelupMoves::addAll);
        for (Move move : pokemon.getMoveSet()) {
            moveTemplate = move.getTemplate();
            if (!eggMoves.contains(moveTemplate) || levelupMoves.contains(moveTemplate)) continue;
            name = move.getName();
            break;
        }
        if (name.isEmpty()) {
            for (BenchedMove benchedMove : pokemon.getBenchedMoves()) {
                moveTemplate = benchedMove.getMoveTemplate();
                if (!eggMoves.contains(moveTemplate) || levelupMoves.contains(moveTemplate)) continue;
                name = moveTemplate.getName();
                break;
            }
        }
        return name;
    }

    public static int getPerfectIvsAmount(Pokemon pokemon) {
        AtomicInteger amount = new AtomicInteger();
        pokemon.getIvs().forEach(iv -> {
            int value = (Integer)iv.getValue();
            if (value == 31) {
                amount.getAndIncrement();
            }
        });
        return amount.get();
    }

    public static boolean hasHiddenAbility(Pokemon pokemon) {
        boolean hasHiddenAbility = false;
        for (PotentialAbility potentialAbility : pokemon.getForm().getAbilities()) {
            if (potentialAbility instanceof HiddenAbility && pokemon.getAbility().getTemplate() == potentialAbility.getTemplate()) {
                hasHiddenAbility = true;
                break;
            }
            if (!(potentialAbility instanceof HiddenAbility)) continue;
            break;
        }
        return hasHiddenAbility;
    }
}

