/*
 * Decompiled with CFR 0.152.
 */
package me.justahuman.more_cobblemon_tweaks.features;

import com.cobblemon.mod.common.CobblemonItems;
import com.cobblemon.mod.common.item.berry.FriendshipRaisingBerryItem;
import com.cobblemon.mod.common.item.berry.PPRestoringBerryItem;
import com.cobblemon.mod.common.item.interactive.CandyItem;
import com.cobblemon.mod.common.item.interactive.FeatherItem;
import com.cobblemon.mod.common.item.interactive.MintItem;
import com.cobblemon.mod.common.item.interactive.PPUpItem;
import com.cobblemon.mod.common.item.interactive.VitaminItem;
import com.cobblemon.mod.common.item.interactive.ability.AbilityChangeItem;
import java.util.List;
import java.util.Set;
import me.justahuman.more_cobblemon_tweaks.config.ModConfig;
import me.justahuman.more_cobblemon_tweaks.features.egg.EnhancedEggLore;
import net.fabricmc.loader.impl.util.StringUtil;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class LoreEnhancements {
    private static final String BASE_KEY = "more_cobblemon_tweaks.lore_enhancements.";
    private static final Set<class_1792> TYPE_GEMS = Set.of(CobblemonItems.NORMAL_GEM, CobblemonItems.FIRE_GEM, CobblemonItems.WATER_GEM, CobblemonItems.GRASS_GEM, CobblemonItems.ELECTRIC_GEM, CobblemonItems.ICE_GEM, CobblemonItems.FIGHTING_GEM, CobblemonItems.POISON_GEM, CobblemonItems.GROUND_GEM, CobblemonItems.FLYING_GEM, CobblemonItems.PSYCHIC_GEM, CobblemonItems.BUG_GEM, CobblemonItems.ROCK_GEM, CobblemonItems.GHOST_GEM, CobblemonItems.DRAGON_GEM, CobblemonItems.DARK_GEM, CobblemonItems.STEEL_GEM, CobblemonItems.FAIRY_GEM);

    public static void enhanceEggLore(List<class_2561> lore, List<class_2561> newLore, EnhancedEggLore enhancedEggLore) {
        String gender;
        class_2561 name = enhancedEggLore.getName(lore);
        boolean shiny = enhancedEggLore.isShiny();
        if (ModConfig.isEnabled("shiny_egg_indicator") && shiny) {
            name = name.method_27661().method_10852((class_2561)class_2561.method_43470((String)" \u2605").method_27695(new class_124[]{class_124.field_1054, class_124.field_1067}));
        }
        if ((gender = enhancedEggLore.getGender()).equals("MALE") || gender.equals("FEMALE")) {
            boolean male = gender.equals("MALE");
            name = name.method_27661().method_10852((class_2561)class_2561.method_43470((String)(male ? " \u2642" : " \u2640")).method_27694(style -> style.method_36139(male ? 3329023 : 16536660)));
        }
        lore.set(0, name);
        List<class_2561> hatchProgress = enhancedEggLore.getHatchProgress();
        boolean spacer = false;
        if (hatchProgress != null && !hatchProgress.isEmpty()) {
            newLore.addAll(hatchProgress);
            spacer = true;
        }
        String nature = enhancedEggLore.getNature();
        String abilityName = enhancedEggLore.getAbility();
        String form = enhancedEggLore.getForm();
        if (!(nature.isBlank() && abilityName.isBlank() && form.isBlank() || !spacer)) {
            newLore.add((class_2561)class_2561.method_43470((String)" "));
            spacer = false;
        }
        if (!nature.isBlank()) {
            if (nature.contains(":")) {
                nature = StringUtil.capitalize((String)nature.substring(nature.indexOf(58) + 1));
            }
            newLore.add((class_2561)LoreEnhancements.translate("egg.nature", new Object[0]).method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)nature).method_27692(class_124.field_1068)));
            spacer = true;
        }
        if (!abilityName.isBlank()) {
            newLore.add((class_2561)LoreEnhancements.translate("egg.ability", new Object[0]).method_27692(class_124.field_1065).method_10852((class_2561)class_2561.method_43470((String)StringUtil.capitalize((String)abilityName)).method_27692(class_124.field_1068)));
            spacer = true;
        }
        if (!form.isBlank()) {
            newLore.add((class_2561)LoreEnhancements.translate("egg.form", new Object[0]).method_27692(class_124.field_1068).method_10852((class_2561)class_2561.method_43470((String)StringUtil.capitalize((String)form))));
            spacer = true;
        }
        if (enhancedEggLore.hasIVs()) {
            short hp = enhancedEggLore.getHpIV();
            short attack = enhancedEggLore.getAtkIV();
            short defense = enhancedEggLore.getDefIV();
            short spAttack = enhancedEggLore.getSpAtkIV();
            short spDefense = enhancedEggLore.getSpDefIV();
            short speed = enhancedEggLore.getSpeedIV();
            if (spacer) {
                newLore.add((class_2561)class_2561.method_43470((String)" "));
            }
            if (hp != -1) {
                newLore.add((class_2561)LoreEnhancements.translate("egg.iv.hp", new Object[0]).method_27692(class_124.field_1061).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(hp)).method_27692(class_124.field_1068)));
            }
            if (attack != -1) {
                newLore.add((class_2561)LoreEnhancements.translate("egg.iv.attack", new Object[0]).method_27692(class_124.field_1078).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(attack)).method_27692(class_124.field_1068)));
            }
            if (defense != -1) {
                newLore.add((class_2561)LoreEnhancements.translate("egg.iv.defense", new Object[0]).method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(defense)).method_27692(class_124.field_1068)));
            }
            if (spAttack != -1) {
                newLore.add((class_2561)LoreEnhancements.translate("egg.iv.sp_attack", new Object[0]).method_27692(class_124.field_1075).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(spAttack)).method_27692(class_124.field_1068)));
            }
            if (spDefense != -1) {
                newLore.add((class_2561)LoreEnhancements.translate("egg.iv.sp_defense", new Object[0]).method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(spDefense)).method_27692(class_124.field_1068)));
            }
            if (speed != -1) {
                newLore.add((class_2561)LoreEnhancements.translate("egg.iv.speed", new Object[0]).method_27692(class_124.field_1060).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(speed)).method_27692(class_124.field_1068)));
            }
        }
    }

    public static void enhanceBerryLore(class_1792 item, List<class_2561> newLore) {
        if (item instanceof FriendshipRaisingBerryItem) {
            FriendshipRaisingBerryItem friendshipBerry = (FriendshipRaisingBerryItem)item;
            newLore.add((class_2561)LoreEnhancements.translate("berry.ev", friendshipBerry.getStat().getDisplayName().getString()).method_27692(class_124.field_1080));
        } else if (item instanceof PPRestoringBerryItem) {
            newLore.add((class_2561)LoreEnhancements.translate("berry.pp", new Object[0]).method_27692(class_124.field_1080));
        }
    }

    public static void enhanceConsumablesLore(class_1792 item, List<class_2561> newLore) {
        if (item instanceof MintItem) {
            MintItem mint = (MintItem)item;
            newLore.add((class_2561)LoreEnhancements.translate("consumable.mint", class_2561.method_43471((String)mint.getNature().getDisplayName()).getString()).method_27692(class_124.field_1080));
            newLore.add((class_2561)LoreEnhancements.translate("consumable.mint_note", new Object[0]).method_27692(class_124.field_1080));
        } else if (item instanceof FeatherItem) {
            FeatherItem feather = (FeatherItem)item;
            newLore.add((class_2561)LoreEnhancements.translate("consumable.feather", feather.getStat().getDisplayName().getString()).method_27692(class_124.field_1080));
        } else if (item instanceof VitaminItem) {
            VitaminItem vitamin = (VitaminItem)item;
            newLore.add((class_2561)LoreEnhancements.translate("consumable.vitamin", vitamin.getStat().getDisplayName().getString()).method_27692(class_124.field_1080));
        } else if (item instanceof PPUpItem) {
            if (item == CobblemonItems.PP_UP) {
                newLore.add((class_2561)LoreEnhancements.translate("consumable.pp_up", new Object[0]).method_27692(class_124.field_1080));
            } else if (item == CobblemonItems.PP_MAX) {
                newLore.add((class_2561)LoreEnhancements.translate("consumable.pp_max", new Object[0]));
            }
        } else if (item instanceof CandyItem) {
            String amount = null;
            if (item == CobblemonItems.EXPERIENCE_CANDY_XS) {
                amount = "100";
            } else if (item == CobblemonItems.EXPERIENCE_CANDY_S) {
                amount = "800";
            } else if (item == CobblemonItems.EXPERIENCE_CANDY_M) {
                amount = "3,000";
            } else if (item == CobblemonItems.EXPERIENCE_CANDY_L) {
                amount = "10,000";
            } else if (item == CobblemonItems.EXPERIENCE_CANDY_XL) {
                amount = "30,000";
            } else if (item == CobblemonItems.RARE_CANDY) {
                newLore.add((class_2561)LoreEnhancements.translate("consumable.rare_candy", new Object[0]).method_27692(class_124.field_1080));
            }
            if (amount != null) {
                newLore.add((class_2561)LoreEnhancements.translate("consumable.candy", amount).method_27692(class_124.field_1080));
            }
        }
    }

    public static void enhanceHeldItemLore(class_1792 item, List<class_2561> newLore) {
        if (TYPE_GEMS.contains(item)) {
            String type = StringUtil.capitalize((String)item.toString().replace("_gem", ""));
            newLore.add((class_2561)LoreEnhancements.translate("held_item.type_gem", type).method_27692(class_124.field_1080));
            newLore.add((class_2561)class_2561.method_43470((String)" "));
            newLore.add((class_2561)class_2561.method_43470((String)"\u21e2 ").method_27692(class_124.field_1080).method_10852((class_2561)LoreEnhancements.translate("held_item.type_gem_note", new Object[0]).method_27692(class_124.field_1061)));
        } else if (item instanceof AbilityChangeItem) {
            if (item == CobblemonItems.ABILITY_CAPSULE) {
                newLore.add((class_2561)LoreEnhancements.translate("held_item.ability_capsule", new Object[0]).method_27692(class_124.field_1080));
            } else if (item == CobblemonItems.ABILITY_PATCH) {
                newLore.add((class_2561)LoreEnhancements.translate("held_item.ability_patch", new Object[0]).method_27692(class_124.field_1080));
            }
        } else {
            String key = null;
            if (item == CobblemonItems.EJECT_BUTTON) {
                key = "held_item.eject_button";
            } else if (item == CobblemonItems.FLOAT_STONE) {
                key = "held_item.float_stone";
            } else if (item == CobblemonItems.EVIOLITE) {
                key = "held_item.eviolite";
            } else if (item == CobblemonItems.WEAKNESS_POLICY) {
                key = "held_item.weakness_policy";
            }
            List<String> keys = null;
            if (item == CobblemonItems.STICKY_BARB) {
                keys = List.of("held_item.sticky_barb", "held_item.sticky_barb_secondary");
            }
            if (key != null) {
                newLore.add((class_2561)LoreEnhancements.translate(key, new Object[0]).method_27692(class_124.field_1080));
            } else if (keys != null) {
                newLore.addAll(keys.stream().map(x$0 -> LoreEnhancements.translate(x$0, new Object[0])).map(text -> text.method_27692(class_124.field_1080)).toList());
            }
        }
    }

    public static class_5250 translate(String key, Object ... args) {
        return class_2561.method_43469((String)(BASE_KEY + key), (Object[])args);
    }
}

