/*
 * Decompiled with CFR 0.152.
 */
package me.justahuman.more_cobblemon_tweaks.features.pc.search;

import com.cobblemon.mod.common.api.pokemon.Natures;
import com.cobblemon.mod.common.api.types.ElementalType;
import com.cobblemon.mod.common.api.types.ElementalTypes;
import com.cobblemon.mod.common.pokemon.Gender;
import com.cobblemon.mod.common.pokemon.Nature;
import com.cobblemon.mod.common.pokemon.Pokemon;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import me.justahuman.more_cobblemon_tweaks.features.pc.search.SearchPredicate;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public class Search {
    private final Set<SearchPredicate> options;
    private final Set<UUID> passedMons = new HashSet<UUID>();
    private final Set<UUID> failedMons = new HashSet<UUID>();

    protected Search(Set<SearchPredicate> options) {
        this.options = options;
    }

    public boolean passes(Pokemon pokemon) {
        UUID uuid = pokemon.getUuid();
        if (this.passedMons.contains(uuid)) {
            return true;
        }
        if (this.failedMons.contains(uuid)) {
            return false;
        }
        for (SearchPredicate option : this.options) {
            if (option.passes(pokemon)) continue;
            this.failedMons.add(uuid);
            return false;
        }
        this.passedMons.add(uuid);
        return true;
    }

    public static Search of(String search) {
        if (search == null || search.isBlank()) {
            return null;
        }
        search = search.toLowerCase(Locale.ROOT).trim();
        String[] options = search.split(" ");
        HashSet<SearchPredicate> searchOptions = new HashSet<SearchPredicate>();
        for (String option : options) {
            SearchPredicate searchOption;
            boolean inverted = false;
            if (option.startsWith("!")) {
                inverted = true;
                option = option.substring(1);
            }
            String query = option;
            ElementalTypes types = ElementalTypes.INSTANCE;
            Natures natures = Natures.INSTANCE;
            switch (query) {
                case "shiny": {
                    SearchPredicate searchPredicate = Pokemon::getShiny;
                    break;
                }
                case "male": {
                    SearchPredicate searchPredicate = pokemon -> pokemon.getGender() != Gender.FEMALE;
                    break;
                }
                case "female": {
                    SearchPredicate searchPredicate = pokemon -> pokemon.getGender() != Gender.MALE;
                    break;
                }
                case "genderless": {
                    SearchPredicate searchPredicate = pokemon -> pokemon.getGender() == Gender.GENDERLESS;
                    break;
                }
                case "holding": {
                    SearchPredicate searchPredicate = pokemon -> !pokemon.heldItem().method_7960();
                    break;
                }
                case "tradeable": {
                    SearchPredicate searchPredicate = Pokemon::getTradeable;
                    break;
                }
                case "fainted": {
                    SearchPredicate searchPredicate = Pokemon::isFainted;
                    break;
                }
                case "legendary": {
                    SearchPredicate searchPredicate = Pokemon::isLegendary;
                    break;
                }
                case "mythical": {
                    SearchPredicate searchPredicate = Pokemon::isMythical;
                    break;
                }
                case "ultrabeast": 
                case "ultra_beast": {
                    SearchPredicate searchPredicate = Pokemon::isUltraBeast;
                    break;
                }
                default: {
                    String move;
                    SearchPredicate searchPredicate;
                    if (class_2960.method_20207((String)query)) {
                        Nature nature = natures.getNature(query);
                        if (nature != null) {
                            searchPredicate = pokemon -> pokemon.getNature() == nature || pokemon.getMintedNature() == nature;
                            break;
                        }
                        ElementalType type = types.get(query);
                        if (type != null) {
                            searchPredicate = pokemon -> {
                                for (ElementalType pokemonType : pokemon.getTypes()) {
                                    if (pokemonType != type) continue;
                                    return true;
                                }
                                return false;
                            };
                            break;
                        }
                    }
                    if (query.startsWith("ability=")) {
                        String ability = query.substring(8);
                        searchPredicate = pokemon -> class_2561.method_43471((String)pokemon.getAbility().getDisplayName()).getString().toLowerCase(Locale.ROOT).startsWith(ability);
                        break;
                    }
                    if (query.startsWith("form=")) {
                        String form = query.substring(5);
                        searchPredicate = pokemon -> pokemon.getForm().getName().toLowerCase(Locale.ROOT).startsWith(form);
                        break;
                    }
                    if (query.startsWith("knows=")) {
                        move = query.substring(6);
                        searchPredicate = pokemon -> pokemon.getMoveSet().getMoves().stream().anyMatch(pokemonMove -> pokemonMove.getDisplayName().getString().toLowerCase(Locale.ROOT).startsWith(move));
                        break;
                    }
                    if (query.startsWith("learns=")) {
                        move = query.substring(7);
                        searchPredicate = pokemon -> pokemon.getAllAccessibleMoves().stream().anyMatch(pokemonMove -> pokemonMove.getDisplayName().getString().toLowerCase(Locale.ROOT).startsWith(move));
                        break;
                    }
                    searchPredicate = searchOption = pokemon -> pokemon.getDisplayName().getString().toLowerCase(Locale.ROOT).startsWith(query);
                }
            }
            if (searchOption == null) continue;
            if (inverted) {
                searchOptions.add(pokemon -> !searchOption.passes(pokemon));
                continue;
            }
            searchOptions.add(searchOption);
        }
        return new Search(searchOptions);
    }
}

