/*
 * Decompiled with CFR 0.152.
 */
package drai.dev.gravelmon.pokemon.attributes;

import org.jetbrains.annotations.Nullable;

public enum Type {
    NORMAL("normal"),
    FIRE("fire"),
    FIGHTING("fighting"),
    WATER("water"),
    FLYING("flying"),
    GRASS("grass"),
    POISON("poison"),
    ELECTRIC("electric"),
    GROUND("ground"),
    PSYCHIC("psychic"),
    ROCK("rock"),
    ICE("ice"),
    BUG("bug"),
    DRAGON("dragon"),
    GHOST("ghost"),
    DARK("dark"),
    STEEL("steel"),
    FAIRY("fairy"),
    SHADOW("shadow", DARK),
    WIND("wind", FLYING),
    COSMIC("cosmic", PSYCHIC),
    SOUND("sound", NORMAL),
    NUCLEAR("nuclear", POISON),
    DIGITAL("digital", ELECTRIC),
    PLASTIC("plastic", NORMAL),
    LIGHT("light", PSYCHIC),
    SLIME("slime", POISON),
    CRYSTAL("crystal", ROCK),
    ELDRITCH("eldritch", GHOST),
    QUESTION_MARK("questionmark", NORMAL);

    private final String name;
    @Nullable
    private Type substitutionType;

    private Type(String name, Type substitutionType) {
        this.name = name;
        this.substitutionType = substitutionType;
    }

    private Type(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Type getSubstitutionType() {
        return this.substitutionType;
    }

    public static Type getByName(String name) {
        for (Type type : Type.values()) {
            if (!type.getName().equalsIgnoreCase(name)) continue;
            return type;
        }
        return null;
    }
}

