/*
 * Decompiled with CFR 0.152.
 */
package drai.dev.gravelsextendedbattles;

import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.fossil.Fossil;
import com.cobblemon.mod.common.api.fossil.Fossils;
import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.api.types.ElementalType;
import com.cobblemon.mod.common.pokemon.Species;
import drai.dev.gravelsextendedbattles.GravelmonConfig;
import drai.dev.gravelsextendedbattles.ShowdownFileManager;
import drai.dev.gravelsextendedbattles.SpeciesManager;
import drai.dev.gravelsextendedbattles.interfaces.GravelmonPokemonSpeciesAccessor;
import drai.dev.gravelsextendedbattles.loot.GravelmonFossilManager;
import drai.dev.gravelsextendedbattles.mixin.RegistryLikeIdentifierConditionAccessor;
import drai.dev.gravelsextendedbattles.resorting.GravelmonMoveSubstitution;
import drai.dev.gravelsextendedbattles.resorting.GravelmonPokedexResorter;
import drai.dev.gravelsextendedbattles.starters.GravelmonStarterManager;
import eu.midnightdust.lib.config.MidnightConfig;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import kotlin.Unit;
import net.minecraft.class_2960;

public class GravelsExtendedBattles {
    public static final Map<class_2960, Fossil> FOSSIL_MAP = new HashMap<class_2960, Fossil>();
    public static List<ElementalType> NEW_TYPES = new ArrayList<ElementalType>();
    public static boolean ICON_MIXIN_INIT = false;
    public static boolean ICON_WIDGET_INIT = false;
    public static final String MOD_ID = "gravels_extended_battles";
    public static final ArrayList<String> SHOWDOWN_FILES = new ArrayList<String>(List.of("abilities.js", "conditions.js", "items.js", "moves.js", "pokedex.js", "scripts.js", "tags.js"));
    public static final ArrayList<String> FAN_GAME_TYPE_CHART = new ArrayList<String>(List.of("typechart2.js"));
    public static final ArrayList<String> GEB_TYPE_CHART = new ArrayList<String>(List.of("typechart.js"));
    public static Logger LOGGER = Logger.getLogger("gravels_extended_battles");
    public static List<String> BANNED_LABELS;
    public static List<String> ALLOWED_LABELS;
    public static List<String> PASSWORDS;
    public static List<String> IMPLEMENTED_TYPES;
    public static int TYPE_COUNT;
    public static boolean ADD_STARTERS;
    public static List<Species> SORTED_SPECIES;

    public static void init(String minecraftFolder) {
        MidnightConfig.init((String)"gravelmon", GravelmonConfig.class);
        GravelmonConfig gravelmonConfig = new GravelmonConfig();
        BANNED_LABELS = gravelmonConfig.getBannedLabels();
        ALLOWED_LABELS = gravelmonConfig.getAllowedLabels();
        IMPLEMENTED_TYPES = gravelmonConfig.getImplementedTypes();
        ADD_STARTERS = gravelmonConfig.getShouldAddStarters();
        PASSWORDS = gravelmonConfig.getPasswords();
        for (String string : SHOWDOWN_FILES) {
            try {
                ShowdownFileManager.exportResource(minecraftFolder, string);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        boolean enableFangameTypechart = gravelmonConfig.getEnableOriginalFanGameTypings();
        if (enableFangameTypechart) {
            for (String fileName : FAN_GAME_TYPE_CHART) {
                try {
                    ShowdownFileManager.exportResource(minecraftFolder, fileName);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            try {
                String string = minecraftFolder + File.separator + "typechart2.js";
                String renamedFilePath = minecraftFolder + File.separator + "typechart.js";
                ShowdownFileManager.renameFile(string, renamedFilePath);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        } else {
            for (String fileName : GEB_TYPE_CHART) {
                try {
                    ShowdownFileManager.exportResource(minecraftFolder, fileName);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        PokemonSpecies.INSTANCE.getObservable().subscribe(Priority.LOWEST, pokemonSpecies -> {
            SpeciesManager.banPokemon(pokemonSpecies, (GravelmonPokemonSpeciesAccessor)pokemonSpecies);
            if (gravelmonConfig.getEnableDexResort()) {
                GravelmonPokedexResorter.resort(pokemonSpecies);
            }
            SpeciesManager.processFormEvolutionAdditions();
            SpeciesManager.processTypeChanges();
            GravelmonStarterManager.processStarters();
            GravelmonMoveSubstitution.substituteMoves();
            return Unit.INSTANCE;
        });
        Fossils.INSTANCE.getObservable().subscribe(Priority.LOWEST, fossils -> {
            fossils.all().forEach(fossil -> {
                List<class_2960> identifiers = fossil.getFossils().stream().map(fossilPredicate -> ((RegistryLikeIdentifierConditionAccessor)fossilPredicate.component1()).getIdentifier()).toList();
                for (class_2960 identifier : identifiers) {
                    FOSSIL_MAP.put(identifier, (Fossil)fossil);
                }
            });
            GravelmonFossilManager.scanLootPools();
            return Unit.INSTANCE;
        });
    }

    static {
        TYPE_COUNT = 18;
        ADD_STARTERS = false;
        SORTED_SPECIES = new ArrayList<Species>();
    }
}

