/*
 * Decompiled with CFR 0.152.
 */
package drai.dev.gravelsextendedbattles;

import drai.dev.gravelsextendedbattles.GravelsExtendedBattles;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;

public class ShowdownFileManager {
    public static void renameFile(String originalFilePath, String newFilePath) throws IOException {
        Path source = Paths.get(originalFilePath, new String[0]);
        Path destination = Paths.get(newFilePath, new String[0]);
        Files.move(source, destination, StandardCopyOption.REPLACE_EXISTING);
    }

    public static String exportResource(String showdownFolder, String resourceName) throws Exception {
        String jarFolder = showdownFolder + resourceName;
        Files.createDirectories(new File(showdownFolder).toPath(), new FileAttribute[0]);
        try (InputStream stream = GravelsExtendedBattles.class.getResourceAsStream(resourceName);
             FileOutputStream resStreamOut = new FileOutputStream(jarFolder);){
            int readBytes;
            if (stream == null) {
                throw new Exception("Cannot get resource \"" + resourceName + "\" from Jar file.");
            }
            byte[] buffer = new byte[4096];
            Files.createDirectories(new File(showdownFolder).toPath(), new FileAttribute[0]);
            while ((readBytes = stream.read(buffer)) > 0) {
                ((OutputStream)resStreamOut).write(buffer, 0, readBytes);
            }
        }
        return jarFolder + resourceName;
    }
}

