/*
 * Decompiled with CFR 0.152.
 */
package drai.dev.gravelsextendedbattles;

import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.api.pokemon.evolution.Evolution;
import com.cobblemon.mod.common.api.pokemon.evolution.requirement.EvolutionRequirement;
import com.cobblemon.mod.common.api.types.ElementalType;
import com.cobblemon.mod.common.api.types.ElementalTypes;
import com.cobblemon.mod.common.pokemon.FormData;
import com.cobblemon.mod.common.pokemon.Species;
import com.cobblemon.mod.common.pokemon.evolution.requirements.LevelRequirement;
import com.cobblemon.mod.common.pokemon.evolution.variants.LevelUpEvolution;
import drai.dev.gravelmon.pokemon.attributes.EvolutionEntry;
import drai.dev.gravelmon.pokemon.attributes.EvolutionRequirementCondition;
import drai.dev.gravelmon.pokemon.attributes.EvolutionType;
import drai.dev.gravelmon.pokemon.attributes.Label;
import drai.dev.gravelmon.pokemon.attributes.Type;
import drai.dev.gravelmon.pokemon.attributes.TypeChangeEntry;
import drai.dev.gravelsextendedbattles.GravelsExtendedBattles;
import drai.dev.gravelsextendedbattles.interfaces.GravelmonPokemonSpeciesAccessor;
import drai.dev.gravelsextendedbattles.mixin.FormDataAccessor;
import drai.dev.gravelsextendedbattles.mixin.LevelRequirementAccessor;
import drai.dev.gravelsextendedbattles.mixin.PokemonSpeciesAccessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

public class SpeciesManager {
    private static final Map<String, List<TypeChangeEntry>> changedTypes = new HashMap<String, List<TypeChangeEntry>>();
    private static final HashMap<String, List<EvolutionEntry>> additionalFormEvolutions = new HashMap();

    public static void banPokemon(@NotNull PokemonSpecies pokemonSpecies, GravelmonPokemonSpeciesAccessor accessor) {
        HashMap<class_2960, Species> currentSpecies = accessor.getSpeciesByIdentifier();
        List<Map.Entry> speciesToBeRemoved = currentSpecies.entrySet().stream().filter(ResourceLocationSpeciesEntry -> SpeciesManager.containsBannedLabels(((Species)ResourceLocationSpeciesEntry.getValue()).getLabels().stream().toList())).toList();
        if (!speciesToBeRemoved.isEmpty()) {
            accessor.getSpeciesByDex().clear();
            pokemonSpecies.getImplemented().clear();
            for (Map.Entry entry : speciesToBeRemoved) {
                currentSpecies.remove(entry.getKey());
            }
            for (Species species : currentSpecies.values()) {
                if (species == null) continue;
                accessor.getSpeciesByDex().remove((Object)species.getResourceIdentifier().method_12836(), (Object)species.getNationalPokedexNumber());
                accessor.getSpeciesByDex().put((Object)species.getResourceIdentifier().method_12836(), (Object)species.getNationalPokedexNumber(), (Object)species);
                if (species.getImplemented() || !SpeciesManager.containsBannedLabels(List.of("not_modeled"))) {
                    pokemonSpecies.getImplemented().add(species);
                }
                ArrayList evolutions = new ArrayList(species.getEvolutions());
                for (Evolution evolutionData : evolutions) {
                    PokemonProperties result = evolutionData.getResult();
                    Species resultSpecies = currentSpecies.get(new class_2960("cobblemon", result.getSpecies() != null ? result.getSpecies() : ""));
                    if (resultSpecies != null) {
                        FormData resultForm = resultSpecies.getForm(Collections.singleton(result.getForm()));
                        if (!SpeciesManager.containsBannedLabels(resultForm.getLabels().stream().toList()) && !SpeciesManager.containsBannedLabels(resultSpecies.getLabels().stream().toList())) continue;
                        species.getEvolutions().remove(evolutionData);
                        continue;
                    }
                    species.getEvolutions().remove(evolutionData);
                }
                ArrayList forms = new ArrayList(species.getForms());
                for (FormData formData : forms) {
                    if (SpeciesManager.containsBannedLabels(formData.getLabels().stream().toList())) {
                        species.getForms().remove(formData);
                        continue;
                    }
                    ArrayList formEvolutions = new ArrayList(formData.getEvolutions());
                    for (Evolution formEvolutionData : formEvolutions) {
                        PokemonProperties result = formEvolutionData.getResult();
                        Species resultSpecies = currentSpecies.get(new class_2960("cobblemon", result.getSpecies() != null ? result.getSpecies() : ""));
                        if (resultSpecies != null) {
                            FormData resultForm = resultSpecies.getForm(Collections.singleton(result.getForm()));
                            if (!SpeciesManager.containsBannedLabels(resultForm.getLabels().stream().toList())) continue;
                            species.getEvolutions().remove(formEvolutionData);
                            continue;
                        }
                        formData.getEvolutions().remove(formEvolutionData);
                    }
                }
            }
        }
    }

    public static boolean containsBannedLabels(String species, String form) {
        if (species == null) {
            return true;
        }
        Species pokemon = PokemonSpecies.INSTANCE.getByName(species);
        if (pokemon == null) {
            return true;
        }
        return SpeciesManager.containsBannedLabels(pokemon.getForm(Set.of(form == null ? "" : form)).getLabels().stream().toList());
    }

    public static boolean containsBannedLabels(List<String> labels) {
        if (labels == null) {
            return false;
        }
        if (labels.isEmpty()) {
            return false;
        }
        for (String label : labels) {
            try {
                Label labelEnum = Label.valueOf(label.toUpperCase());
                if (Label.passwordProtectedLabels.containsKey((Object)labelEnum) && !GravelsExtendedBattles.PASSWORDS.contains(Label.passwordProtectedLabels.get((Object)labelEnum))) {
                    return true;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (GravelsExtendedBattles.ALLOWED_LABELS.contains(label)) {
                return false;
            }
            if (!GravelsExtendedBattles.BANNED_LABELS.contains(label)) continue;
            return true;
        }
        return false;
    }

    public static void registerFormEvolution(String pokemon, EvolutionEntry moveToInsert) {
        additionalFormEvolutions.computeIfAbsent(pokemon, k -> new ArrayList()).add(moveToInsert);
    }

    public static void registerTypeChange(String pokemon, TypeChangeEntry typeChangeEntry) {
        changedTypes.computeIfAbsent(pokemon, k -> new ArrayList()).add(typeChangeEntry);
    }

    public static void processTypeChanges() {
        List<String> implementedTypes = GravelsExtendedBattles.IMPLEMENTED_TYPES;
        changedTypes.forEach((key, value) -> {
            String[] splitFrom = key.split(" ");
            Species pokemon = PokemonSpecies.INSTANCE.getByName(splitFrom[0]);
            if (pokemon != null) {
                FormData form = null;
                if (splitFrom.length > 1) {
                    form = pokemon.getForm(new HashSet<String>(List.of(splitFrom[1].toLowerCase())));
                }
                boolean isForm = false;
                if (form != null) {
                    isForm = !form.getName().equalsIgnoreCase("normal");
                }
                for (TypeChangeEntry typeChanges : value) {
                    ElementalType newType;
                    if (!implementedTypes.contains(typeChanges.getTo()) || (newType = ElementalTypes.INSTANCE.get(typeChanges.getTo())) == null) continue;
                    if (!isForm) {
                        if (pokemon.getPrimaryType().getName().equalsIgnoreCase(typeChanges.getFrom())) {
                            pokemon.setPrimaryType$common(newType);
                            continue;
                        }
                        if ((pokemon.getSecondaryType() == null || !pokemon.getSecondaryType().getName().equalsIgnoreCase(typeChanges.getFrom())) && (pokemon.getSecondaryType() != null || typeChanges.getFrom() != null)) continue;
                        pokemon.setSecondaryType$common(newType);
                        continue;
                    }
                    FormDataAccessor agreeableForm = (FormDataAccessor)form;
                    if (form.getPrimaryType().getName().equalsIgnoreCase(typeChanges.getFrom())) {
                        agreeableForm.setPrimaryType(newType);
                        continue;
                    }
                    if ((form.getSecondaryType() == null || !form.getSecondaryType().getName().equalsIgnoreCase(typeChanges.getFrom())) && (form.getSecondaryType() != null || typeChanges.getFrom() != null)) continue;
                    agreeableForm.setSecondaryType(newType);
                }
            }
        });
        PokemonSpecies pokemonSpecies = PokemonSpecies.INSTANCE;
        PokemonSpeciesAccessor accessor = (PokemonSpeciesAccessor)pokemonSpecies;
        HashMap<class_2960, Species> currentSpecies = accessor.getSpeciesByIdentifier();
        currentSpecies.forEach((key, value) -> SpeciesManager.substituteType(value, implementedTypes));
    }

    private static void substituteType(Species species, List<String> implementedTypes) {
        String substitutionTypeName;
        ElementalType newType;
        Type substitutionType;
        Type type;
        if (!implementedTypes.contains(species.getPrimaryType().getName()) && (type = Type.getByName(species.getPrimaryType().getName())) != null && (substitutionType = type.getSubstitutionType()) != null && (newType = ElementalTypes.INSTANCE.get(substitutionTypeName = substitutionType.getName())) != null) {
            species.setPrimaryType$common(newType);
        }
        if (species.getSecondaryType() != null && !implementedTypes.contains(species.getSecondaryType().getName()) && (type = Type.getByName(species.getSecondaryType().getName())) != null && (substitutionType = type.getSubstitutionType()) != null && (newType = ElementalTypes.INSTANCE.get(substitutionTypeName = substitutionType.getName())) != null) {
            species.setSecondaryType$common(newType);
        }
        for (FormData formData : species.getForms()) {
            FormDataAccessor formDataAccessor;
            String substitutionTypeName2;
            ElementalType newType2;
            Type substitutionType2;
            Type type2;
            if (!implementedTypes.contains(formData.getPrimaryType().getName()) && (type2 = Type.getByName(formData.getPrimaryType().getName())) != null && (substitutionType2 = type2.getSubstitutionType()) != null && (newType2 = ElementalTypes.INSTANCE.get(substitutionTypeName2 = substitutionType2.getName())) != null) {
                formDataAccessor = (FormDataAccessor)formData;
                formDataAccessor.setPrimaryType(newType2);
            }
            if (formData.getSecondaryType() == null || implementedTypes.contains(formData.getSecondaryType().getName()) || (type2 = Type.getByName(formData.getSecondaryType().getName())) == null || (substitutionType2 = type2.getSubstitutionType()) == null || (newType2 = ElementalTypes.INSTANCE.get(substitutionTypeName2 = substitutionType2.getName())) == null) continue;
            formDataAccessor = (FormDataAccessor)formData;
            formDataAccessor.setSecondaryType(newType2);
        }
    }

    public static void processFormEvolutionAdditions() {
        additionalFormEvolutions.forEach((key, value) -> {
            String[] splitFrom = key.split(" ");
            Species pokemon = PokemonSpecies.INSTANCE.getByName(splitFrom[0]);
            if (pokemon != null) {
                FormData form = null;
                if (splitFrom.length < 2) {
                    return;
                }
                form = pokemon.getForm(new HashSet<String>(List.of(splitFrom[1])));
                if (form.getName().equalsIgnoreCase("normal")) {
                    return;
                }
                Set evolutions = form.getEvolutions();
                for (EvolutionEntry evolution : value) {
                    Evolution evolutionObj = SpeciesManager.resolveEvolution(form, evolution);
                    if (evolutionObj == null) continue;
                    evolutions.add(evolutionObj);
                    ((FormDataAccessor)form).setEvolutions(evolutions);
                }
            }
        });
    }

    private static Evolution resolveEvolution(FormData form, EvolutionEntry evolutionEntry) {
        String evolutionId = form.getSpecies().getName().toLowerCase() + "_" + evolutionEntry.getResult().replaceAll(" ", "_").toLowerCase();
        PokemonProperties result = PokemonProperties.Companion.parse(evolutionEntry.getResult());
        if (result.getSpecies() == null) {
            return null;
        }
        if (evolutionEntry.getKind() == EvolutionType.LEVEL_UP) {
            Set<EvolutionRequirement> requirements = SpeciesManager.getEvolutionRequirements(evolutionEntry);
            return new LevelUpEvolution(evolutionId, result, true, false, requirements, new HashSet(), true);
        }
        return null;
    }

    @NotNull
    private static Set<EvolutionRequirement> getEvolutionRequirements(EvolutionEntry evolutionEntry) {
        HashSet<EvolutionRequirement> requirements = new HashSet<EvolutionRequirement>();
        evolutionEntry.getRequirements().forEach(evolutionRequirementEntry -> {
            if (evolutionRequirementEntry.getRequirementKind().equalsIgnoreCase(EvolutionRequirementCondition.LEVEL.getName())) {
                LevelRequirement requirement = new LevelRequirement();
                int level = Integer.parseInt(evolutionRequirementEntry.getConditionParameter());
                ((LevelRequirementAccessor)requirement).setMinLevel(level);
                requirements.add((EvolutionRequirement)requirement);
            }
        });
        return requirements;
    }
}

