/*
 * Decompiled with CFR 0.152.
 */
package drai.dev.gravelsextendedbattles.loot;

import com.cobblemon.mod.common.api.fossil.Fossil;
import drai.dev.gravelsextendedbattles.GravelsExtendedBattles;
import drai.dev.gravelsextendedbattles.SpeciesManager;
import drai.dev.gravelsextendedbattles.mixin.loot.LootItemAccessor;
import drai.dev.gravelsextendedbattles.mixin.loot.LootPoolAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_52;
import net.minecraft.class_55;
import net.minecraft.class_75;
import net.minecraft.class_77;
import net.minecraft.class_79;
import net.minecraft.class_7923;

public class GravelmonFossilManager {
    private static final List<class_55[]> LOOT_POOLS = new ArrayList<class_55[]>();
    private static final Map<class_2960, List<Supplier<class_1792>>> LOOT_POOL_ADDITIONS = new HashMap<class_2960, List<Supplier<class_1792>>>();

    public static void addFossil(class_2960 lootTableResourceLocation, Supplier<class_1792> fossil) {
        LOOT_POOL_ADDITIONS.computeIfAbsent(lootTableResourceLocation, k -> new ArrayList()).add(fossil);
    }

    public static void addFossil(List<class_2960> lootTableResourceLocations, Supplier<class_1792> fossil) {
        for (class_2960 lootTableResourceLocation : lootTableResourceLocations) {
            LOOT_POOL_ADDITIONS.computeIfAbsent(lootTableResourceLocation, k -> new ArrayList()).add(fossil);
        }
    }

    public static void addLootPools(class_55[] lootPool) {
        LOOT_POOLS.add(lootPool);
    }

    public static void scanLootPools() {
        LOOT_POOLS.forEach(lootPools -> Arrays.stream(lootPools).forEach(lootPool -> {
            LootPoolAccessor accessor = GravelmonFossilManager.createLootPoolAccessor(lootPool);
            ArrayList<class_79> entries = new ArrayList<class_79>(List.of(accessor.getEntries()));
            new ArrayList<class_79>(entries).stream().filter(lootPoolEntryContainer -> lootPoolEntryContainer.method_29318() == class_75.field_25207).map(entryContainer -> (class_77)entryContainer).forEach(lootItem -> {
                class_1792 item = GravelmonFossilManager.createLootItemAccessor(lootItem).getItem();
                class_2960 itemId = class_7923.field_41178.method_10221((Object)item);
                Fossil fossil = GravelsExtendedBattles.FOSSIL_MAP.get(itemId);
                if (fossil == null) {
                    return;
                }
                if (!SpeciesManager.containsBannedLabels(fossil.getResult().getSpecies(), fossil.getResult().getForm())) {
                    return;
                }
                entries.remove(lootItem);
                if (entries.isEmpty()) {
                    Optional<Fossil> optionalFossil = GravelsExtendedBattles.FOSSIL_MAP.values().stream().filter(fossil1 -> !SpeciesManager.containsBannedLabels(fossil1.getResult().getSpecies(), fossil1.getResult().getForm())).findFirst();
                    if (optionalFossil.isEmpty()) {
                        return;
                    }
                    List<class_2960> fossilItemId = GravelsExtendedBattles.FOSSIL_MAP.entrySet().stream().filter(entry -> entry.getValue() == optionalFossil.get()).map(Map.Entry::getKey).toList();
                    if (fossilItemId.isEmpty()) {
                        return;
                    }
                    class_1792 newFossilItem = (class_1792)class_7923.field_41178.method_10223(fossilItemId.get(0));
                    GravelmonFossilManager.createLootItemAccessor(lootItem).setItem(newFossilItem);
                    entries.add((class_79)lootItem);
                }
            });
            class_79[] array = new class_79[entries.size()];
            accessor.setEntries(entries.toArray(array));
        }));
    }

    public static LootPoolAccessor createLootPoolAccessor(class_55 lootPool) {
        return (LootPoolAccessor)lootPool;
    }

    public static LootItemAccessor createLootItemAccessor(class_77 lootItem) {
        return (LootItemAccessor)lootItem;
    }

    public static void processFossilAdditions(class_2960 id, Consumer<class_55> tableBuilder) {
        if (LOOT_POOL_ADDITIONS.containsKey(id)) {
            class_55.class_56 poolBuilder = new class_55.class_56();
            LOOT_POOL_ADDITIONS.get(id).forEach(itemSupplier -> poolBuilder.method_351((class_79.class_80)class_77.method_411((class_1935)((class_1935)itemSupplier.get())).method_437(2)));
            tableBuilder.accept(poolBuilder.method_355());
        }
    }

    public static void processFossilAdditions(class_2960 id, class_52.class_53 tableBuilder) {
        if (LOOT_POOL_ADDITIONS.containsKey(id)) {
            class_55.class_56 poolBuilder = new class_55.class_56();
            LOOT_POOL_ADDITIONS.get(id).forEach(itemSupplier -> poolBuilder.method_351((class_79.class_80)class_77.method_411((class_1935)((class_1935)itemSupplier.get())).method_437(2)));
            tableBuilder.method_336(poolBuilder);
        }
    }
}

