/*
 * Decompiled with CFR 0.152.
 */
package drai.dev.gravelsextendedbattles.mixinimpl;

import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.api.spawning.detail.PokemonSpawnDetail;
import com.cobblemon.mod.common.pokemon.FormData;
import com.cobblemon.mod.common.pokemon.Species;
import drai.dev.gravelsextendedbattles.GravelsExtendedBattles;
import drai.dev.gravelsextendedbattles.SpeciesManager;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class GravelmonBannedSpawnDetails {
    private static boolean notSuppressedYet = true;

    public static void checkForBannedPokemon(PokemonSpawnDetail spawnDetail, CallbackInfoReturnable<Boolean> cir) {
        PokemonProperties pokemon = spawnDetail.getPokemon();
        if (pokemon.getSpecies() != null) {
            FormData formData;
            Species species = PokemonSpecies.INSTANCE.getByName(pokemon.getSpecies());
            if (SpeciesManager.containsBannedLabels(species.getLabels().stream().toList())) {
                cir.setReturnValue((Object)false);
                cir.cancel();
                return;
            }
            if (!pokemon.getAspects().isEmpty() && (formData = species.getForm(pokemon.getAspects())) == species.getStandardForm()) {
                cir.setReturnValue((Object)false);
                cir.cancel();
                return;
            }
        } else {
            if (notSuppressedYet) {
                notSuppressedYet = false;
                GravelsExtendedBattles.LOGGER.fine("Suppressed invalid species spawn detail warnings");
            }
            cir.setReturnValue((Object)false);
            cir.cancel();
        }
    }
}

