/*
 * Decompiled with CFR 0.152.
 */
package drai.dev.gravelsextendedbattles.resorting;

import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.pokemon.Species;
import drai.dev.gravelsextendedbattles.GravelsExtendedBattles;
import drai.dev.gravelsextendedbattles.resorting.nodes.IEvolutionNode;
import drai.dev.gravelsextendedbattles.resorting.nodes.SpeciesEvolutionNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.apache.commons.lang3.mutable.MutableInt;

public class EvolutionGraph {
    private final Map<String, IEvolutionNode> nodes;
    private final Collection<Species> species;
    private List<IEvolutionNode> sortedSpecies;
    private final List<IEvolutionNode> speciesWithMultiplePreEvolutions = new ArrayList<IEvolutionNode>();

    public EvolutionGraph(PokemonSpecies pokemonSpecies) {
        this.nodes = new HashMap<String, IEvolutionNode>();
        this.species = pokemonSpecies.getSpecies();
        this.species.forEach(this::addPokemon);
        this.species.forEach(species1 -> {
            String name = species1.getName().toLowerCase();
            Set evolutions = species1.getEvolutions();
            evolutions.forEach(evolution -> {
                PokemonProperties result = evolution.getResult();
                this.addEvolution(name, null, result.getSpecies(), null);
            });
            species1.getForms().forEach(formData -> {
                if (!(formData.getAspects().isEmpty() || formData.getAspects().contains("female") || formData.getAspects().contains("mega") || formData.getAspects().contains("mega-x") || formData.getAspects().contains("mega-y") || formData.getAspects().contains("primal") || formData.getAspects().contains("alola-totem") || formData.getAspects().contains("gmax"))) {
                    if (formData.getName().equalsIgnoreCase("normal")) {
                        return;
                    }
                    Set formEvolutions = formData.getEvolutions();
                    formEvolutions.forEach(formEvolution -> {
                        PokemonProperties result = formEvolution.getResult();
                        this.addEvolution(name, null, result.getSpecies(), null);
                    });
                }
            });
        });
        this.sortedSpecies = new ArrayList<IEvolutionNode>(this.nodes.values().stream().sorted().toList());
        this.speciesWithMultiplePreEvolutions.forEach(multiplePreEvoSpecies -> {
            HashMap<IEvolutionNode, IEvolutionNode> baseForms = new HashMap<IEvolutionNode, IEvolutionNode>();
            for (IEvolutionNode preEvo : multiplePreEvoSpecies.getPreEvolutions()) {
                baseForms.put(this.getBaseForm(preEvo), preEvo);
            }
            if (baseForms.isEmpty()) {
                return;
            }
            List sortedBaseForms = baseForms.keySet().stream().sorted((o1, o2) -> Integer.compare(this.getMaxPokedexNumber((IEvolutionNode)o1), this.getMaxPokedexNumber((IEvolutionNode)o2))).toList();
            IEvolutionNode baseFormWithHighestPokedexNumber = (IEvolutionNode)sortedBaseForms.get(0);
            IEvolutionNode baseFormWithLowestPokedexNumber = (IEvolutionNode)sortedBaseForms.get(sortedBaseForms.size() - 1);
            baseForms.keySet().stream().filter(key -> key != baseFormWithHighestPokedexNumber).forEach(key -> {
                ((IEvolutionNode)baseForms.get(key)).getEvolutions().remove(multiplePreEvoSpecies);
                multiplePreEvoSpecies.getPreEvolutions().remove(baseForms.get(key));
            });
            List<IEvolutionNode> baseFormList = baseForms.keySet().stream().filter(key -> key != baseFormWithLowestPokedexNumber).sorted().toList();
            int startingSortingNumber = this.sortedSpecies.indexOf(baseFormWithLowestPokedexNumber);
            for (int i = 0; i < baseFormList.size(); ++i) {
                IEvolutionNode node = baseFormList.get(i);
                this.shiftDex(node, startingSortingNumber + 1 + i);
            }
        });
        this.sortedSpecies = new ArrayList<IEvolutionNode>(this.sortedSpecies.stream().sorted().toList());
        MutableInt dexNumber = new MutableInt(0);
        for (int i = 0; i < this.sortedSpecies.size(); ++i) {
            IEvolutionNode species = this.sortedSpecies.get(i);
            this.updateDexNumbers(species, dexNumber);
        }
        GravelsExtendedBattles.SORTED_SPECIES = this.sortedSpecies.stream().map(IEvolutionNode::getPokemon).toList();
    }

    public void shiftDex(IEvolutionNode node, int newNumber) {
        this.sortedSpecies.remove(node);
        this.sortedSpecies.add(newNumber - 1, node);
    }

    public void addPokemon(Species species) {
        String name = species.getName().toLowerCase();
        if (!this.nodes.containsKey(name)) {
            this.nodes.put(name, new SpeciesEvolutionNode(species));
        }
        species.getForms().forEach(formData -> {
            String form = formData.getName().toLowerCase();
            if (!(formData.getAspects().isEmpty() || formData.getAspects().contains("female") || formData.getAspects().contains("mega") || formData.getAspects().contains("mega-x") || formData.getAspects().contains("mega-y") || formData.getAspects().contains("primal") || formData.getAspects().contains("alola-totem") || formData.getAspects().contains("gmax") || !formData.getName().equalsIgnoreCase("normal"))) {
                return;
            }
        });
    }

    public void addEvolution(String fromName, String fromForm, String toName, String toForm) {
        String toKey;
        String fromKey = fromForm == null ? fromName : fromName + "-" + fromForm;
        String string = toKey = toForm == null ? toName : toName + "-" + toForm;
        if (toName == null) {
            GravelsExtendedBattles.LOGGER.log(Level.WARNING, "Invalid evolution result for evolution of " + fromKey);
        }
        if (fromKey.equals(toKey)) {
            return;
        }
        IEvolutionNode fromNode = this.nodes.get(fromKey);
        IEvolutionNode toNode = this.nodes.get(toKey);
        if (fromNode != null && toNode != null) {
            if (toNode.getEvolutions().contains(fromNode)) {
                return;
            }
            if (fromNode.getEvolutions().contains(toNode)) {
                return;
            }
            fromNode.addEvolution(toNode);
            toNode.addPreEvolution(fromNode);
            if (toNode.getPreEvolutions().size() > 1 && !this.speciesWithMultiplePreEvolutions.contains(toNode)) {
                this.speciesWithMultiplePreEvolutions.add(toNode);
            }
        }
    }

    public IEvolutionNode getBaseForm(IEvolutionNode node) {
        Iterator<IEvolutionNode> iterator = node.getPreEvolutions().iterator();
        if (iterator.hasNext()) {
            IEvolutionNode preEvo = iterator.next();
            return this.getBaseForm(preEvo);
        }
        return node;
    }

    public int getMaxPokedexNumber(IEvolutionNode node) {
        return this.getMaxPokedexNumber(node, node.getPokedexNumber());
    }

    private int getMaxPokedexNumber(IEvolutionNode node, int max) {
        if (node.getPokedexNumber() > max) {
            max = node.getPokedexNumber();
        }
        for (IEvolutionNode evolution : node.getEvolutions()) {
            max = this.getMaxPokedexNumber(evolution, max);
        }
        return max;
    }

    private int getMinPokedexNumber(IEvolutionNode node, int min) {
        if (node.getPokedexNumber() < min) {
            min = node.getPokedexNumber();
        }
        for (IEvolutionNode evolution : node.getEvolutions()) {
            min = this.getMaxPokedexNumber(evolution, min);
        }
        return min;
    }

    public void printEvolutions(IEvolutionNode node, int i) {
        if (this.isBeginningNode(node)) {
            this.printEvolutions(node, i, "");
        }
    }

    private boolean isBeginningNode(IEvolutionNode node) {
        if (node != null) {
            return node.getPreEvolutions().isEmpty() && node.getForm() == null;
        }
        return false;
    }

    private void printEvolutions(IEvolutionNode node, int i, String indent) {
        System.out.println(indent + "\u2514" + node.getPokedexNumber() + "-" + node.getSpecies() + (String)(node.getForm() == null ? "" : " " + node.getForm()));
        for (IEvolutionNode evolution : node.getEvolutions()) {
            this.printEvolutions(evolution, 1 + i, indent + "  ");
        }
    }

    private void updateDexNumbers(IEvolutionNode node, MutableInt integer) {
        if (this.isBeginningNode(node)) {
            this.updateDexNumbersRecursive(node, integer);
        }
    }

    private void updateDexNumbersRecursive(IEvolutionNode node, MutableInt integer) {
        integer.add(1);
        node.setPokedexNumber(integer.getValue());
        for (IEvolutionNode evolution : node.getEvolutions()) {
            this.updateDexNumbersRecursive(evolution, integer);
        }
    }
}

