/*
 * Decompiled with CFR 0.152.
 */
package drai.dev.gravelsextendedbattles.resorting;

import com.cobblemon.mod.common.api.moves.MoveTemplate;
import com.cobblemon.mod.common.api.moves.Moves;
import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.api.pokemon.moves.Learnset;
import com.cobblemon.mod.common.pokemon.Species;
import drai.dev.gravelmon.pokemon.attributes.Move;
import drai.dev.gravelmon.pokemon.attributes.MoveLearnSetEntry;
import drai.dev.gravelsextendedbattles.GravelsExtendedBattles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.math.NumberUtils;

public class GravelmonMoveSubstitution {
    private static Map<String, String> moveUpdateMap = new HashMap<String, String>();
    private static Map<String, List<MoveLearnSetEntry>> movesToAdd = new HashMap<String, List<MoveLearnSetEntry>>();

    public static void registerMoveForSubstitution(String original, String replacement) {
        moveUpdateMap.put(original, replacement);
    }

    public static void registerMoveInsertion(String pokemon, MoveLearnSetEntry moveToInsert) {
        movesToAdd.computeIfAbsent(pokemon, k -> new ArrayList()).add(moveToInsert);
    }

    public static void substituteMoves() {
        GravelmonMoveSubstitution.registerGEBMovesForSubstitution();
        Collection pokemonSpecies = PokemonSpecies.INSTANCE.getSpecies();
        Set<String> keys = moveUpdateMap.keySet();
        for (Species pokemon : pokemonSpecies) {
            if (movesToAdd.containsKey(pokemon.getName())) {
                movesToAdd.get(pokemon.getName()).forEach(moveLearnSetEntry -> {
                    String condition = moveLearnSetEntry.getCondition();
                    MoveTemplate move = Moves.INSTANCE.getByName(moveLearnSetEntry.getMove().getName());
                    Learnset moves = pokemon.getMoves();
                    if (move == null) {
                        return;
                    }
                    if (condition.equalsIgnoreCase("tutor")) {
                        moves.getTutorMoves().add(move);
                    } else if (condition.equalsIgnoreCase("tm")) {
                        moves.getTmMoves().add(move);
                    } else if (condition.equalsIgnoreCase("egg")) {
                        moves.getEggMoves().add(move);
                    } else if (NumberUtils.isCreatable((String)condition)) {
                        moves.getLevelUpMoves().computeIfAbsent(Integer.parseInt(condition), i -> new ArrayList()).add(move);
                    }
                });
            }
            GravelmonMoveSubstitution.substituteMoves(keys, pokemon.getMoves().getTmMoves());
            GravelmonMoveSubstitution.substituteMoves(keys, pokemon.getMoves().getEggMoves());
            GravelmonMoveSubstitution.substituteMoves(keys, pokemon.getMoves().getTutorMoves());
            GravelmonMoveSubstitution.substituteMoves(keys, pokemon.getMoves().getFormChangeMoves());
            ArrayList moveList = new ArrayList(pokemon.getMoves().getEvolutionMoves());
            for (MoveTemplate move : moveList) {
                MoveTemplate newMove;
                if (!keys.contains(move.getName()) || (newMove = Moves.INSTANCE.getByName(moveUpdateMap.get(move.getName()))) == null) continue;
                pokemon.getMoves().getEvolutionMoves().remove(move);
                pokemon.getMoves().getEvolutionMoves().add(newMove);
            }
            Map levelUpMoves = pokemon.getMoves().getLevelUpMoves();
            for (Map.Entry levelMoves : levelUpMoves.entrySet()) {
                ArrayList movesOnLevel = new ArrayList((Collection)levelMoves.getValue());
                for (MoveTemplate move : movesOnLevel) {
                    MoveTemplate newMove;
                    if (!keys.contains(move.getName()) || (newMove = Moves.INSTANCE.getByName(moveUpdateMap.get(move.getName()))) == null) continue;
                    ((List)levelMoves.getValue()).remove(move);
                    ((List)levelMoves.getValue()).add(newMove);
                }
                levelUpMoves.put((Integer)levelMoves.getKey(), (List)levelMoves.getValue());
            }
        }
    }

    private static void substituteMoves(Set<String> keys, List<MoveTemplate> moves) {
        ArrayList<MoveTemplate> moveList = new ArrayList<MoveTemplate>(moves);
        for (MoveTemplate move : moveList) {
            MoveTemplate newMove;
            if (!keys.contains(move.getName()) || (newMove = Moves.INSTANCE.getByName(moveUpdateMap.get(move.getName()))) == null) continue;
            moves.remove(move);
            moves.add(Moves.INSTANCE.getByName(moveUpdateMap.get(move.getName())));
        }
    }

    private static void registerGEBMovesForSubstitution() {
        Move.getTypeOverwrittenMoves().stream().filter(move -> GravelsExtendedBattles.IMPLEMENTED_TYPES.contains(move.getTypeOverwrite()) && move.isImplemented()).forEach(move -> moveUpdateMap.put(move.getName(), move.getOverwittenMoveName()));
    }
}

