/*
 * Decompiled with CFR 0.152.
 */
package drai.dev.gravelsextendedbattles.resorting.nodes;

import com.cobblemon.mod.common.api.pokemon.evolution.Evolution;
import com.cobblemon.mod.common.pokemon.Species;
import drai.dev.gravelsextendedbattles.resorting.nodes.IEvolutionNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class SpeciesEvolutionNode
extends IEvolutionNode {
    private Species pokemon;
    private List<IEvolutionNode> evolutions;
    private List<IEvolutionNode> preEvolutions;

    public SpeciesEvolutionNode(Species pokemon) {
        this.pokemon = pokemon;
        this.evolutions = new ArrayList<IEvolutionNode>();
        this.preEvolutions = new ArrayList<IEvolutionNode>();
        this.sortingNumber = pokemon.getNationalPokedexNumber();
    }

    @Override
    public List<IEvolutionNode> getEvolutions() {
        return this.evolutions;
    }

    @Override
    public void addEvolution(IEvolutionNode formEvolutionNode) {
        this.evolutions.add(formEvolutionNode);
    }

    @Override
    public void addPreEvolution(IEvolutionNode formEvolutionNode) {
        this.preEvolutions.add(formEvolutionNode);
    }

    @Override
    public String getForm() {
        return null;
    }

    @Override
    public String getSpecies() {
        return this.pokemon.getName().toLowerCase();
    }

    @Override
    public List<IEvolutionNode> getPreEvolutions() {
        return this.preEvolutions;
    }

    @Override
    public Set<Evolution> getPokemonEvolutions() {
        return this.pokemon.getEvolutions();
    }

    @Override
    public int getPokedexNumber() {
        return this.pokemon.getNationalPokedexNumber();
    }

    @Override
    public void setPokedexNumber(int i) {
        this.pokemon.setNationalPokedexNumber(i);
    }

    @Override
    public Species getPokemon() {
        return this.pokemon;
    }
}

