/*
 * Decompiled with CFR 0.152.
 */
package drai.dev.gravelsextendedbattles.starters;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.config.starter.StarterCategory;
import com.cobblemon.mod.common.config.starter.StarterConfig;
import drai.dev.gravelsextendedbattles.GravelsExtendedBattles;
import drai.dev.gravelsextendedbattles.SpeciesManager;
import drai.dev.gravelsextendedbattles.starters.StarterCategoryDataHolder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class GravelmonStarterManager {
    public static Map<String, List<StarterCategoryDataHolder>> NEW_STARTERS = new HashMap<String, List<StarterCategoryDataHolder>>();

    public static void registerNewStarter(String afterCategory, StarterCategoryDataHolder newStarter) {
        NEW_STARTERS.computeIfAbsent(afterCategory == null ? "" : afterCategory, k -> new ArrayList()).add(newStarter);
    }

    public static void processStarters() {
        StarterConfig starterConfig = Cobblemon.INSTANCE.getStarterConfig();
        List currentStarters = starterConfig.getStarters();
        if (GravelsExtendedBattles.ADD_STARTERS) {
            NEW_STARTERS.keySet().stream().sorted().forEach(key -> {
                for (StarterCategoryDataHolder starterCategoryData : NEW_STARTERS.get(key).stream().sorted().toList()) {
                    StarterCategory newStarter = starterCategoryData.toStarterCategory();
                    if (currentStarters.contains(newStarter)) continue;
                    Optional<StarterCategory> afterCategory = currentStarters.stream().filter(starterCategory -> starterCategory.getName().equalsIgnoreCase((String)key)).findFirst();
                    if (afterCategory.isPresent()) {
                        int index = currentStarters.indexOf(afterCategory.get()) + 1;
                        currentStarters.add(index, newStarter);
                        continue;
                    }
                    currentStarters.add(newStarter);
                }
            });
        }
        currentStarters.forEach(starterCategory -> {
            ArrayList<PokemonProperties> starters = new ArrayList<PokemonProperties>(starterCategory.component3().stream().filter(pokemon -> !SpeciesManager.containsBannedLabels(pokemon.getSpecies(), pokemon.getForm())).toList());
            starterCategory.component3().clear();
            starterCategory.component3().addAll(starters);
        });
        List<StarterCategory> finalCategories = currentStarters.stream().filter(starter -> !starter.component3().isEmpty()).toList();
        starterConfig.setStarters(finalCategories);
    }
}

