/*
 * Decompiled with CFR 0.152.
 */
package dev.reyaan.wherearemytms.fabric.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.reyaan.wherearemytms.fabric.config.WAMTConfigObject;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u0010\u0010\u0011J\r\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\r\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\r\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\u0007R\u0014\u0010\n\u001a\u00020\t8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010\u000bR\u001c\u0010\u000e\u001a\n \r*\u0004\u0018\u00010\f0\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0012"}, d2={"Ldev/reyaan/wherearemytms/fabric/config/WAMTConfigHandler;", "", "", "deserialize", "()V", "Ldev/reyaan/wherearemytms/fabric/config/WAMTConfigObject;", "init", "()Ldev/reyaan/wherearemytms/fabric/config/WAMTConfigObject;", "serialize", "Ljava/io/File;", "file", "Ljava/io/File;", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "gson", "Lcom/google/gson/Gson;", "<init>", "(Ljava/io/File;)V", "wherearemytms"})
public final class WAMTConfigHandler {
    @NotNull
    private final File file;
    private final Gson gson;

    public WAMTConfigHandler(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.file = file;
        this.gson = new GsonBuilder().setPrettyPrinting().create();
    }

    @NotNull
    public final WAMTConfigObject init() {
        if (!this.file.exists()) {
            this.deserialize();
            return new WAMTConfigObject(false, false, 3, null);
        }
        return this.serialize();
    }

    @NotNull
    public final WAMTConfigObject serialize() {
        WAMTConfigObject wAMTConfigObject;
        try {
            Object object = this.gson.fromJson(Files.readString(this.file.toPath()), WAMTConfigObject.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"{\n            gson.fromJ\u2026a\n            )\n        }");
            wAMTConfigObject = (WAMTConfigObject)object;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return wAMTConfigObject;
    }

    public final void deserialize() {
        try {
            Files.writeString(this.file.toPath(), (CharSequence)this.gson.toJson((Object)new WAMTConfigObject(false, false, 3, null)), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

