/*
 * Decompiled with CFR 0.152.
 */
package org.pokesplash.hunt.broadcast;

import com.cobblemon.mod.common.pokemon.Pokemon;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.pokesplash.hunt.Hunt;
import org.pokesplash.hunt.broadcast.BroadcastType;
import org.pokesplash.hunt.broadcast.PlayerBroadcast;
import org.pokesplash.hunt.util.Utils;

public class Broadcaster {
    private HashMap<BroadcastType, Long> buffers;
    private HashMap<UUID, PlayerBroadcast> playerBuffers;
    private HashMap<BroadcastType, String> broadcastMessages;

    public void init() {
        this.buffers = new HashMap();
        this.playerBuffers = new HashMap();
        this.broadcastMessages = new HashMap();
        this.broadcastMessages.put(BroadcastType.STARTED, Hunt.language.getNewHuntMessage());
        this.broadcastMessages.put(BroadcastType.ENDED, Hunt.language.getEndedHuntMessage());
        this.broadcastMessages.put(BroadcastType.CAPTURED, Hunt.language.getCaptureHuntBroadcast());
    }

    private void broadcastMessage(BroadcastType type, class_3222 player, Pokemon pokemon, double price) {
        String message = Utils.formatPlaceholders(this.broadcastMessages.get((Object)type), player, pokemon, price);
        MinecraftServer server = Hunt.server;
        ArrayList players = new ArrayList(server.method_3760().method_14571());
        for (class_3222 pl : players) {
            pl.method_43496((class_2561)class_2561.method_43470((String)message));
        }
    }

    private void sendMessage(UUID owner, BroadcastType type, class_3222 player, Pokemon pokemon, double price) {
        String message = Utils.formatPlaceholders(this.broadcastMessages.get((Object)type), player, pokemon, price);
        Hunt.server.method_3760().method_14602(owner).method_43496((class_2561)class_2561.method_43470((String)message));
    }

    public void sendPlayerMessage(UUID owner, BroadcastType type, class_3222 player, Pokemon pokemon, double price) {
        if (!Hunt.config.isTimerCooldowns()) {
            this.sendMessage(owner, type, player, pokemon, price);
            return;
        }
        PlayerBroadcast playerBroadcast = this.playerBuffers.get(owner);
        if (playerBroadcast == null) {
            playerBroadcast = new PlayerBroadcast();
        }
        if (playerBroadcast.buffers.get((Object)type) == null || new Date().getTime() - playerBroadcast.buffers.get((Object)type) > 1000L * (long)Hunt.config.getBufferDuration()) {
            this.sendMessage(owner, type, player, pokemon, price);
            playerBroadcast.buffers.put(type, new Date().getTime());
            this.playerBuffers.put(owner, playerBroadcast);
        }
    }

    public void sendBroadcast(BroadcastType type, class_3222 player, Pokemon pokemon, double price) {
        if (!Hunt.config.isTimerCooldowns()) {
            this.broadcastMessage(type, player, pokemon, price);
            return;
        }
        if (this.buffers.get((Object)type) == null || new Date().getTime() - this.buffers.get((Object)type) > 1000L * (long)Hunt.config.getBufferDuration()) {
            this.broadcastMessage(type, player, pokemon, price);
            this.buffers.put(type, new Date().getTime());
        }
    }
}

