/*
 * Decompiled with CFR 0.152.
 */
package org.pokesplash.hunt.command.basecommand;

import ca.landonjw.gooeylibs2.api.UIManager;
import ca.landonjw.gooeylibs2.api.button.Button;
import ca.landonjw.gooeylibs2.api.button.FlagType;
import ca.landonjw.gooeylibs2.api.button.GooeyButton;
import ca.landonjw.gooeylibs2.api.button.PlaceholderButton;
import ca.landonjw.gooeylibs2.api.helpers.PaginationHelper;
import ca.landonjw.gooeylibs2.api.page.LinkedPage;
import ca.landonjw.gooeylibs2.api.page.Page;
import ca.landonjw.gooeylibs2.api.template.Template;
import ca.landonjw.gooeylibs2.api.template.types.ChestTemplate;
import com.cobblemon.mod.common.item.PokemonItem;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import org.pokesplash.hunt.Hunt;
import org.pokesplash.hunt.command.subcommand.RefreshCommand;
import org.pokesplash.hunt.command.subcommand.ReloadCommand;
import org.pokesplash.hunt.hunts.SingleHunt;
import org.pokesplash.hunt.util.BaseCommand;
import org.pokesplash.hunt.util.Utils;

public class HuntCommand
extends BaseCommand {
    public HuntCommand() {
        super("hunt", Arrays.asList("hunts"), Hunt.permissions.getPermission("HuntBase"), Arrays.asList(new ReloadCommand(), new RefreshCommand()));
    }

    @Override
    public int run(CommandContext<class_2168> context) {
        if (!((class_2168)context.getSource()).method_43737()) {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"A player must run this command!"));
            return 1;
        }
        class_3222 sender = ((class_2168)context.getSource()).method_44023();
        ArrayList<GooeyButton> hunts = new ArrayList<GooeyButton>();
        for (SingleHunt hunt : Hunt.config.isIndividualHunts() ? Hunt.manager.getPlayerHunts(sender.method_5667()).getHunts().values() : Hunt.hunts.getHunts().values()) {
            ArrayList<class_5250> lore = new ArrayList<class_5250>();
            class_2583 aqua = class_2583.field_24360.method_27703(class_5251.method_27719((String)"aqua"));
            class_2583 blue = class_2583.field_24360.method_27703(class_5251.method_27719((String)"blue"));
            class_2583 dark_green = class_2583.field_24360.method_27703(class_5251.method_27719((String)"dark_green"));
            class_2583 dark_purple = class_2583.field_24360.method_27703(class_5251.method_27719((String)"dark_purple"));
            class_2583 green = class_2583.field_24360.method_27703(class_5251.method_27719((String)"green"));
            class_2583 red = class_2583.field_24360.method_27703(class_5251.method_27719((String)"red"));
            class_2583 yellow = class_2583.field_24360.method_27703(class_5251.method_27719((String)"yellow"));
            boolean isShiny = hunt.getPokemon().getShiny();
            class_5250 title = hunt.getPokemon().getSpecies().getTranslatedName().method_10862(isShiny ? yellow : aqua);
            if (isShiny) {
                title.method_10852((class_2561)class_2561.method_43470((String)"\u2605").method_10862(red));
            }
            if (Hunt.config.getMatchProperties().isGender()) {
                switch (hunt.getPokemon().getGender().toString()) {
                    case "MALE": {
                        title.method_10852((class_2561)class_2561.method_43470((String)" \u2642").method_10862(blue));
                        break;
                    }
                    case "FEMALE": {
                        title.method_10852((class_2561)class_2561.method_43470((String)" \u2640").method_10862(red));
                        break;
                    }
                }
            }
            if (!hunt.getPokemon().getForm().getName().equalsIgnoreCase("normal")) {
                title.method_10852((class_2561)class_2561.method_43470((String)(" - " + hunt.getPokemon().getForm().getName())).method_10862(aqua));
            }
            if (Hunt.config.getMatchProperties().isAbility()) {
                lore.add(class_2561.method_43471((String)"cobblemon.ui.info.ability").method_10862(dark_green).method_10852((class_2561)class_2561.method_43470((String)": ")).method_10852((class_2561)class_2561.method_43471((String)hunt.getPokemon().getAbility().getDisplayName()).method_10862(green)));
            }
            if (Hunt.config.getMatchProperties().isNature()) {
                lore.add(class_2561.method_43471((String)"cobblemon.ui.info.nature").method_10862(dark_purple).method_10852((class_2561)class_2561.method_43470((String)": ")).method_10852((class_2561)class_2561.method_43471((String)hunt.getPokemon().getNature().getDisplayName()).method_10862(class_2583.field_24360.method_27703(class_5251.method_27719((String)"light_purple")))));
            }
            if (hunt.getPrice() > 0.0) {
                lore.add(class_2561.method_43470((String)(Hunt.language.getReward() + hunt.getPriceAsString())));
            }
            lore.add(class_2561.method_43470((String)(Hunt.language.getTimeRemaining() + Utils.parseLongDate(hunt.getEndtime() - new Date().getTime()))));
            GooeyButton button = GooeyButton.builder().display(PokemonItem.from((Pokemon)hunt.getPokemon(), (int)1)).title((class_2561)title).lore(class_2561.class, lore).build();
            hunts.add(button);
        }
        GooeyButton filler = GooeyButton.builder().display(Utils.parseItemId(Hunt.language.getFillerMaterial())).hideFlags(new FlagType[]{FlagType.All}).lore(new ArrayList()).title("").build();
        PlaceholderButton placeholder = new PlaceholderButton();
        int rows = (int)Math.ceil((double)Hunt.config.getHuntAmount() / 7.0) + 2;
        ChestTemplate template = ChestTemplate.builder((int)rows).rectangle(1, 1, rows - 2, 7, (Button)placeholder).fill((Button)filler).build();
        LinkedPage page = PaginationHelper.createPagesFromPlaceholders((Template)template, hunts, null);
        page.setTitle(Hunt.language.getTitle());
        UIManager.openUIForcefully((class_3222)sender, (Page)page);
        return 1;
    }
}

