/*
 * Decompiled with CFR 0.152.
 */
package org.pokesplash.hunt.command.subcommand;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.Collection;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.pokesplash.hunt.Hunt;
import org.pokesplash.hunt.hunts.SingleHunt;
import org.pokesplash.hunt.util.Subcommand;

public class DebugCommand
extends Subcommand {
    public DebugCommand() {
        super("\u00a79Usage:\\n\u00a73- hunt debug");
    }

    @Override
    public LiteralCommandNode<class_2168> build() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"debug").requires(ctx -> {
            if (ctx.method_43737()) {
                return Hunt.permissions.hasPermission(ctx.method_44023(), Hunt.permissions.getPermission("HuntDebug"));
            }
            return true;
        })).executes(this::showUsage)).then(class_2170.method_9244((String)"slot", (ArgumentType)IntegerArgumentType.integer()).suggests((ctx, builder) -> {
            for (int i = 1; i < 7; ++i) {
                builder.suggest(i);
            }
            return builder.buildFuture();
        }).executes(this::run))).build();
    }

    @Override
    public int run(CommandContext<class_2168> context) {
        if (!((class_2168)context.getSource()).method_43737()) {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"This command must be ran by a player."));
            return 1;
        }
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        int slot = IntegerArgumentType.getInteger(context, (String)"slot") - 1;
        PlayerPartyStore party = Cobblemon.INSTANCE.getStorage().getParty(player);
        Pokemon pokemon = party.get(slot);
        if (pokemon == null) {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("\u00a7cNo Pokemon in slot " + slot)));
            return 1;
        }
        String output = "Pokemon: " + pokemon.getSpecies().getName() + "\nForm: " + pokemon.getForm().getName() + "\nAbility: " + pokemon.getAbility().getName() + "\nGender: " + pokemon.getGender().name() + "\nNature: " + pokemon.getNature().getName().method_12832() + "\n\n" + this.checkListings(pokemon);
        ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)output));
        return 1;
    }

    private String checkListings(Pokemon playerMon) {
        Object total = "";
        Collection<SingleHunt> hunts = Hunt.hunts.getHunts().values();
        for (SingleHunt hunt : hunts) {
            Pokemon huntMon = hunt.getPokemon();
            String output = "Listing: " + huntMon.getSpecies().getName() + "\n";
            output = output + "Species: " + huntMon.getSpecies().getName().equalsIgnoreCase(playerMon.getSpecies().getName()) + "\n";
            output = output + "Form: " + huntMon.getForm().getName().equalsIgnoreCase(playerMon.getForm().getName()) + "\n";
            output = output + "Ability: " + huntMon.getAbility().getName().equalsIgnoreCase(playerMon.getAbility().getName()) + "\n";
            output = output + "Gender: " + huntMon.getGender().name().equalsIgnoreCase(playerMon.getGender().name()) + "\n";
            output = output + "Nature: " + huntMon.getNature().getName().method_12832().equalsIgnoreCase(playerMon.getNature().getName().method_12832()) + "\n";
            output = output + "Shiny: " + (huntMon.getShiny() == playerMon.getShiny()) + "\n";
            output = output + "Matches: " + hunt.matches(playerMon) + "\n\n";
            total = (String)total + output;
        }
        return total;
    }
}

