/*
 * Decompiled with CFR 0.152.
 */
package org.pokesplash.hunt.command.subcommand;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.HashSet;
import java.util.UUID;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.pokesplash.hunt.Hunt;
import org.pokesplash.hunt.hunts.CurrentHunts;
import org.pokesplash.hunt.util.Subcommand;
import org.pokesplash.hunt.util.Utils;

public class RefreshCommand
extends Subcommand {
    public RefreshCommand() {
        super("\u00a79Usage:\\n\u00a73- hunt refresh <player>");
    }

    @Override
    public LiteralCommandNode<class_2168> build() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"refresh").requires(ctx -> {
            if (ctx.method_43737()) {
                return Hunt.permissions.hasPermission(ctx.method_44023(), Hunt.permissions.getPermission("HuntRefresh"));
            }
            return true;
        })).executes(this::showUsage)).then(class_2170.method_9244((String)"player", (ArgumentType)StringArgumentType.string()).suggests((ctx, builder) -> {
            for (String player : ((class_2168)ctx.getSource()).method_9211().method_3858()) {
                builder.suggest(player);
            }
            return builder.buildFuture();
        }).executes(this::run))).build();
    }

    @Override
    public int run(CommandContext<class_2168> context) {
        try {
            if (!Hunt.config.isIndividualHunts()) {
                ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)Utils.formatMessage("\u00a7cIndividual Hunts are not active.", ((class_2168)context.getSource()).method_43737())));
                return 1;
            }
            String playerName = StringArgumentType.getString(context, (String)"player");
            if (playerName == null) {
                ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)Utils.formatMessage("\u00a7cNo player was given.", ((class_2168)context.getSource()).method_43737())));
                return 1;
            }
            class_3222 player = Hunt.server.method_3760().method_14566(playerName);
            if (player == null) {
                ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)Utils.formatMessage("\u00a7cPlayer " + playerName + " could not be found.", ((class_2168)context.getSource()).method_43737())));
                return 1;
            }
            CurrentHunts playerHunts = Hunt.manager.getPlayerHunts(player.method_5667());
            Hunt.manager.addPlayer(player.method_5667());
            HashSet<UUID> huntIds = new HashSet<UUID>(playerHunts.getHunts().keySet());
            for (UUID hunt : huntIds) {
                playerHunts.removeHunt(hunt, false);
            }
            playerHunts.init();
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)Utils.formatMessage("\u00a72Successfully refreshed " + player.method_5477().getString() + " hunts.", ((class_2168)context.getSource()).method_43737())));
        }
        catch (Exception e) {
            e.printStackTrace();
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)Utils.formatMessage("\u00a7cSomething went wrong.", ((class_2168)context.getSource()).method_43737())));
        }
        return 1;
    }
}

