/*
 * Decompiled with CFR 0.152.
 */
package org.pokesplash.hunt.config;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import org.pokesplash.hunt.Hunt;
import org.pokesplash.hunt.config.CustomPrice;
import org.pokesplash.hunt.config.Properties;
import org.pokesplash.hunt.config.RarityConfig;
import org.pokesplash.hunt.config.RewardsConfig;
import org.pokesplash.hunt.util.Utils;

public class Config {
    private String version = "1.1.0";
    private boolean individualHunts = false;
    private boolean sendHuntEndMessage = true;
    private boolean sendHuntBeginMessage = true;
    private boolean timerCooldowns = true;
    private int bufferDuration = 5;
    private int huntDuration = 60;
    private int huntAmount = 7;
    private RarityConfig rarity = new RarityConfig();
    private RewardsConfig rewards = new RewardsConfig();
    private Properties matchProperties = new Properties();
    private ArrayList<CustomPrice> customPrices = new ArrayList();
    private ArrayList<String> blacklist;

    public Config() {
        this.customPrices.add(new CustomPrice());
        this.blacklist = new ArrayList();
    }

    public void init() {
        CompletableFuture<Boolean> futureRead = Utils.readFileAsync("/config/hunt/", "config.json", el -> {
            Gson gson = Utils.newGson();
            Config cfg = (Config)gson.fromJson(el, Config.class);
            if (!cfg.getVersion().equals("1.1.0")) {
                // empty if block
            }
            if (cfg.getHuntAmount() > 28) {
                this.huntAmount = 28;
                Hunt.LOGGER.error("Hunt amount can not be higher than 28");
            } else {
                this.huntAmount = cfg.getHuntAmount();
            }
            this.huntDuration = cfg.getHuntDuration();
            this.individualHunts = cfg.isIndividualHunts();
            this.sendHuntEndMessage = cfg.isSendHuntEndMessage();
            this.sendHuntBeginMessage = cfg.isSendHuntBeginMessage();
            this.timerCooldowns = cfg.isTimerCooldowns();
            this.bufferDuration = cfg.getBufferDuration();
            this.matchProperties = cfg.getMatchProperties();
            this.customPrices = cfg.getCustomPrices();
            this.blacklist = cfg.getBlacklist();
            this.rarity = cfg.getRarity();
            this.rewards = cfg.getRewards();
        });
        if (!futureRead.join().booleanValue()) {
            Hunt.LOGGER.info("No config.json file found for Hunt. Attempting to generate one.");
            Gson gson = Utils.newGson();
            String data = gson.toJson((Object)this);
            CompletableFuture<Boolean> futureWrite = Utils.writeFileAsync("/config/hunt/", "config.json", data);
            if (!futureWrite.join().booleanValue()) {
                Hunt.LOGGER.fatal("Could not write config for Hunt.");
            }
            return;
        }
        Hunt.LOGGER.info("Hunt config file read successfully.");
    }

    public String getVersion() {
        return this.version;
    }

    public int getBufferDuration() {
        return this.bufferDuration;
    }

    public boolean isTimerCooldowns() {
        return this.timerCooldowns;
    }

    public boolean isIndividualHunts() {
        return this.individualHunts;
    }

    public int getHuntDuration() {
        return this.huntDuration;
    }

    public int getHuntAmount() {
        return this.huntAmount;
    }

    public Properties getMatchProperties() {
        return this.matchProperties;
    }

    public ArrayList<CustomPrice> getCustomPrices() {
        return this.customPrices;
    }

    public boolean isSendHuntEndMessage() {
        return this.sendHuntEndMessage;
    }

    public boolean isSendHuntBeginMessage() {
        return this.sendHuntBeginMessage;
    }

    public ArrayList<String> getBlacklist() {
        return this.blacklist;
    }

    public RarityConfig getRarity() {
        return this.rarity;
    }

    public RewardsConfig getRewards() {
        return this.rewards;
    }

    public boolean blacklistContains(String pokemon) {
        for (String name : this.blacklist) {
            if (!name.equalsIgnoreCase(pokemon)) continue;
            return true;
        }
        return false;
    }
}

