/*
 * Decompiled with CFR 0.152.
 */
package org.pokesplash.hunt.config;

import com.google.gson.Gson;
import java.util.concurrent.CompletableFuture;
import org.pokesplash.hunt.Hunt;
import org.pokesplash.hunt.util.Utils;

public class Lang {
    private String title = "Hunt";
    private String fillerMaterial = "minecraft:white_stained_glass_pane";
    private String reloadMessage = "\u00a7aReloaded Configs!";
    private String captureHuntBroadcast = "\u00a75[Hunt] \u00a7e{player} \u00a7ahas successfully hunted \u00a7e{pokemon}";
    private String payMessage = "\u00a75[Hunt] \u00a7eYou were paid {price} from hunt!";
    private String endedHuntMessage = "\u00a75[Hunt] \u00a73The hunt for {pokemon} has ended!";
    private String newHuntMessage = "\u00a75[Hunt] \u00a7bThe hunt for {pokemon} has begun!";
    private String reward = "\u00a76Reward: \u00a7e";
    private String timeRemaining = "\u00a79Time Remaining: \u00a7b";

    public String getTitle() {
        return this.title;
    }

    public String getFillerMaterial() {
        return this.fillerMaterial;
    }

    public String getReloadMessage() {
        return this.reloadMessage;
    }

    public String getCaptureHuntBroadcast() {
        return this.captureHuntBroadcast;
    }

    public String getPayMessage() {
        return this.payMessage;
    }

    public String getEndedHuntMessage() {
        return this.endedHuntMessage;
    }

    public String getNewHuntMessage() {
        return this.newHuntMessage;
    }

    public String getReward() {
        return this.reward;
    }

    public String getTimeRemaining() {
        return this.timeRemaining;
    }

    public void init() {
        CompletableFuture<Boolean> futureRead = Utils.readFileAsync("/config/hunt/", "lang.json", el -> {
            Gson gson = Utils.newGson();
            Lang lang = (Lang)gson.fromJson(el, Lang.class);
            this.title = lang.getTitle();
            this.fillerMaterial = lang.getFillerMaterial();
            this.reloadMessage = lang.getReloadMessage();
            this.captureHuntBroadcast = lang.getCaptureHuntBroadcast();
            this.payMessage = lang.getPayMessage();
            this.endedHuntMessage = lang.getEndedHuntMessage();
            this.newHuntMessage = lang.getNewHuntMessage();
            this.reward = lang.getReward();
            this.timeRemaining = lang.getTimeRemaining();
        });
        if (!futureRead.join().booleanValue()) {
            Hunt.LOGGER.info("No lang.json file found for Hunt. Attempting to generate one.");
            Gson gson = Utils.newGson();
            String data = gson.toJson((Object)this);
            CompletableFuture<Boolean> futureWrite = Utils.writeFileAsync("/config/hunt/", "lang.json", data);
            if (!futureWrite.join().booleanValue()) {
                Hunt.LOGGER.fatal("Could not write lang.json file for Hunt.");
            }
            Hunt.LOGGER.info("Hunt lang file read successfully.");
        }
    }
}

