/*
 * Decompiled with CFR 0.152.
 */
package org.pokesplash.hunt.config;

import com.google.gson.Gson;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.pokesplash.hunt.Hunt;
import org.pokesplash.hunt.util.Utils;

public class Logs {
    private HashMap<UUID, Double> data = new HashMap();

    public void init() {
        CompletableFuture<Boolean> futureRead = Utils.readFileAsync("/config/hunt/", "logs.json", el -> {
            Gson gson = Utils.newGson();
            Logs cfg = (Logs)gson.fromJson(el, Logs.class);
            this.data = cfg.getData();
        });
        if (!futureRead.join().booleanValue()) {
            Hunt.LOGGER.info("No logs.json file found for Hunt. Attempting to generate one.");
            Gson gson = Utils.newGson();
            String data = gson.toJson((Object)this);
            CompletableFuture<Boolean> futureWrite = Utils.writeFileAsync("/config/hunt/", "logs.json", data);
            if (!futureWrite.join().booleanValue()) {
                Hunt.LOGGER.fatal("Could not write logs for Hunt.");
            }
            return;
        }
        Hunt.LOGGER.info("Hunt logs file read successfully.");
    }

    public HashMap<UUID, Double> getData() {
        return this.data;
    }

    public void addValue(UUID player, double value) {
        if (!this.data.containsKey(player)) {
            this.data.put(player, 0.0);
        }
        double current = this.data.get(player);
        this.data.put(player, current + value);
        Gson gson = Utils.newGson();
        String data = gson.toJson((Object)this);
        CompletableFuture<Boolean> futureWrite = Utils.writeFileAsync("/config/hunt/", "logs.json", data);
        if (!futureWrite.join().booleanValue()) {
            Hunt.LOGGER.fatal("Could not write logs for Hunt.");
        }
    }
}

