/*
 * Decompiled with CFR 0.152.
 */
package org.pokesplash.hunt.event;

import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.pokemon.Pokemon;
import java.util.UUID;
import kotlin.Unit;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.pokesplash.hunt.Hunt;
import org.pokesplash.hunt.api.event.HuntEvents;
import org.pokesplash.hunt.api.event.events.CompletedEvent;
import org.pokesplash.hunt.broadcast.BroadcastType;
import org.pokesplash.hunt.hunts.ReplacedHunt;
import org.pokesplash.hunt.hunts.SingleHunt;
import org.pokesplash.hunt.util.ImpactorService;
import org.pokesplash.hunt.util.Utils;

public abstract class CaptureEvent {
    public static void registerEvents() {
        CobblemonEvents.POKEMON_CAPTURED.subscribe(Priority.NORMAL, e -> {
            class_3222 player = e.getPlayer();
            Pokemon pokemon = e.getPokemon();
            UUID matchedUUID = Hunt.config.isIndividualHunts() ? Hunt.manager.getPlayerHunts(player.method_5667()).matches(pokemon) : Hunt.hunts.matches(pokemon);
            if (matchedUUID != null) {
                SingleHunt hunt = Hunt.config.isIndividualHunts() ? Hunt.manager.getPlayerHunts(player.method_5667()).getHunt(matchedUUID) : Hunt.hunts.getHunt(matchedUUID);
                double price = hunt.getPrice();
                ReplacedHunt replacedHunt = Hunt.config.isIndividualHunts() ? Hunt.manager.getPlayerHunts(player.method_5667()).replaceHunt(matchedUUID, false) : Hunt.hunts.replaceHunt(matchedUUID, false);
                if (!Hunt.config.isIndividualHunts()) {
                    Hunt.broadcaster.sendBroadcast(BroadcastType.CAPTURED, player, pokemon, price);
                }
                if (replacedHunt != null) {
                    HuntEvents.COMPLETED.trigger(new CompletedEvent(replacedHunt.getOldHunt(), player.method_5667()));
                }
                Hunt.logs.addValue(player.method_5667(), price);
                if (price > 0.0) {
                    try {
                        boolean success = ImpactorService.add(ImpactorService.getAccount(player.method_5667()), price);
                        if (success) {
                            player.method_43496((class_2561)class_2561.method_43470((String)Utils.formatPlaceholders(Hunt.language.getPayMessage(), player, pokemon, price)));
                        }
                    }
                    catch (NullPointerException ex) {
                        Hunt.LOGGER.error("Could not process hunt " + matchedUUID + " for " + player.method_5477().getString());
                        ex.printStackTrace();
                    }
                }
                Utils.runCommands(hunt.getCommands(), player, pokemon, price);
                return Unit.INSTANCE;
            }
            return Unit.INSTANCE;
        });
    }
}

