/*
 * Decompiled with CFR 0.152.
 */
package org.pokesplash.hunt.hunts;

import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.Species;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_3222;
import org.pokesplash.hunt.Hunt;
import org.pokesplash.hunt.broadcast.BroadcastType;
import org.pokesplash.hunt.hunts.ReplacedHunt;
import org.pokesplash.hunt.hunts.SingleHunt;

public class CurrentHunts {
    private final UUID owner;
    private HashMap<UUID, SingleHunt> hunts;
    private HashMap<UUID, Species> species;

    public CurrentHunts(UUID owner) {
        this.owner = owner;
        this.hunts = new HashMap();
        this.species = new HashMap();
    }

    public void init() {
        if (this.owner == null && Hunt.config.isIndividualHunts()) {
            return;
        }
        for (int x = 0; x < Hunt.config.getHuntAmount(); ++x) {
            try {
                TimeUnit.MILLISECONDS.sleep(50L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.addHunt();
        }
    }

    public SingleHunt getHunt(UUID uuid) {
        return this.hunts.get(uuid);
    }

    public SingleHunt addHunt() {
        if (this.hunts.size() < Hunt.config.getHuntAmount()) {
            SingleHunt hunt = new SingleHunt(this.owner);
            if (this.species.containsValue(hunt.getPokemon().getSpecies()) || Hunt.config.blacklistContains(hunt.getPokemon().getSpecies().getName())) {
                return this.addHunt();
            }
            if (Hunt.config.isIndividualHunts()) {
                class_3222 player;
                class_3222 class_32222 = player = this.owner == null ? null : Hunt.server.method_3760().method_14602(this.owner);
                if (this.owner != null && player != null && Hunt.permissions.hasPermission(player, Hunt.permissions.getPermission("HuntNotify"))) {
                    Hunt.broadcaster.sendPlayerMessage(this.owner, BroadcastType.STARTED, null, hunt.getPokemon(), hunt.getPrice());
                }
            } else if (Hunt.config.isSendHuntBeginMessage()) {
                Hunt.broadcaster.sendBroadcast(BroadcastType.STARTED, null, hunt.getPokemon(), hunt.getPrice());
            }
            this.species.put(hunt.getId(), hunt.getPokemon().getSpecies());
            return this.hunts.put(hunt.getId(), hunt);
        }
        return null;
    }

    public SingleHunt removeHunt(UUID id, boolean broadcast) {
        SingleHunt removedHunt = this.hunts.remove(id);
        if (removedHunt != null) {
            this.species.remove(id);
            removedHunt.getTimer().cancel();
            if (Hunt.config.isIndividualHunts()) {
                if (this.owner != null && Hunt.server.method_3760().method_14602(this.owner) != null && Hunt.permissions.hasPermission(Hunt.server.method_3760().method_14602(this.owner), Hunt.permissions.getPermission("HuntNotify"))) {
                    Hunt.broadcaster.sendPlayerMessage(this.owner, BroadcastType.ENDED, null, removedHunt.getPokemon(), removedHunt.getPrice());
                }
            } else if (Hunt.config.isSendHuntEndMessage() && broadcast) {
                Hunt.broadcaster.sendBroadcast(BroadcastType.ENDED, null, removedHunt.getPokemon(), removedHunt.getPrice());
            }
        }
        return removedHunt;
    }

    public ReplacedHunt replaceHunt(UUID id, boolean broadcast) {
        SingleHunt oldHunt = this.removeHunt(id, broadcast);
        if (oldHunt != null) {
            return new ReplacedHunt(oldHunt, this.addHunt());
        }
        return null;
    }

    public UUID matches(Pokemon pokemon) {
        for (UUID id : this.hunts.keySet()) {
            if (!this.hunts.get(id).matches(pokemon)) continue;
            return id;
        }
        return null;
    }

    public double getPrice(UUID uuid) {
        SingleHunt hunt = this.hunts.get(uuid);
        if (hunt != null) {
            return hunt.getPrice();
        }
        return -1.0;
    }

    public HashMap<UUID, SingleHunt> getHunts() {
        return this.hunts;
    }
}

