/*
 * Decompiled with CFR 0.152.
 */
package org.pokesplash.hunt.hunts;

import com.cobblemon.mod.common.pokemon.Pokemon;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import org.pokesplash.hunt.Hunt;
import org.pokesplash.hunt.config.CustomPrice;

public class SingleHunt {
    private final UUID id = UUID.randomUUID();
    private final UUID owner;
    private double price;
    private ArrayList<String> commands;
    private Pokemon pokemon;
    private final Timer timer;
    private final long endtime;

    public SingleHunt(final UUID owner) {
        this.owner = owner;
        this.pokemon = new Pokemon();
        float rarity = Hunt.spawnRates.getRarity(this.pokemon);
        boolean isLegendary = this.pokemon.isLegendary();
        while (rarity == -1.0f || isLegendary) {
            this.pokemon = new Pokemon();
            rarity = Hunt.spawnRates.getRarity(this.pokemon);
            isLegendary = this.pokemon.isLegendary();
        }
        boolean hasCustom = false;
        ArrayList<CustomPrice> customPrices = Hunt.config.getCustomPrices();
        for (CustomPrice item : customPrices) {
            if (!item.getSpecies().trim().equalsIgnoreCase(this.pokemon.getSpecies().getName().trim()) || !item.getForm().trim().equalsIgnoreCase("") && !item.getForm().trim().equalsIgnoreCase(this.pokemon.getForm().getName().trim())) continue;
            hasCustom = true;
            this.price = item.getPrice();
            break;
        }
        if (!hasCustom) {
            if (rarity >= Hunt.config.getRarity().getCommonPokemonRarity()) {
                this.price = Hunt.config.getRewards().getCommon().getPrice();
                this.commands = Hunt.config.getRewards().getCommon().getCommands();
            } else if (rarity >= Hunt.config.getRarity().getUncommonPokemonRarity()) {
                this.price = Hunt.config.getRewards().getUncommon().getPrice();
                this.commands = Hunt.config.getRewards().getUncommon().getCommands();
            } else if (rarity >= Hunt.config.getRarity().getRarePokemonRarity()) {
                this.price = Hunt.config.getRewards().getRare().getPrice();
                this.commands = Hunt.config.getRewards().getRare().getCommands();
            } else {
                this.price = Hunt.config.getRewards().getUltraRare().getPrice();
                this.commands = Hunt.config.getRewards().getUltraRare().getCommands();
            }
        }
        this.pokemon.rollAbility();
        this.pokemon.checkGender();
        int duration = Hunt.config.getHuntDuration() * 60 * 1000;
        this.timer = new Timer();
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (Hunt.config.isIndividualHunts()) {
                    Hunt.manager.getPlayerHunts(owner).replaceHunt(SingleHunt.this.id, true);
                } else {
                    Hunt.hunts.replaceHunt(SingleHunt.this.id, true);
                }
            }
        }, duration);
        this.endtime = new Date().getTime() + (long)duration;
    }

    public UUID getId() {
        return this.id;
    }

    public double getPrice() {
        return this.price;
    }

    public String getPriceAsString() {
        DecimalFormat df = new DecimalFormat("0.##");
        return df.format(this.price);
    }

    public Pokemon getPokemon() {
        return this.pokemon;
    }

    public Timer getTimer() {
        return this.timer;
    }

    public long getEndtime() {
        return this.endtime;
    }

    public ArrayList<String> getCommands() {
        return this.commands;
    }

    public boolean matches(Pokemon pokemon) {
        if (!pokemon.getSpecies().getName().equalsIgnoreCase(this.pokemon.getSpecies().getName())) {
            return false;
        }
        if (!pokemon.getForm().getName().equalsIgnoreCase(this.getPokemon().getForm().getName())) {
            return false;
        }
        if (Hunt.config.getMatchProperties().isAbility() && !pokemon.getAbility().getName().equalsIgnoreCase(this.pokemon.getAbility().getName())) {
            return false;
        }
        if (Hunt.config.getMatchProperties().isGender() && !pokemon.getGender().name().equalsIgnoreCase(this.pokemon.getGender().name())) {
            return false;
        }
        if (Hunt.config.getMatchProperties().isNature() && !pokemon.getNature().getName().method_12832().equalsIgnoreCase(this.pokemon.getNature().getName().method_12832())) {
            return false;
        }
        if (Hunt.config.getMatchProperties().isShiny()) {
            return pokemon.getShiny() == this.pokemon.getShiny();
        }
        return true;
    }
}

