/*
 * Decompiled with CFR 0.152.
 */
package org.pokesplash.hunt.hunts;

import com.cobblemon.mod.common.api.spawning.BestSpawner;
import com.cobblemon.mod.common.api.spawning.CobblemonSpawnPools;
import com.cobblemon.mod.common.api.spawning.SpawnBucket;
import com.cobblemon.mod.common.api.spawning.detail.SpawnDetail;
import com.cobblemon.mod.common.api.spawning.multiplier.WeightMultiplier;
import com.cobblemon.mod.common.pokemon.Pokemon;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class SpawnRates {
    HashMap<String, Float> rarity = new HashMap();

    public void init() {
        ArrayList spawnDetails = new ArrayList(CobblemonSpawnPools.WORLD_SPAWN_POOL.getDetails());
        HashMap buckets = new HashMap();
        HashSet<String> pokemon = new HashSet<String>();
        for (SpawnBucket bucket : BestSpawner.INSTANCE.getConfig().getBuckets()) {
            buckets.put(bucket, new HashMap());
        }
        for (SpawnDetail detail : spawnDetails) {
            float weightMultiplier = 0.0f;
            for (WeightMultiplier multiplier : detail.getWeightMultipliers()) {
                if (!(multiplier.getMultiplier() > weightMultiplier)) continue;
                weightMultiplier = multiplier.getMultiplier();
            }
            float highestWeight = Math.max(detail.getWeight() * weightMultiplier, detail.getWeight());
            if (!((HashMap)buckets.get(detail.getBucket())).containsKey(detail.getName().getString()) || highestWeight > ((Float)((HashMap)buckets.get(detail.getBucket())).get(detail.getName().getString())).floatValue()) {
                ((HashMap)buckets.get(detail.getBucket())).put(detail.getName().getString(), Float.valueOf(highestWeight));
            }
            pokemon.add(detail.getName().getString());
        }
        HashMap<SpawnBucket, Float> totalWeights = new HashMap<SpawnBucket, Float>();
        for (SpawnBucket bucket : buckets.keySet()) {
            float bucketTotalWeight = 0.0f;
            Iterator<Object> iterator = new ArrayList(((HashMap)buckets.get(bucket)).values()).iterator();
            while (iterator.hasNext()) {
                float weight = ((Float)iterator.next()).floatValue();
                bucketTotalWeight += weight;
            }
            totalWeights.put(bucket, Float.valueOf(bucketTotalWeight));
        }
        for (String poke : pokemon) {
            BigDecimal highestWeight = new BigDecimal(0);
            for (SpawnBucket bucket : buckets.keySet()) {
                BigDecimal rarityInBucket;
                BigDecimal totalWeight;
                if (!((HashMap)buckets.get(bucket)).containsKey(poke) || (totalWeight = (rarityInBucket = new BigDecimal(((Float)((HashMap)buckets.get(bucket)).get(poke)).floatValue() / ((Float)totalWeights.get(bucket)).floatValue())).multiply(new BigDecimal(bucket.getWeight()))).compareTo(highestWeight) <= 0) continue;
                highestWeight = totalWeight;
            }
            this.rarity.put(poke, Float.valueOf(highestWeight.multiply(new BigDecimal(100)).floatValue()));
        }
    }

    public float getRarity(Pokemon pokemon) {
        return this.rarity.get(pokemon.getDisplayName().getString()) == null ? -1.0f : this.rarity.get(pokemon.getDisplayName().getString()).floatValue();
    }
}

