/*
 * Decompiled with CFR 0.152.
 */
package org.pokesplash.hunt.util;

import com.cobblemon.mod.common.api.permission.CobblemonPermission;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import org.pokesplash.hunt.Hunt;
import org.pokesplash.hunt.util.Subcommand;

public abstract class BaseCommand {
    private String commandString;
    private ArrayList<String> aliases;
    private CobblemonPermission permission;
    private ArrayList<Subcommand> subcommands;

    public BaseCommand(String commandString, List<String> aliases, CobblemonPermission permission, List<Subcommand> subcommands) {
        this.commandString = commandString;
        this.aliases = new ArrayList();
        this.aliases.addAll(aliases);
        this.permission = permission;
        this.subcommands = new ArrayList();
        this.subcommands.addAll(subcommands);
    }

    public void register(CommandDispatcher<class_2168> dispatcher) {
        this.createCommand(dispatcher);
    }

    private void createCommand(CommandDispatcher<class_2168> dispatcher) {
        LiteralCommandNode root = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)this.commandString).requires(ctx -> {
            if (ctx.method_43737()) {
                return Hunt.permissions.hasPermission(ctx.method_44023(), this.permission);
            }
            return true;
        })).executes(this::run)).build();
        dispatcher.getRoot().addChild((CommandNode)root);
        for (String alias : this.aliases) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)alias).requires(ctx -> {
                if (ctx.method_43737()) {
                    return Hunt.permissions.hasPermission(ctx.method_44023(), this.permission);
                }
                return true;
            })).redirect((CommandNode)root)).executes(this::run));
        }
        for (Subcommand subcommand : this.subcommands) {
            root.addChild(subcommand.build());
        }
    }

    public abstract int run(CommandContext<class_2168> var1);
}

