/*
 * Decompiled with CFR 0.152.
 */
package org.pokesplash.hunt.util;

import java.math.BigDecimal;
import java.util.UUID;
import net.impactdev.impactor.api.economy.EconomyService;
import net.impactdev.impactor.api.economy.accounts.Account;
import net.impactdev.impactor.api.economy.currency.Currency;
import net.impactdev.impactor.api.economy.transactions.EconomyTransaction;
import net.impactdev.impactor.api.economy.transactions.EconomyTransferTransaction;

public abstract class ImpactorService {
    private static EconomyService service = EconomyService.instance();
    private static Currency currency = service.currencies().primary();

    public static Account getAccount(UUID uuid) {
        if (!((Boolean)service.hasAccount(uuid).join()).booleanValue()) {
            return (Account)service.account(uuid).join();
        }
        return (Account)service.account(currency, uuid).join();
    }

    public static boolean add(Account account, double amount) {
        EconomyTransaction transaction = account.deposit(new BigDecimal(amount));
        return transaction.successful();
    }

    public static boolean remove(Account account, double amount) {
        EconomyTransaction transaction = account.withdraw(new BigDecimal(amount));
        return transaction.successful();
    }

    public static boolean transfer(Account sender, Account receiver, double amount) {
        EconomyTransferTransaction transaction = sender.transfer(receiver, new BigDecimal(amount));
        return transaction.successful();
    }
}

