/*
 * Decompiled with CFR 0.152.
 */
package org.pokesplash.hunt.util;

import com.cobblemon.mod.common.pokemon.Pokemon;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.CompletionHandler;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Scanner;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_3222;
import org.pokesplash.hunt.Hunt;
import org.pokesplash.hunt.hunts.SingleHunt;

public abstract class Utils {
    public static CompletableFuture<Boolean> writeFileAsync(String filePath, String filename, final String data) {
        final CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        Path path = Paths.get(new File("").getAbsolutePath() + filePath, filename);
        final File file = path.toFile();
        if (!Files.exists(path.getParent(), new LinkOption[0])) {
            file.getParentFile().mkdirs();
        }
        try (final AsynchronousFileChannel fileChannel = AsynchronousFileChannel.open(path, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            ByteBuffer buffer = ByteBuffer.wrap(data.getBytes(StandardCharsets.UTF_8));
            fileChannel.write(buffer, 0L, buffer, new CompletionHandler<Integer, ByteBuffer>(){

                @Override
                public void completed(Integer result, ByteBuffer attachment) {
                    attachment.clear();
                    try {
                        fileChannel.close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    future.complete(true);
                }

                @Override
                public void failed(Throwable exc, ByteBuffer attachment) {
                    future.complete(Utils.writeFileSync(file, data));
                }
            });
        }
        catch (IOException | SecurityException e) {
            Hunt.LOGGER.fatal("Unable to write file asynchronously, attempting sync write.");
            future.complete(future.complete(false));
        }
        return future;
    }

    public static boolean writeFileSync(File file, String data) {
        try {
            FileWriter writer = new FileWriter(file);
            writer.write(data);
            writer.close();
            return true;
        }
        catch (Exception e) {
            Hunt.LOGGER.fatal("Unable to write to file for hunt.\nStack Trace: ");
            e.printStackTrace();
            return false;
        }
    }

    public static CompletableFuture<Boolean> readFileAsync(String filePath, String filename, Consumer<String> callback) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Path path = Paths.get(new File("").getAbsolutePath() + filePath, filename);
        File file = path.toFile();
        if (!file.exists()) {
            future.complete(false);
            executor.shutdown();
            return future;
        }
        try (AsynchronousFileChannel fileChannel = AsynchronousFileChannel.open(path, StandardOpenOption.READ);){
            ByteBuffer buffer = ByteBuffer.allocate((int)fileChannel.size());
            Future<Integer> readResult = fileChannel.read(buffer, 0L);
            readResult.get();
            buffer.flip();
            byte[] bytes = new byte[buffer.remaining()];
            buffer.get(bytes);
            String fileContent = new String(bytes, StandardCharsets.UTF_8);
            callback.accept(fileContent);
            fileChannel.close();
            executor.shutdown();
            future.complete(true);
        }
        catch (Exception e) {
            future.complete(Utils.readFileSync(file, callback));
            executor.shutdown();
        }
        return future;
    }

    public static boolean readFileSync(File file, Consumer<String> callback) {
        try {
            Scanner reader = new Scanner(file);
            Object data = "";
            while (reader.hasNextLine()) {
                data = (String)data + reader.nextLine();
            }
            reader.close();
            callback.accept((String)data);
            return true;
        }
        catch (Exception e) {
            Hunt.LOGGER.fatal("Unable to read file " + file.getName() + " for hunt.\nStack Trace: ");
            e.printStackTrace();
            return false;
        }
    }

    public static Gson newGson() {
        return new GsonBuilder().setPrettyPrinting().create();
    }

    public static String formatMessage(String message, Boolean isPlayer) {
        if (isPlayer.booleanValue()) {
            return message.trim();
        }
        return message.replaceAll("\u00a7[0-9a-fk-or]", "").trim();
    }

    public static String parseLongDate(long time) {
        long second = 1000L;
        long minute = second * 60L;
        long hour = minute * 60L;
        long day = hour * 24L;
        long timeLeft = time;
        Object output = "";
        if (timeLeft > day) {
            output = (String)output + (time - time % day) / day + "d ";
            timeLeft %= day;
        }
        if (timeLeft > hour) {
            output = (String)output + (timeLeft - timeLeft % hour) / hour + "h ";
            timeLeft %= hour;
        }
        if (timeLeft > minute) {
            output = (String)output + (timeLeft - timeLeft % minute) / minute + "m ";
            timeLeft %= minute;
        }
        if (timeLeft > second) {
            output = (String)output + (timeLeft - timeLeft % second) / second + "s ";
            timeLeft %= second;
        }
        return output;
    }

    public static String capitaliseFirst(String message) {
        if (message.contains("[") || message.contains("]")) {
            return message.replaceAll("\\[|\\]", "");
        }
        if (message.contains("_")) {
            String[] messages = message.split("_");
            Object output = "";
            for (String msg : messages) {
                output = (String)output + Utils.capitaliseFirst(msg);
            }
            return output;
        }
        return message.substring(0, 1).toUpperCase() + message.substring(1).toLowerCase();
    }

    public static String formatPlaceholders(String message, class_3222 player, Pokemon pokemon, double price) {
        String newMessage = message;
        if (message == null) {
            return "";
        }
        if (player != null) {
            newMessage = newMessage.replaceAll("\\{player\\}", player.method_5477().getString());
        }
        if (pokemon != null) {
            newMessage = newMessage.replaceAll("\\{pokemon\\}", pokemon.getDisplayName().getString());
        }
        if (price != -1.0) {
            DecimalFormat df = new DecimalFormat("0.##");
            newMessage = newMessage.replaceAll("\\{price\\}", df.format(price));
        }
        return newMessage;
    }

    public static class_1799 parseItemId(String id) {
        class_2487 tag = new class_2487();
        tag.method_10582("id", id);
        tag.method_10569("Count", 1);
        return class_1799.method_7915((class_2487)tag);
    }

    public static void removeAllHunts() {
        if (Hunt.config.isIndividualHunts()) {
            for (UUID player : Hunt.manager.getPlayers()) {
                ArrayList copy = (ArrayList)new ArrayList<SingleHunt>(Hunt.manager.getPlayerHunts(player).getHunts().values()).clone();
                for (SingleHunt hunt : copy) {
                    if (hunt == null) continue;
                    hunt.getTimer().cancel();
                }
            }
        } else {
            ArrayList copy = (ArrayList)new ArrayList<SingleHunt>(Hunt.hunts.getHunts().values()).clone();
            for (SingleHunt hunt : copy) {
                if (hunt == null) continue;
                hunt.getTimer().cancel();
            }
        }
    }

    public static void runCommands(ArrayList<String> commands, class_3222 player, Pokemon pokemon, double price) {
        CommandDispatcher dispatcher = Hunt.server.method_3734().method_9235();
        for (String command : commands) {
            try {
                dispatcher.execute(Utils.formatPlaceholders(command, player, pokemon, price), (Object)Hunt.server.method_3739());
            }
            catch (CommandSyntaxException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

